/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.channel.epoll;

import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.DefaultSelectStrategyFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.MultithreadEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SelectStrategyFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.Epoll;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.EpollEventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.EventExecutor;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.RejectedExecutionHandler;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.RejectedExecutionHandlers;

public final class EpollEventLoopGroup
extends MultithreadEventLoopGroup {
    public EpollEventLoopGroup() {
        this(0);
    }

    public EpollEventLoopGroup(int nThreads) {
        this(nThreads, (ThreadFactory)null);
    }

    public EpollEventLoopGroup(int nThreads, SelectStrategyFactory selectStrategyFactory) {
        this(nThreads, null, selectStrategyFactory);
    }

    public EpollEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        this(nThreads, threadFactory, 0);
    }

    public EpollEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectStrategyFactory selectStrategyFactory) {
        this(nThreads, threadFactory, 0, selectStrategyFactory);
    }

    @Deprecated
    public EpollEventLoopGroup(int nThreads, ThreadFactory threadFactory, int maxEventsAtOnce) {
        this(nThreads, threadFactory, maxEventsAtOnce, DefaultSelectStrategyFactory.INSTANCE);
    }

    @Deprecated
    public EpollEventLoopGroup(int nThreads, ThreadFactory threadFactory, int maxEventsAtOnce, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, threadFactory, maxEventsAtOnce, selectStrategyFactory, RejectedExecutionHandlers.reject());
        Epoll.ensureAvailability();
    }

    public EpollEventLoopGroup(int nThreads, ThreadFactory threadFactory, int maxEventsAtOnce, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(nThreads, threadFactory, maxEventsAtOnce, selectStrategyFactory, rejectedExecutionHandler);
        Epoll.ensureAvailability();
    }

    public void setIoRatio(int ioRatio) {
        for (EventExecutor e : this.children()) {
            ((EpollEventLoop)e).setIoRatio(ioRatio);
        }
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, Object ... args) throws Exception {
        return new EpollEventLoop((EventLoopGroup)this, threadFactory, (Integer)args[0], ((SelectStrategyFactory)args[1]).newSelectStrategy(), (RejectedExecutionHandler)args[2]);
    }
}

