/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.org.apache.avro.util.Utf8;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInited;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobInitedEvent
implements HistoryEvent {
    private JobInited datum = new JobInited();

    public JobInitedEvent(JobID id, long launchTime, int totalMaps, int totalReduces, String jobStatus, boolean uberized) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.launchTime = launchTime;
        this.datum.totalMaps = totalMaps;
        this.datum.totalReduces = totalReduces;
        this.datum.jobStatus = new Utf8(jobStatus);
        this.datum.uberized = uberized;
    }

    JobInitedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobInited)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public long getLaunchTime() {
        return this.datum.launchTime;
    }

    public int getTotalMaps() {
        return this.datum.totalMaps;
    }

    public int getTotalReduces() {
        return this.datum.totalReduces;
    }

    public String getStatus() {
        return this.datum.jobStatus.toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_INITED;
    }

    public boolean getUberized() {
        return this.datum.uberized;
    }
}

