/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Objects;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AclStatus {
    private final String owner;
    private final String group;
    private final boolean stickyBit;
    private final List<AclEntry> entries;

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isStickyBit() {
        return this.stickyBit;
    }

    public List<AclEntry> getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AclStatus other = (AclStatus)o;
        return Objects.equal(this.owner, other.owner) && Objects.equal(this.group, other.group) && this.stickyBit == other.stickyBit && Objects.equal(this.entries, other.entries);
    }

    public int hashCode() {
        return Objects.hashCode(this.owner, this.group, this.stickyBit, this.entries);
    }

    public String toString() {
        return "owner: " + this.owner + ", group: " + this.group + ", acl: {" + "entries: " + this.entries + ", stickyBit: " + this.stickyBit + '}';
    }

    private AclStatus(String owner, String group, boolean stickyBit, Iterable<AclEntry> entries) {
        this.owner = owner;
        this.group = group;
        this.stickyBit = stickyBit;
        this.entries = Lists.newArrayList(entries);
    }

    public static class Builder {
        private String owner;
        private String group;
        private boolean stickyBit;
        private List<AclEntry> entries = Lists.newArrayList();

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder addEntry(AclEntry e) {
            this.entries.add(e);
            return this;
        }

        public Builder addEntries(Iterable<AclEntry> entries) {
            for (AclEntry e : entries) {
                this.entries.add(e);
            }
            return this;
        }

        public Builder stickyBit(boolean stickyBit) {
            this.stickyBit = stickyBit;
            return this;
        }

        public AclStatus build() {
            return new AclStatus(this.owner, this.group, this.stickyBit, this.entries);
        }
    }
}

