/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RandomRowFilter
extends FilterBase {
    protected static final Random random = new Random();
    protected float chance;
    protected boolean filterOutRow;

    public RandomRowFilter(float chance) {
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.filterOutRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public boolean filterRow() {
        return this.filterOutRow;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        this.filterOutRow = this.chance < 0.0f ? true : (this.chance > 1.0f ? false : !(random.nextFloat() < this.chance));
        return this.filterOutRow;
    }

    @Override
    public void reset() {
        this.filterOutRow = false;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.RandomRowFilter.Builder builder = FilterProtos.RandomRowFilter.newBuilder();
        builder.setChance(this.chance);
        return builder.build().toByteArray();
    }

    public static RandomRowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.RandomRowFilter proto;
        try {
            proto = FilterProtos.RandomRowFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new RandomRowFilter(proto.getChance());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomRowFilter)) {
            return false;
        }
        RandomRowFilter other = (RandomRowFilter)o;
        return this.getChance() == other.getChance();
    }
}

