/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ConvergenceException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.DerivativeException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.IntegratorException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.events.EventException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.events.EventHandler;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.events.EventState;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.ode.sampling.StepInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CombinedEventsManager {
    private final List<EventState> states = new ArrayList<EventState>();
    private EventState first = null;
    private boolean initialized = false;

    public void addEventHandler(EventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.states.add(new EventState(handler, maxCheckInterval, convergence, maxIterationCount));
    }

    public Collection<EventHandler> getEventsHandlers() {
        ArrayList<EventHandler> list = new ArrayList<EventHandler>();
        for (EventState state : this.states) {
            list.add(state.getEventHandler());
        }
        return Collections.unmodifiableCollection(list);
    }

    public void clearEventsHandlers() {
        this.states.clear();
    }

    public Collection<EventState> getEventsStates() {
        return this.states;
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    public boolean evaluateStep(StepInterpolator interpolator) throws DerivativeException, IntegratorException {
        try {
            this.first = null;
            if (this.states.isEmpty()) {
                return false;
            }
            if (!this.initialized) {
                for (EventState state : this.states) {
                    state.reinitializeBegin(interpolator);
                }
                this.initialized = true;
            }
            for (EventState state : this.states) {
                if (!state.evaluateStep(interpolator)) continue;
                if (this.first == null) {
                    this.first = state;
                    continue;
                }
                if (interpolator.isForward()) {
                    if (!(state.getEventTime() < this.first.getEventTime())) continue;
                    this.first = state;
                    continue;
                }
                if (!(state.getEventTime() > this.first.getEventTime())) continue;
                this.first = state;
            }
            return this.first != null;
        }
        catch (EventException se) {
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DerivativeException) {
                throw (DerivativeException)cause;
            }
            throw new IntegratorException(se);
        }
        catch (ConvergenceException ce) {
            throw new IntegratorException(ce);
        }
    }

    public double getEventTime() {
        return this.first == null ? Double.NaN : this.first.getEventTime();
    }

    public void stepAccepted(double t, double[] y) throws IntegratorException {
        try {
            for (EventState state : this.states) {
                state.stepAccepted(t, y);
            }
        }
        catch (EventException se) {
            throw new IntegratorException(se);
        }
    }

    public boolean stop() {
        for (EventState state : this.states) {
            if (!state.stop()) continue;
            return true;
        }
        return false;
    }

    public boolean reset(double t, double[] y) throws IntegratorException {
        try {
            boolean resetDerivatives = false;
            for (EventState state : this.states) {
                if (!state.reset(t, y)) continue;
                resetDerivatives = true;
            }
            return resetDerivatives;
        }
        catch (EventException se) {
            throw new IntegratorException(se);
        }
    }
}

