/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReplicationAdmin
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationAdmin.class);
    public static final String TNAME = "tableName";
    public static final String CFNAME = "columnFamlyName";
    public static final String REPLICATION_WALENTRYFILTER_CONFIG_KEY = "hbase.replication.source.custom.walentryfilters";
    public static final String REPLICATIONTYPE = "replicationType";
    public static final String REPLICATIONGLOBAL = Integer.toString(1);
    private final Connection connection;
    private final ReplicationQueuesClient replicationQueuesClient;
    private final ReplicationPeers replicationPeers;
    private final ZooKeeperWatcher zkw;

    public ReplicationAdmin(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.replication", true)) {
            throw new RuntimeException("hbase.replication isn't true, please enable it in order to use replication");
        }
        this.connection = ConnectionFactory.createConnection(conf);
        try {
            this.zkw = this.createZooKeeperWatcher();
            try {
                this.replicationQueuesClient = ReplicationFactory.getReplicationQueuesClient(this.zkw, conf, this.connection);
                this.replicationQueuesClient.init();
                this.replicationPeers = ReplicationFactory.getReplicationPeers(this.zkw, conf, this.replicationQueuesClient, this.connection);
                this.replicationPeers.init();
            }
            catch (Exception exception) {
                if (this.zkw != null) {
                    this.zkw.close();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            if (this.connection != null) {
                this.connection.close();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IOException("Error initializing the replication admin client.", exception);
        }
    }

    private ZooKeeperWatcher createZooKeeperWatcher() throws IOException {
        return new ZooKeeperWatcher(this.connection.getConfiguration(), "ReplicationAdmin", new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.error((Object)why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        });
    }

    @Deprecated
    public void addPeer(String id, String clusterKey) throws ReplicationException {
        this.addPeer(id, new ReplicationPeerConfig().setClusterKey(clusterKey), null);
    }

    @Deprecated
    public void addPeer(String id, String clusterKey, String tableCFs) throws ReplicationException {
        this.addPeer(id, new ReplicationPeerConfig().setClusterKey(clusterKey), ReplicationAdmin.parseTableCFsFromConfig(tableCFs));
    }

    public void addPeer(String id, ReplicationPeerConfig peerConfig, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        if (tableCfs != null) {
            peerConfig.setTableCFsMap(tableCfs);
        }
        this.checkConfiguredWALEntryFilters(peerConfig);
        this.replicationPeers.addPeer(id, peerConfig);
    }

    public void addPeer(String id, ReplicationPeerConfig peerConfig) throws ReplicationException {
        this.checkConfiguredWALEntryFilters(peerConfig);
        this.replicationPeers.addPeer(id, peerConfig);
    }

    public void updatePeerConfig(String id, ReplicationPeerConfig peerConfig) throws ReplicationException {
        this.checkConfiguredWALEntryFilters(peerConfig);
        this.replicationPeers.updatePeerConfig(id, peerConfig);
    }

    public static Map<TableName, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        return ReplicationSerDeHelper.parseTableCFsFromConfig(tableCFsConfig);
    }

    @VisibleForTesting
    static String getTableCfsStr(Map<TableName, ? extends Collection<String>> tableCfs) {
        String tableCfsStr = null;
        if (tableCfs != null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(";");
                }
                builder.append(entry.getKey());
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                builder.append(":");
                builder.append(StringUtils.join(entry.getValue(), ","));
            }
            tableCfsStr = builder.toString();
        }
        return tableCfsStr;
    }

    public void removePeer(String id) throws ReplicationException {
        this.replicationPeers.removePeer(id);
    }

    public void enablePeer(String id) throws ReplicationException {
        this.replicationPeers.enablePeer(id);
    }

    public void disablePeer(String id) throws ReplicationException {
        this.replicationPeers.disablePeer(id);
    }

    public int getPeersCount() {
        return this.replicationPeers.getAllPeerIds().size();
    }

    @Deprecated
    public Map<String, String> listPeers() {
        Map<String, ReplicationPeerConfig> peers = this.listPeerConfigs();
        HashMap<String, String> ret = new HashMap<String, String>(peers.size());
        for (Map.Entry<String, ReplicationPeerConfig> entry : peers.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getClusterKey());
        }
        return ret;
    }

    public Map<String, ReplicationPeerConfig> listPeerConfigs() {
        return this.replicationPeers.getAllPeerConfigs();
    }

    public ReplicationPeerConfig getPeerConfig(String id) throws ReplicationException {
        return this.replicationPeers.getReplicationPeerConfig(id);
    }

    public String getPeerTableCFs(String id) throws ReplicationException {
        return ReplicationSerDeHelper.convertToString(this.replicationPeers.getPeerTableCFsConfig(id));
    }

    @Deprecated
    public void setPeerTableCFs(String id, String tableCFs) throws ReplicationException {
        this.setPeerTableCFs(id, ReplicationAdmin.parseTableCFsFromConfig(tableCFs));
    }

    public void appendPeerTableCFs(String id, String tableCfs) throws ReplicationException {
        this.appendPeerTableCFs(id, ReplicationSerDeHelper.parseTableCFsFromConfig(tableCfs));
    }

    public void appendPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        if (tableCfs == null) {
            throw new ReplicationException("tableCfs is null");
        }
        Map<TableName, List<String>> preTableCfs = this.replicationPeers.getPeerTableCFsConfig(id);
        if (preTableCfs == null) {
            this.setPeerTableCFs(id, tableCfs);
            return;
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection<String> appendCfs = entry.getValue();
            if (preTableCfs.containsKey(table)) {
                List<String> cfs = preTableCfs.get(table);
                if (cfs == null || appendCfs == null) {
                    preTableCfs.put(table, null);
                    continue;
                }
                HashSet<String> cfSet = new HashSet<String>(cfs);
                cfSet.addAll(appendCfs);
                preTableCfs.put(table, Lists.newArrayList(cfSet));
                continue;
            }
            if (appendCfs == null || appendCfs.isEmpty()) {
                preTableCfs.put(table, null);
                continue;
            }
            preTableCfs.put(table, Lists.newArrayList(appendCfs));
        }
        this.setPeerTableCFs(id, preTableCfs);
    }

    public void removePeerTableCFs(String id, String tableCf) throws ReplicationException {
        this.removePeerTableCFs(id, ReplicationSerDeHelper.parseTableCFsFromConfig(tableCf));
    }

    public void removePeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        if (tableCfs == null) {
            throw new ReplicationException("tableCfs is null");
        }
        Map<TableName, List<String>> preTableCfs = this.replicationPeers.getPeerTableCFsConfig(id);
        if (preTableCfs == null) {
            throw new ReplicationException("Table-Cfs for peer" + id + " is null");
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection<String> removeCfs = entry.getValue();
            if (preTableCfs.containsKey(table)) {
                List<String> cfs = preTableCfs.get(table);
                if (cfs == null && removeCfs == null) {
                    preTableCfs.remove(table);
                    continue;
                }
                if (cfs != null && removeCfs != null) {
                    HashSet<String> cfSet = new HashSet<String>(cfs);
                    cfSet.removeAll(removeCfs);
                    if (cfSet.isEmpty()) {
                        preTableCfs.remove(table);
                        continue;
                    }
                    preTableCfs.put(table, Lists.newArrayList(cfSet));
                    continue;
                }
                if (cfs == null && removeCfs != null) {
                    throw new ReplicationException("Cannot remove cf of table: " + table + " which doesn't specify cfs from table-cfs config in peer: " + id);
                }
                if (cfs == null || removeCfs != null) continue;
                throw new ReplicationException("Cannot remove table: " + table + " which has specified cfs from table-cfs config in peer: " + id);
            }
            throw new ReplicationException("No table: " + table + " in table-cfs config of peer: " + id);
        }
        this.setPeerTableCFs(id, preTableCfs);
    }

    public void setPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        this.replicationPeers.setPeerTableCFsConfig(id, tableCfs);
    }

    public boolean getPeerState(String id) throws ReplicationException {
        return this.replicationPeers.getStatusOfPeerFromBackingStore(id);
    }

    @Override
    public void close() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HashMap<String, String>> listReplicated() throws IOException {
        HTableDescriptor[] tables;
        ArrayList<HashMap<String, String>> replicationColFams = new ArrayList<HashMap<String, String>>();
        try (Admin admin = this.connection.getAdmin();){
            tables = admin.listTables();
        }
        for (HTableDescriptor table : tables) {
            HColumnDescriptor[] columns = table.getColumnFamilies();
            String tableName = table.getNameAsString();
            for (HColumnDescriptor column : columns) {
                if (column.getScope() == 0) continue;
                HashMap<String, String> replicationEntry = new HashMap<String, String>();
                replicationEntry.put(TNAME, tableName);
                replicationEntry.put(CFNAME, column.getNameAsString());
                replicationEntry.put(REPLICATIONTYPE, REPLICATIONGLOBAL);
                replicationColFams.add(replicationEntry);
            }
        }
        return replicationColFams;
    }

    public void enableTableRep(TableName tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name cannot be null");
        }
        try (Admin admin = this.connection.getAdmin();){
            if (!admin.tableExists(tableName)) {
                throw new TableNotFoundException("Table '" + tableName.getNameAsString() + "' does not exists.");
            }
        }
        byte[][] splits = this.getTableSplitRowKeys(tableName);
        this.checkAndSyncTableDescToPeers(tableName, splits);
        this.setTableRep(tableName, true);
    }

    public void disableTableRep(TableName tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name is null");
        }
        try (Admin admin = this.connection.getAdmin();){
            if (!admin.tableExists(tableName)) {
                throw new TableNotFoundException("Table '" + tableName.getNamespaceAsString() + "' does not exists.");
            }
        }
        this.setTableRep(tableName, false);
    }

    private byte[][] getTableSplitRowKeys(TableName tableName) throws IOException {
        try (RegionLocator locator = this.connection.getRegionLocator(tableName);){
            byte[][] startKeys = locator.getStartKeys();
            if (startKeys.length == 1) {
                byte[][] byArray = null;
                return byArray;
            }
            byte[][] splits = new byte[startKeys.length - 1][];
            for (int i = 1; i < startKeys.length; ++i) {
                splits[i - 1] = startKeys[i];
            }
            byte[][] byArrayArray = splits;
            return byArrayArray;
        }
    }

    private void checkAndSyncTableDescToPeers(TableName tableName, byte[][] splits) throws IOException {
        List<ReplicationPeer> repPeers = this.listReplicationPeers();
        if (repPeers == null || repPeers.size() <= 0) {
            throw new IllegalArgumentException("Found no peer cluster for replication.");
        }
        TableName onlyTableNameQualifier = TableName.valueOf(tableName.getQualifierAsString());
        for (ReplicationPeer repPeer : repPeers) {
            Map<TableName, List<String>> tableCFMap = repPeer.getTableCFs();
            if (tableCFMap != null && !tableCFMap.containsKey(onlyTableNameQualifier)) continue;
            Configuration peerConf = repPeer.getConfiguration();
            HTableDescriptor localHtd = null;
            Connection conn = ConnectionFactory.createConnection(peerConf);
            Throwable throwable = null;
            try {
                Admin admin = this.connection.getAdmin();
                Throwable throwable2 = null;
                try {
                    Admin repHBaseAdmin = conn.getAdmin();
                    Throwable throwable3 = null;
                    try {
                        localHtd = admin.getTableDescriptor(tableName);
                        HTableDescriptor peerHtd = null;
                        if (!repHBaseAdmin.tableExists(tableName)) {
                            repHBaseAdmin.createTable(localHtd, splits);
                            continue;
                        }
                        peerHtd = repHBaseAdmin.getTableDescriptor(tableName);
                        if (peerHtd == null) {
                            throw new IllegalArgumentException("Failed to get table descriptor for table " + tableName.getNameAsString() + " from peer cluster " + repPeer.getId());
                        }
                        if (this.compareForReplication(peerHtd, localHtd)) continue;
                        throw new IllegalArgumentException("Table " + tableName.getNameAsString() + " exists in peer cluster " + repPeer.getId() + ", but the table descriptors are not same when compared with source cluster." + " Thus can not enable the table's replication switch.");
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (repHBaseAdmin == null) continue;
                        if (throwable3 != null) {
                            try {
                                repHBaseAdmin.close();
                            }
                            catch (Throwable x2) {
                                throwable3.addSuppressed(x2);
                            }
                            continue;
                        }
                        repHBaseAdmin.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (admin == null) continue;
                    if (throwable2 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                        continue;
                    }
                    admin.close();
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (conn == null) continue;
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                conn.close();
            }
        }
    }

    @VisibleForTesting
    public void peerAdded(String id) throws ReplicationException {
        this.replicationPeers.peerAdded(id);
    }

    @VisibleForTesting
    List<ReplicationPeer> listReplicationPeers() {
        Map<String, ReplicationPeerConfig> peers = this.listPeerConfigs();
        if (peers == null || peers.size() <= 0) {
            return null;
        }
        ArrayList<ReplicationPeer> listOfPeers = new ArrayList<ReplicationPeer>(peers.size());
        for (Map.Entry<String, ReplicationPeerConfig> peerEntry : peers.entrySet()) {
            String peerId = peerEntry.getKey();
            try {
                Pair<ReplicationPeerConfig, Configuration> pair = this.replicationPeers.getPeerConf(peerId);
                Configuration peerConf = pair.getSecond();
                ReplicationPeerZKImpl peer = new ReplicationPeerZKImpl(this.zkw, pair.getSecond(), peerId, pair.getFirst(), this.connection);
                listOfPeers.add(peer);
            }
            catch (ReplicationException e) {
                LOG.warn((Object)("Failed to get valid replication peers. Error connecting to peer cluster with peerId=" + peerId + ". Error message=" + e.getMessage()));
                LOG.debug((Object)"Failure details to get valid replication peers.", (Throwable)e);
            }
        }
        return listOfPeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableRep(TableName tableName, boolean enableRep) throws IOException {
        Admin admin = null;
        try {
            admin = this.connection.getAdmin();
            HTableDescriptor htd = admin.getTableDescriptor(tableName);
            ReplicationState currentReplicationState = this.getTableReplicationState(htd);
            if (enableRep && currentReplicationState != ReplicationState.ENABLED || !enableRep && currentReplicationState != ReplicationState.DISABLED) {
                boolean isOnlineSchemaUpdateEnabled = this.connection.getConfiguration().getBoolean("hbase.online.schema.update.enable", true);
                if (!isOnlineSchemaUpdateEnabled) {
                    admin.disableTable(tableName);
                }
                for (HColumnDescriptor hcd : htd.getFamilies()) {
                    hcd.setScope(enableRep ? 1 : 0);
                }
                admin.modifyTable(tableName, htd);
                if (!isOnlineSchemaUpdateEnabled) {
                    admin.enableTable(tableName);
                }
            }
        }
        finally {
            if (admin != null) {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Failed to close admin connection.");
                    LOG.debug((Object)"Details on failure to close admin connection.", (Throwable)e);
                }
            }
        }
    }

    private ReplicationState getTableReplicationState(HTableDescriptor htd) {
        boolean hasEnabled = false;
        boolean hasDisabled = false;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            if (hcd.getScope() != 1) {
                hasDisabled = true;
                continue;
            }
            hasEnabled = true;
        }
        if (hasEnabled && hasDisabled) {
            return ReplicationState.MIXED;
        }
        if (hasEnabled) {
            return ReplicationState.ENABLED;
        }
        return ReplicationState.DISABLED;
    }

    private void checkConfiguredWALEntryFilters(ReplicationPeerConfig peerConfig) throws ReplicationException {
        String filterCSV = peerConfig.getConfiguration().get(REPLICATION_WALENTRYFILTER_CONFIG_KEY);
        if (filterCSV != null && !filterCSV.isEmpty()) {
            String[] filters;
            for (String filter : filters = filterCSV.split(",")) {
                try {
                    Class<?> clazz = Class.forName(filter);
                    Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new ReplicationException("Configured WALEntryFilter " + filter + " could not be created. Failing add/update " + "peer operation.", e);
                }
            }
        }
    }

    private boolean copyReplicationScope(HTableDescriptor peerHtd, HTableDescriptor localHtd) {
        int result = peerHtd.getTableName().compareTo(localHtd.getTableName());
        if (result == 0) {
            Iterator<HColumnDescriptor> remoteHCDIter = peerHtd.getFamilies().iterator();
            Iterator<HColumnDescriptor> localHCDIter = localHtd.getFamilies().iterator();
            while (remoteHCDIter.hasNext() && localHCDIter.hasNext()) {
                String localHCDName;
                HColumnDescriptor remoteHCD = remoteHCDIter.next();
                HColumnDescriptor localHCD = localHCDIter.next();
                String remoteHCDName = remoteHCD.getNameAsString();
                if (remoteHCDName.equals(localHCDName = localHCD.getNameAsString())) {
                    remoteHCD.setScope(localHCD.getScope());
                    continue;
                }
                result = -1;
                break;
            }
            if (remoteHCDIter.hasNext() || localHCDIter.hasNext()) {
                return false;
            }
        }
        return result == 0;
    }

    private boolean compareForReplication(HTableDescriptor peerHtd, HTableDescriptor localHtd) {
        if (peerHtd == null) {
            return false;
        }
        if (peerHtd.equals(localHtd)) {
            return true;
        }
        boolean result = false;
        HTableDescriptor peerHtdCopy = new HTableDescriptor(peerHtd);
        result = this.copyReplicationScope(peerHtdCopy, localHtd);
        if (result) {
            result = peerHtdCopy.compareTo(localHtd) == 0;
        }
        return result;
    }

    private static enum ReplicationState {
        ENABLED,
        MIXED,
        DISABLED;

    }
}

