/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private final MetricsMasterWrapper masterWrapper;
    private MutableFastCounter clusterRequestsCounter;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
    }

    @Override
    public void incRequests(long inc) {
        this.clusterRequestsCounter.incr(inc);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge(Interns.info("mergePlanCount", "Number of Region Merge Plans executed"), this.masterWrapper.getMergePlanCount()).addGauge(Interns.info("splitPlanCount", "Number of Region Split Plans executed"), this.masterWrapper.getSplitPlanCount()).addGauge(Interns.info("masterActiveTime", "Master Active Time"), this.masterWrapper.getActiveTime()).addGauge(Interns.info("masterStartTime", "Master Start Time"), this.masterWrapper.getStartTime()).addGauge(Interns.info("masterFinishedInitializationTime", "Timestamp when Master has finished initializing"), this.masterWrapper.getMasterInitializationTime()).addGauge(Interns.info("averageLoad", "AverageLoad"), this.masterWrapper.getAverageLoad()).tag(Interns.info("liveRegionServers", "Names of live RegionServers"), this.masterWrapper.getRegionServers()).addGauge(Interns.info("numRegionServers", "Number of RegionServers"), this.masterWrapper.getNumRegionServers()).tag(Interns.info("deadRegionServers", "Names of dead RegionServers"), this.masterWrapper.getDeadRegionServers()).addGauge(Interns.info("numDeadRegionServers", "Number of dead RegionServers"), this.masterWrapper.getNumDeadRegionServers()).tag(Interns.info("zookeeperQuorum", "Zookeeper Quorum"), this.masterWrapper.getZookeeperQuorum()).tag(Interns.info("serverName", "Server Name"), this.masterWrapper.getServerName()).tag(Interns.info("clusterId", "Cluster Id"), this.masterWrapper.getClusterId()).tag(Interns.info("isActiveMaster", "Is Active Master"), String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }
}

