/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.impl.HBaseMetrics2HadoopMetricsAdapter;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Optional;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.reflect.FieldUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystemHelper;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;

public class GlobalMetricRegistriesAdapter {
    private static final Log LOG = LogFactory.getLog(GlobalMetricRegistriesAdapter.class);
    private final MetricsExecutor executor = new MetricsExecutorImpl();
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final DefaultMetricsSystemHelper helper;
    private final HBaseMetrics2HadoopMetricsAdapter metricsAdapter = new HBaseMetrics2HadoopMetricsAdapter();
    private final HashMap<MetricRegistryInfo, MetricsSourceAdapter> registeredSources = new HashMap();

    private GlobalMetricRegistriesAdapter() {
        this.helper = new DefaultMetricsSystemHelper();
        this.executor.getExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                GlobalMetricRegistriesAdapter.this.doRun();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public static GlobalMetricRegistriesAdapter init() {
        return new GlobalMetricRegistriesAdapter();
    }

    @VisibleForTesting
    public void stop() {
        this.stopped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.stopped.get()) {
            this.executor.stop();
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("doRun called: " + this.registeredSources));
        }
        Collection<MetricRegistry> registries = MetricRegistries.global().getMetricRegistries();
        for (MetricRegistry registry : registries) {
            MetricRegistryInfo info = registry.getMetricRegistryInfo();
            if (info.isExistingSource() || this.registeredSources.containsKey(info)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering adapter for the MetricRegistry: " + info.getMetricsJmxContext()));
            }
            MetricsSourceAdapter adapter = new MetricsSourceAdapter(registry);
            LOG.info((Object)("Registering " + info.getMetricsJmxContext() + " " + info.getMetricsDescription()));
            DefaultMetricsSystem.instance().register(info.getMetricsJmxContext(), info.getMetricsDescription(), adapter);
            this.registeredSources.put(info, adapter);
        }
        boolean removed = false;
        Iterator<Map.Entry<MetricRegistryInfo, MetricsSourceAdapter>> it = this.registeredSources.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MetricRegistryInfo, MetricsSourceAdapter> entry = it.next();
            MetricRegistryInfo info = entry.getKey();
            Optional<MetricRegistry> found = MetricRegistries.global().get(info);
            if (found.isPresent()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing adapter for the MetricRegistry: " + info.getMetricsJmxContext()));
            }
            MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
            synchronized (metricsSystem) {
                this.unregisterSource(info);
                this.helper.removeSourceName(info.getMetricsJmxContext());
                this.helper.removeObjectName(info.getMetricsJmxContext());
                it.remove();
                removed = true;
            }
        }
        if (removed) {
            JmxCacheBuster.clearJmxCache();
        }
    }

    @VisibleForTesting
    protected void unregisterSource(MetricRegistryInfo info) {
        MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
        if (metricsSystem instanceof MetricsSystemImpl) {
            try {
                Map allSources;
                Map sources = (Map)FieldUtils.readField(metricsSystem, "sources", true);
                String sourceName = info.getMetricsJmxContext();
                if (sources.containsKey(sourceName)) {
                    Object sourceAdapter = sources.get(sourceName);
                    Method method = null;
                    try {
                        method = sourceAdapter.getClass().getDeclaredMethod("stop", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        LOG.info((Object)"Stop method not found on MetricsSourceAdapter");
                    }
                    catch (SecurityException e) {
                        LOG.info((Object)"Don't have access to call stop method not found on MetricsSourceAdapter", (Throwable)e);
                    }
                    if (method != null) {
                        method.setAccessible(true);
                        try {
                            method.invoke(sourceAdapter, new Object[0]);
                        }
                        catch (IllegalArgumentException | InvocationTargetException e) {
                            LOG.warn((Object)("Couldn't invoke stop on metrics source adapter: " + sourceName));
                            e.printStackTrace();
                        }
                    }
                    sources.remove(sourceName);
                }
                if ((allSources = (Map)FieldUtils.readField(metricsSystem, "allSources", true)).containsKey(sourceName)) {
                    allSources.remove(sourceName);
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Error unregistering metric source " + info.getMetricsJmxContext()));
            }
        }
    }

    private class MetricsSourceAdapter
    implements MetricsSource {
        private final MetricRegistry registry;

        MetricsSourceAdapter(MetricRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void getMetrics(MetricsCollector collector, boolean all) {
            GlobalMetricRegistriesAdapter.this.metricsAdapter.snapshotAllMetrics(this.registry, collector);
        }
    }
}

