/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.GeneratedMessage;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PrettyPrinter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HColumnDescriptor
implements WritableComparable<HColumnDescriptor> {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 11;
    public static final String COMPRESSION = "COMPRESSION";
    public static final String COMPRESSION_COMPACT = "COMPRESSION_COMPACT";
    public static final String ENCODE_ON_DISK = "ENCODE_ON_DISK";
    public static final String DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING";
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String CACHE_DATA_ON_WRITE = "CACHE_DATA_ON_WRITE";
    public static final String CACHE_INDEX_ON_WRITE = "CACHE_INDEX_ON_WRITE";
    public static final String CACHE_BLOOMS_ON_WRITE = "CACHE_BLOOMS_ON_WRITE";
    public static final String EVICT_BLOCKS_ON_CLOSE = "EVICT_BLOCKS_ON_CLOSE";
    public static final String CACHE_DATA_IN_L1 = "CACHE_DATA_IN_L1";
    public static final String PREFETCH_BLOCKS_ON_OPEN = "PREFETCH_BLOCKS_ON_OPEN";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String LENGTH = "LENGTH";
    public static final String TTL = "TTL";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String FOREVER = "FOREVER";
    public static final String REPLICATION_SCOPE = "REPLICATION_SCOPE";
    public static final byte[] REPLICATION_SCOPE_BYTES = Bytes.toBytes("REPLICATION_SCOPE");
    public static final String MIN_VERSIONS = "MIN_VERSIONS";
    public static final String KEEP_DELETED_CELLS = "KEEP_DELETED_CELLS";
    public static final String COMPRESS_TAGS = "COMPRESS_TAGS";
    public static final String ENCRYPTION = "ENCRYPTION";
    public static final String ENCRYPTION_KEY = "ENCRYPTION_KEY";
    public static final String DFS_REPLICATION = "DFS_REPLICATION";
    public static final short DEFAULT_DFS_REPLICATION = 0;
    public static final String DEFAULT_COMPRESSION = Compression.Algorithm.NONE.getName();
    public static final boolean DEFAULT_ENCODE_ON_DISK = true;
    public static final String DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.NONE.toString();
    public static final int DEFAULT_VERSIONS = HBaseConfiguration.create().getInt("hbase.column.max.version", 1);
    public static final int DEFAULT_MIN_VERSIONS = 0;
    private volatile Integer blocksize = null;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final KeepDeletedCells DEFAULT_KEEP_DELETED = KeepDeletedCells.FALSE;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_DATA_IN_L1 = false;
    public static final boolean DEFAULT_CACHE_INDEX_ON_WRITE = false;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final String DEFAULT_BLOOMFILTER = BloomType.ROW.toString();
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    public static final int DEFAULT_REPLICATION_SCOPE = 0;
    public static final boolean DEFAULT_EVICT_BLOCKS_ON_CLOSE = false;
    public static final boolean DEFAULT_COMPRESS_TAGS = true;
    public static final boolean DEFAULT_PREFETCH_BLOCKS_ON_OPEN = false;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<ImmutableBytesWritable> RESERVED_KEYWORDS = new HashSet<ImmutableBytesWritable>();
    private static final int UNINITIALIZED = -1;
    private byte[] name;
    private final Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private final Map<String, String> configuration = new HashMap<String, String>();
    private int cachedMaxVersions = -1;

    @Deprecated
    public HColumnDescriptor() {
        this.name = null;
    }

    public HColumnDescriptor(String familyName) {
        this(Bytes.toBytes(familyName));
    }

    public HColumnDescriptor(byte[] familyName) {
        this(familyName == null || familyName.length <= 0 ? HConstants.EMPTY_BYTE_ARRAY : familyName, DEFAULT_VERSIONS, DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, DEFAULT_BLOOMFILTER);
    }

    public HColumnDescriptor(HColumnDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : desc.values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : desc.configuration.entrySet()) {
            this.configuration.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.setMaxVersions(desc.getMaxVersions());
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int timeToLive, String bloomFilter) {
        this(familyName, maxVersions, compression, inMemory, blockCacheEnabled, 65536, timeToLive, bloomFilter, 0);
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        this(familyName, 0, maxVersions, DEFAULT_KEEP_DELETED, compression, true, DEFAULT_DATA_BLOCK_ENCODING, inMemory, blockCacheEnabled, blocksize, timeToLive, bloomFilter, scope);
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int minVersions, int maxVersions, KeepDeletedCells keepDeletedCells, String compression, boolean encodeOnDisk, String dataBlockEncoding, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        HColumnDescriptor.isLegalFamilyName(familyName);
        this.name = familyName;
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        if (minVersions > 0) {
            if (timeToLive == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Minimum versions requires TTL.");
            }
            if (minVersions >= maxVersions) {
                throw new IllegalArgumentException("Minimum versions must be < maximum versions.");
            }
        }
        this.setMaxVersions(maxVersions);
        this.setMinVersions(minVersions);
        this.setKeepDeletedCells(keepDeletedCells);
        this.setInMemory(inMemory);
        this.setBlockCacheEnabled(blockCacheEnabled);
        this.setTimeToLive(timeToLive);
        this.setCompressionType(Compression.Algorithm.valueOf(compression.toUpperCase(Locale.ROOT)));
        this.setDataBlockEncoding(DataBlockEncoding.valueOf(dataBlockEncoding.toUpperCase(Locale.ROOT)));
        this.setBloomFilterType(BloomType.valueOf(bloomFilter.toUpperCase(Locale.ROOT)));
        this.setBlocksize(blocksize);
        this.setScope(scope);
    }

    public static byte[] isLegalFamilyName(byte[] b) {
        if (b == null) {
            return b;
        }
        Preconditions.checkArgument(b.length != 0, "Family name can not be empty");
        if (b[0] == 46) {
            throw new IllegalArgumentException("Family names cannot start with a period: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58 && b[i] != 92 && b[i] != 47) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Family names cannot contain control characters or colons: " + Bytes.toString(b));
        }
        byte[] recoveredEdit = Bytes.toBytes("recovered.edits");
        if (Bytes.equals(recoveredEdit, b)) {
            throw new IllegalArgumentException("Family name cannot be: recovered.edits");
        }
        return b;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return Bytes.toString(this.name);
    }

    public byte[] getValue(byte[] key) {
        ImmutableBytesWritable ibw = this.values.get(new ImmutableBytesWritable(key));
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public HColumnDescriptor setValue(byte[] key, byte[] value) {
        int scopeType;
        if (Bytes.compareTo(Bytes.toBytes("VERSIONS"), key) == 0) {
            this.cachedMaxVersions = -1;
        } else if (Bytes.compareTo(REPLICATION_SCOPE_BYTES, key) == 0 && (scopeType = Integer.parseInt(Bytes.toString(value))) != 1 && scopeType != 0) {
            throw new IllegalArgumentException("Invalid value '" + scopeType + "' for REPLICATION_SCOPE.");
        }
        this.values.put(new ImmutableBytesWritable(key), new ImmutableBytesWritable(value));
        return this;
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public HColumnDescriptor setValue(String key, String value) {
        if (value == null) {
            this.remove(Bytes.toBytes(key));
        } else {
            this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
        }
        return this;
    }

    public Compression.Algorithm getCompression() {
        String n = this.getValue(COMPRESSION);
        if (n == null) {
            return Compression.Algorithm.NONE;
        }
        return Compression.Algorithm.valueOf(n.toUpperCase(Locale.ROOT));
    }

    public Compression.Algorithm getCompactionCompression() {
        String n = this.getValue(COMPRESSION_COMPACT);
        if (n == null) {
            return this.getCompression();
        }
        return Compression.Algorithm.valueOf(n.toUpperCase(Locale.ROOT));
    }

    public int getMaxVersions() {
        if (this.cachedMaxVersions == -1) {
            String v = this.getValue("VERSIONS");
            this.cachedMaxVersions = Integer.parseInt(v);
        }
        return this.cachedMaxVersions;
    }

    public HColumnDescriptor setMaxVersions(int maxVersions) {
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        if (maxVersions < this.getMinVersions()) {
            throw new IllegalArgumentException("Set MaxVersion to " + maxVersions + " while minVersion is " + this.getMinVersions() + ". Maximum versions must be >= minimum versions ");
        }
        this.setValue("VERSIONS", Integer.toString(maxVersions));
        this.cachedMaxVersions = maxVersions;
        return this;
    }

    public HColumnDescriptor setVersions(int minVersions, int maxVersions) {
        if (minVersions <= 0) {
            throw new IllegalArgumentException("Minimum versions must be positive");
        }
        if (maxVersions < minVersions) {
            throw new IllegalArgumentException("Unable to set MaxVersion to " + maxVersions + " and set MinVersion to " + minVersions + ", as maximum versions must be >= minimum versions.");
        }
        this.setMinVersions(minVersions);
        this.setMaxVersions(maxVersions);
        return this;
    }

    public synchronized int getBlocksize() {
        if (this.blocksize == null) {
            String value = this.getValue(BLOCKSIZE);
            this.blocksize = value != null ? Integer.decode(value) : Integer.valueOf(65536);
        }
        return this.blocksize;
    }

    public HColumnDescriptor setBlocksize(int s) {
        this.setValue(BLOCKSIZE, Integer.toString(s));
        this.blocksize = null;
        return this;
    }

    public Compression.Algorithm getCompressionType() {
        return this.getCompression();
    }

    public HColumnDescriptor setCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION, type.getName().toUpperCase(Locale.ROOT));
    }

    @Deprecated
    public DataBlockEncoding getDataBlockEncodingOnDisk() {
        return this.getDataBlockEncoding();
    }

    @Deprecated
    public HColumnDescriptor setEncodeOnDisk(boolean encodeOnDisk) {
        return this;
    }

    public DataBlockEncoding getDataBlockEncoding() {
        String type = this.getValue(DATA_BLOCK_ENCODING);
        if (type == null) {
            type = DEFAULT_DATA_BLOCK_ENCODING;
        }
        return DataBlockEncoding.valueOf(type);
    }

    public HColumnDescriptor setDataBlockEncoding(DataBlockEncoding type) {
        String name = type != null ? type.toString() : DataBlockEncoding.NONE.toString();
        return this.setValue(DATA_BLOCK_ENCODING, name);
    }

    public HColumnDescriptor setCompressTags(boolean compressTags) {
        return this.setValue(COMPRESS_TAGS, String.valueOf(compressTags));
    }

    @Deprecated
    public boolean shouldCompressTags() {
        String compressTagsStr = this.getValue(COMPRESS_TAGS);
        boolean compressTags = true;
        if (compressTagsStr != null) {
            compressTags = Boolean.valueOf(compressTagsStr);
        }
        return compressTags;
    }

    public boolean isCompressTags() {
        String compressTagsStr = this.getValue(COMPRESS_TAGS);
        boolean compressTags = true;
        if (compressTagsStr != null) {
            compressTags = Boolean.valueOf(compressTagsStr);
        }
        return compressTags;
    }

    public Compression.Algorithm getCompactionCompressionType() {
        return this.getCompactionCompression();
    }

    public HColumnDescriptor setCompactionCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION_COMPACT, type.getName().toUpperCase(Locale.ROOT));
    }

    public boolean isInMemory() {
        String value = this.getValue("IN_MEMORY");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setInMemory(boolean inMemory) {
        return this.setValue("IN_MEMORY", Boolean.toString(inMemory));
    }

    public KeepDeletedCells getKeepDeletedCells() {
        String value = this.getValue(KEEP_DELETED_CELLS);
        if (value != null) {
            return KeepDeletedCells.valueOf(value.toUpperCase(Locale.ROOT));
        }
        return DEFAULT_KEEP_DELETED;
    }

    @Deprecated
    public HColumnDescriptor setKeepDeletedCells(boolean keepDeletedCells) {
        return this.setValue(KEEP_DELETED_CELLS, (keepDeletedCells ? KeepDeletedCells.TRUE : KeepDeletedCells.FALSE).toString());
    }

    public HColumnDescriptor setKeepDeletedCells(KeepDeletedCells keepDeletedCells) {
        return this.setValue(KEEP_DELETED_CELLS, keepDeletedCells.toString());
    }

    public int getTimeToLive() {
        String value = this.getValue(TTL);
        return value != null ? Integer.parseInt(value) : Integer.MAX_VALUE;
    }

    public HColumnDescriptor setTimeToLive(int timeToLive) {
        return this.setValue(TTL, Integer.toString(timeToLive));
    }

    public int getMinVersions() {
        String value = this.getValue(MIN_VERSIONS);
        return value != null ? Integer.parseInt(value) : 0;
    }

    public HColumnDescriptor setMinVersions(int minVersions) {
        return this.setValue(MIN_VERSIONS, Integer.toString(minVersions));
    }

    public boolean isBlockCacheEnabled() {
        String value = this.getValue(BLOCKCACHE);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    public HColumnDescriptor setBlockCacheEnabled(boolean blockCacheEnabled) {
        return this.setValue(BLOCKCACHE, Boolean.toString(blockCacheEnabled));
    }

    public BloomType getBloomFilterType() {
        String n = this.getValue(BLOOMFILTER);
        if (n == null) {
            n = DEFAULT_BLOOMFILTER;
        }
        return BloomType.valueOf(n.toUpperCase(Locale.ROOT));
    }

    public HColumnDescriptor setBloomFilterType(BloomType bt) {
        return this.setValue(BLOOMFILTER, bt.toString());
    }

    public int getScope() {
        byte[] value = this.getValue(REPLICATION_SCOPE_BYTES);
        if (value != null) {
            return Integer.parseInt(Bytes.toString(value));
        }
        return 0;
    }

    public HColumnDescriptor setScope(int scope) {
        return this.setValue(REPLICATION_SCOPE, Integer.toString(scope));
    }

    @Deprecated
    public boolean shouldCacheDataOnWrite() {
        return this.setAndGetBoolean(CACHE_DATA_ON_WRITE, false);
    }

    public boolean isCacheDataOnWrite() {
        return this.setAndGetBoolean(CACHE_DATA_ON_WRITE, false);
    }

    public HColumnDescriptor setCacheDataOnWrite(boolean value) {
        return this.setValue(CACHE_DATA_ON_WRITE, Boolean.toString(value));
    }

    @Deprecated
    public boolean shouldCacheDataInL1() {
        return this.setAndGetBoolean(CACHE_DATA_IN_L1, false);
    }

    public boolean isCacheDataInL1() {
        return this.setAndGetBoolean(CACHE_DATA_IN_L1, false);
    }

    public HColumnDescriptor setCacheDataInL1(boolean value) {
        return this.setValue(CACHE_DATA_IN_L1, Boolean.toString(value));
    }

    private boolean setAndGetBoolean(String key, boolean defaultSetting) {
        String value = this.getValue(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultSetting;
    }

    @Deprecated
    public boolean shouldCacheIndexesOnWrite() {
        return this.setAndGetBoolean(CACHE_INDEX_ON_WRITE, false);
    }

    public boolean isCacheIndexesOnWrite() {
        return this.setAndGetBoolean(CACHE_INDEX_ON_WRITE, false);
    }

    public HColumnDescriptor setCacheIndexesOnWrite(boolean value) {
        return this.setValue(CACHE_INDEX_ON_WRITE, Boolean.toString(value));
    }

    @Deprecated
    public boolean shouldCacheBloomsOnWrite() {
        return this.setAndGetBoolean(CACHE_BLOOMS_ON_WRITE, false);
    }

    public boolean isCacheBloomsOnWrite() {
        return this.setAndGetBoolean(CACHE_BLOOMS_ON_WRITE, false);
    }

    public HColumnDescriptor setCacheBloomsOnWrite(boolean value) {
        return this.setValue(CACHE_BLOOMS_ON_WRITE, Boolean.toString(value));
    }

    @Deprecated
    public boolean shouldEvictBlocksOnClose() {
        return this.setAndGetBoolean(EVICT_BLOCKS_ON_CLOSE, false);
    }

    public boolean isEvictBlocksOnClose() {
        return this.setAndGetBoolean(EVICT_BLOCKS_ON_CLOSE, false);
    }

    public HColumnDescriptor setEvictBlocksOnClose(boolean value) {
        return this.setValue(EVICT_BLOCKS_ON_CLOSE, Boolean.toString(value));
    }

    @Deprecated
    public boolean shouldPrefetchBlocksOnOpen() {
        return this.setAndGetBoolean(PREFETCH_BLOCKS_ON_OPEN, false);
    }

    public boolean isPrefetchBlocksOnOpen() {
        return this.setAndGetBoolean(PREFETCH_BLOCKS_ON_OPEN, false);
    }

    public HColumnDescriptor setPrefetchBlocksOnOpen(boolean value) {
        return this.setValue(PREFETCH_BLOCKS_ON_OPEN, Boolean.toString(value));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(true));
        s.append('}');
        return s.toString();
    }

    public String toStringCustomizedValues() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(false));
        s.append('}');
        return s.toString();
    }

    private StringBuilder getValues(boolean printDefaults) {
        StringBuilder s = new StringBuilder();
        boolean hasConfigKeys = false;
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            ImmutableBytesWritable immutableBytesWritable = entry.getKey();
            if (!RESERVED_KEYWORDS.contains(immutableBytesWritable)) {
                hasConfigKeys = true;
                continue;
            }
            String key = Bytes.toString(immutableBytesWritable.get());
            String value = Bytes.toStringBinary(entry.getValue().get());
            if (!printDefaults && DEFAULT_VALUES.containsKey(key) && DEFAULT_VALUES.get(key).equalsIgnoreCase(value)) continue;
            s.append(", ");
            s.append(key);
            s.append(" => ");
            s.append('\'').append(PrettyPrinter.format(value, HColumnDescriptor.getUnit(key))).append('\'');
        }
        if (hasConfigKeys) {
            s.append(", ");
            s.append("METADATA").append(" => ");
            s.append('{');
            boolean printComma = false;
            for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
                ImmutableBytesWritable k = entry.getKey();
                if (RESERVED_KEYWORDS.contains(k)) continue;
                String key = Bytes.toString(k.get());
                String value = Bytes.toStringBinary(entry.getValue().get());
                if (printComma) {
                    s.append(", ");
                }
                printComma = true;
                s.append('\'').append(key).append('\'');
                s.append(" => ");
                s.append('\'').append(PrettyPrinter.format(value, HColumnDescriptor.getUnit(key))).append('\'');
            }
            s.append('}');
        }
        if (!this.configuration.isEmpty()) {
            s.append(", ");
            s.append("CONFIGURATION").append(" => ");
            s.append('{');
            boolean printCommaForConfiguration = false;
            for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
                if (printCommaForConfiguration) {
                    s.append(", ");
                }
                printCommaForConfiguration = true;
                s.append('\'').append((String)entry.getKey()).append('\'');
                s.append(" => ");
                s.append('\'').append(PrettyPrinter.format((String)entry.getValue(), HColumnDescriptor.getUnit((String)entry.getKey()))).append('\'');
            }
            s.append("}");
        }
        return s;
    }

    public static PrettyPrinter.Unit getUnit(String key) {
        PrettyPrinter.Unit unit = key.equals(TTL) ? PrettyPrinter.Unit.TIME_INTERVAL : PrettyPrinter.Unit.NONE;
        return unit;
    }

    public static Map<String, String> getDefaultValues() {
        return Collections.unmodifiableMap(DEFAULT_VALUES);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HColumnDescriptor)) {
            return false;
        }
        return this.compareTo((HColumnDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= Byte.valueOf((byte)11).hashCode();
        result ^= this.values.hashCode();
        return result ^= this.configuration.hashCode();
    }

    @Override
    @Deprecated
    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version < 6) {
            if (version <= 2) {
                Text t = new Text();
                t.readFields(in);
                this.name = t.getBytes();
            } else {
                this.name = Bytes.readByteArray(in);
            }
            this.values.clear();
            this.setMaxVersions(in.readInt());
            int ordinal = in.readInt();
            this.setCompressionType(Compression.Algorithm.values()[ordinal]);
            this.setInMemory(in.readBoolean());
            this.setBloomFilterType(in.readBoolean() ? BloomType.ROW : BloomType.NONE);
            if (this.getBloomFilterType() != BloomType.NONE && version < 5) {
                throw new UnsupportedClassVersionError(this.getClass().getName() + " does not support backward compatibility with versions older " + "than version 5");
            }
            if (version > 1) {
                this.setBlockCacheEnabled(in.readBoolean());
            }
            if (version > 2) {
                this.setTimeToLive(in.readInt());
            }
        } else {
            String value;
            this.name = Bytes.readByteArray(in);
            this.values.clear();
            int numValues = in.readInt();
            for (int i = 0; i < numValues; ++i) {
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                ImmutableBytesWritable value2 = new ImmutableBytesWritable();
                key.readFields(in);
                value2.readFields(in);
                if (version < 8 && Bytes.toString(key.get()).equals(BLOOMFILTER)) {
                    value2.set(Bytes.toBytes(Boolean.parseBoolean(Bytes.toString(value2.get())) ? BloomType.ROW.toString() : BloomType.NONE.toString()));
                }
                this.values.put(key, value2);
            }
            if (version == 6) {
                this.setValue(COMPRESSION, Compression.Algorithm.NONE.getName());
            }
            int n = this.cachedMaxVersions = (value = this.getValue("VERSIONS")) != null ? Integer.parseInt(value) : DEFAULT_VERSIONS;
            if (version > 10) {
                this.configuration.clear();
                int numConfigs = in.readInt();
                for (int i = 0; i < numConfigs; ++i) {
                    ImmutableBytesWritable key = new ImmutableBytesWritable();
                    ImmutableBytesWritable val = new ImmutableBytesWritable();
                    key.readFields(in);
                    val.readFields(in);
                    this.configuration.put(Bytes.toString(key.get(), key.getOffset(), key.getLength()), Bytes.toString(val.get(), val.getOffset(), val.getLength()));
                }
            }
        }
    }

    @Override
    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeByte(11);
        Bytes.writeByteArray(out, this.name);
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        out.writeInt(this.configuration.size());
        for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
            new ImmutableBytesWritable(Bytes.toBytes((String)entry.getKey())).write(out);
            new ImmutableBytesWritable(Bytes.toBytes((String)entry.getValue())).write(out);
        }
    }

    @Override
    public int compareTo(HColumnDescriptor o) {
        int result = Bytes.compareTo(this.name, o.getName());
        if (result == 0) {
            result = this.values.hashCode() - o.values.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        if (result == 0) {
            result = this.configuration.hashCode() - o.configuration.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    public static HColumnDescriptor parseFrom(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("No magic");
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        HBaseProtos.ColumnFamilySchema cfs = null;
        try {
            ProtobufUtil.mergeFrom(builder, bytes, pblen, bytes.length - pblen);
            cfs = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return HColumnDescriptor.convert(cfs);
    }

    @Deprecated
    public static HColumnDescriptor convert(HBaseProtos.ColumnFamilySchema cfs) {
        HColumnDescriptor hcd = new HColumnDescriptor();
        hcd.name = cfs.getName().toByteArray();
        for (HBaseProtos.BytesBytesPair bytesBytesPair : cfs.getAttributesList()) {
            hcd.setValue(bytesBytesPair.getFirst().toByteArray(), bytesBytesPair.getSecond().toByteArray());
        }
        for (HBaseProtos.NameStringPair nameStringPair : cfs.getConfigurationList()) {
            hcd.setConfiguration(nameStringPair.getName(), nameStringPair.getValue());
        }
        return hcd;
    }

    @Deprecated
    public HBaseProtos.ColumnFamilySchema convert() {
        GeneratedMessage.Builder aBuilder;
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        builder.setName(ByteStringer.wrap(this.getName()));
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            ((HBaseProtos.BytesBytesPair.Builder)aBuilder).setFirst(ByteStringer.wrap(entry.getKey().get()));
            ((HBaseProtos.BytesBytesPair.Builder)aBuilder).setSecond(ByteStringer.wrap(entry.getValue().get()));
            builder.addAttributes(((HBaseProtos.BytesBytesPair.Builder)aBuilder).build());
        }
        for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
            aBuilder = HBaseProtos.NameStringPair.newBuilder();
            ((HBaseProtos.NameStringPair.Builder)aBuilder).setName((String)entry.getKey());
            ((HBaseProtos.NameStringPair.Builder)aBuilder).setValue((String)entry.getValue());
            builder.addConfiguration(((HBaseProtos.NameStringPair.Builder)aBuilder).build());
        }
        return builder.build();
    }

    public String getConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public HColumnDescriptor setConfiguration(String key, String value) {
        if (value == null) {
            this.removeConfiguration(key);
        } else {
            this.configuration.put(key, value);
        }
        return this;
    }

    public void removeConfiguration(String key) {
        this.configuration.remove(key);
    }

    public String getEncryptionType() {
        return this.getValue(ENCRYPTION);
    }

    public HColumnDescriptor setEncryptionType(String algorithm) {
        this.setValue(ENCRYPTION, algorithm);
        return this;
    }

    public byte[] getEncryptionKey() {
        return this.getValue(Bytes.toBytes(ENCRYPTION_KEY));
    }

    public HColumnDescriptor setEncryptionKey(byte[] keyBytes) {
        this.setValue(Bytes.toBytes(ENCRYPTION_KEY), keyBytes);
        return this;
    }

    public short getDFSReplication() {
        String rf = this.getValue(DFS_REPLICATION);
        return rf == null ? (short)0 : Short.parseShort(rf);
    }

    public HColumnDescriptor setDFSReplication(short replication) {
        if (replication < 1 && replication != 0) {
            throw new IllegalArgumentException("DFS replication factor cannot be less than 1 if explicitly set.");
        }
        this.setValue(DFS_REPLICATION, Short.toString(replication));
        return this;
    }

    static {
        DEFAULT_VALUES.put(BLOOMFILTER, DEFAULT_BLOOMFILTER);
        DEFAULT_VALUES.put(REPLICATION_SCOPE, String.valueOf(0));
        DEFAULT_VALUES.put("VERSIONS", String.valueOf(DEFAULT_VERSIONS));
        DEFAULT_VALUES.put(MIN_VERSIONS, String.valueOf(0));
        DEFAULT_VALUES.put(COMPRESSION, DEFAULT_COMPRESSION);
        DEFAULT_VALUES.put(TTL, String.valueOf(Integer.MAX_VALUE));
        DEFAULT_VALUES.put(BLOCKSIZE, String.valueOf(65536));
        DEFAULT_VALUES.put("IN_MEMORY", String.valueOf(false));
        DEFAULT_VALUES.put(BLOCKCACHE, String.valueOf(true));
        DEFAULT_VALUES.put(KEEP_DELETED_CELLS, String.valueOf((Object)DEFAULT_KEEP_DELETED));
        DEFAULT_VALUES.put(DATA_BLOCK_ENCODING, String.valueOf(DEFAULT_DATA_BLOCK_ENCODING));
        DEFAULT_VALUES.put(CACHE_DATA_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_DATA_IN_L1, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_INDEX_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_BLOOMS_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(EVICT_BLOCKS_ON_CLOSE, String.valueOf(false));
        DEFAULT_VALUES.put(PREFETCH_BLOCKS_ON_OPEN, String.valueOf(false));
        for (String s : DEFAULT_VALUES.keySet()) {
            RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes(s)));
        }
        RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes(ENCRYPTION)));
        RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes(ENCRYPTION_KEY)));
    }
}

