/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.yammer.metrics.util;

import java.util.Set;
import org.apache.hadoop.hbase.shaded.com.yammer.metrics.core.HealthCheck;
import org.apache.hadoop.hbase.shaded.com.yammer.metrics.core.VirtualMachineMetrics;

public class DeadlockHealthCheck
extends HealthCheck {
    private final VirtualMachineMetrics vm;

    public DeadlockHealthCheck(VirtualMachineMetrics vm) {
        super("deadlocks");
        this.vm = vm;
    }

    public DeadlockHealthCheck() {
        this(VirtualMachineMetrics.getInstance());
    }

    @Override
    protected HealthCheck.Result check() throws Exception {
        Set<String> threads = this.vm.deadlockedThreads();
        if (threads.isEmpty()) {
            return HealthCheck.Result.healthy();
        }
        StringBuilder builder = new StringBuilder("Deadlocked threads detected:\n");
        for (String thread : threads) {
            builder.append(thread).append('\n');
        }
        return HealthCheck.Result.unhealthy(builder.toString());
    }
}

