/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class BatchScanResultCache
implements ScanResultCache {
    private final int batch;
    private Cell lastCell;
    private boolean lastResultPartial;
    private final Deque<Result> partialResults = new ArrayDeque<Result>();
    private int numCellsOfPartialResults;
    private int numberOfCompleteRows;

    public BatchScanResultCache(int batch) {
        this.batch = batch;
    }

    private void recordLastResult(Result result) {
        this.lastCell = result.rawCells()[result.rawCells().length - 1];
        this.lastResultPartial = result.mayHaveMoreCellsInRow();
    }

    private Result createCompletedResult() throws IOException {
        ++this.numberOfCompleteRows;
        Result result = Result.createCompleteResult(this.partialResults);
        this.partialResults.clear();
        this.numCellsOfPartialResults = 0;
        return result;
    }

    private Result regroupResults(Result result) {
        this.partialResults.addLast(result);
        this.numCellsOfPartialResults += result.size();
        if (this.numCellsOfPartialResults < this.batch) {
            return null;
        }
        Cell[] cells = new Cell[this.batch];
        int cellCount = 0;
        boolean stale = false;
        while (true) {
            Result r = this.partialResults.pollFirst();
            stale = stale || r.isStale();
            int newCellCount = cellCount + r.size();
            if (newCellCount > this.batch) {
                int len = this.batch - cellCount;
                System.arraycopy(r.rawCells(), 0, cells, cellCount, len);
                Cell[] remainingCells = new Cell[r.size() - len];
                System.arraycopy(r.rawCells(), len, remainingCells, 0, r.size() - len);
                this.partialResults.addFirst(Result.create(remainingCells, r.getExists(), r.isStale(), r.mayHaveMoreCellsInRow()));
                break;
            }
            System.arraycopy(r.rawCells(), 0, cells, cellCount, r.size());
            if (newCellCount == this.batch) break;
            cellCount = newCellCount;
        }
        this.numCellsOfPartialResults -= this.batch;
        return Result.create(cells, null, stale, result.mayHaveMoreCellsInRow() || !this.partialResults.isEmpty());
    }

    @Override
    public Result[] addAndGet(Result[] results, boolean isHeartbeatMessage) throws IOException {
        if (results.length == 0) {
            if (!isHeartbeatMessage) {
                if (!this.partialResults.isEmpty()) {
                    return new Result[]{this.createCompletedResult()};
                }
                if (this.lastResultPartial) {
                    ++this.numberOfCompleteRows;
                }
            }
            return EMPTY_RESULT_ARRAY;
        }
        ArrayList<Result> regroupedResults = new ArrayList<Result>();
        for (Result result : results) {
            Result regroupedResult;
            if ((result = ConnectionUtils.filterCells(result, this.lastCell)) == null) continue;
            if (!this.partialResults.isEmpty()) {
                if (!Bytes.equals(this.partialResults.peek().getRow(), result.getRow())) {
                    regroupedResults.add(this.createCompletedResult());
                }
            } else if (this.lastResultPartial && !CellUtil.matchingRow(this.lastCell, result.getRow())) {
                ++this.numberOfCompleteRows;
            }
            if (!this.partialResults.isEmpty() && !Bytes.equals(this.partialResults.peek().getRow(), result.getRow())) {
                regroupedResults.add(this.createCompletedResult());
            }
            if ((regroupedResult = this.regroupResults(result)) != null) {
                if (!regroupedResult.mayHaveMoreCellsInRow()) {
                    ++this.numberOfCompleteRows;
                }
                regroupedResults.add(regroupedResult);
                this.recordLastResult(regroupedResult);
            }
            if (result.mayHaveMoreCellsInRow() || this.partialResults.isEmpty()) continue;
            regroupedResults.add(this.createCompletedResult());
        }
        return regroupedResults.toArray(new Result[0]);
    }

    @Override
    public void clear() {
        this.partialResults.clear();
        this.numCellsOfPartialResults = 0;
    }

    @Override
    public int numberOfCompleteRows() {
        return this.numberOfCompleteRows;
    }
}

