/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Sleeper {
    private static final Log LOG = LogFactory.getLog(Sleeper.class);
    private final int period;
    private final Stoppable stopper;
    private static final long MINIMAL_DELTA_FOR_LOGGING = 10000L;
    private final Object sleepLock = new Object();
    private boolean triggerWake = false;

    public Sleeper(int sleep, Stoppable stopper) {
        this.period = sleep;
        this.stopper = stopper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipSleepCycle() {
        Object object = this.sleepLock;
        synchronized (object) {
            this.triggerWake = true;
            this.sleepLock.notifyAll();
        }
    }

    public void sleep() {
        this.sleep(this.period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long sleepTime) {
        if (this.stopper.isStopped()) {
            return;
        }
        long now = System.currentTimeMillis();
        long currentSleepTime = sleepTime;
        while (currentSleepTime > 0L) {
            long woke;
            block12: {
                woke = -1L;
                try {
                    Object object = this.sleepLock;
                    synchronized (object) {
                        if (this.triggerWake) {
                            break;
                        }
                        this.sleepLock.wait(currentSleepTime);
                    }
                    woke = System.currentTimeMillis();
                    long slept = woke - now;
                    if (slept - (long)this.period > 10000L) {
                        LOG.warn((Object)("We slept " + slept + "ms instead of " + this.period + "ms, this is likely due to a long " + "garbage collecting pause and it's usually bad, see " + "http://hbase.apache.org/book.html#trouble.rs.runtime.zkexpired"));
                    }
                }
                catch (InterruptedException iex) {
                    if (!this.stopper.isStopped()) break block12;
                    return;
                }
            }
            woke = woke == -1L ? System.currentTimeMillis() : woke;
            currentSleepTime = (long)this.period - (woke - now);
        }
        Object object = this.sleepLock;
        synchronized (object) {
            this.triggerWake = false;
        }
    }

    public final int getPeriod() {
        return this.period;
    }
}

