/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.core.util.ReaderWriter;
import com.sun.jersey.json.impl.reader.Jackson2StaxReader;
import com.sun.jersey.json.impl.reader.JacksonRootAddingParser;
import com.sun.jersey.json.impl.reader.JsonXmlStreamReader;
import com.sun.jersey.json.impl.writer.JacksonArrayWrapperGenerator;
import com.sun.jersey.json.impl.writer.JacksonRootStrippingGenerator;
import com.sun.jersey.json.impl.writer.JsonXmlStreamWriter;
import com.sun.jersey.json.impl.writer.Stax2JacksonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonFactory;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonGenerator;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonParser;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.badgerfish.BadgerFishXMLStreamReader;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.json.JSONTokener;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.mapped.Configuration;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.apache.hadoop.hbase.shaded.org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class Stax2JsonFactory {
    private Stax2JsonFactory() {
    }

    public static XMLStreamWriter createWriter(Writer writer, JSONConfiguration config) throws IOException {
        return Stax2JsonFactory.createWriter(writer, config, false);
    }

    public static XMLStreamWriter createWriter(Writer writer, JSONConfiguration config, boolean writingList) throws IOException {
        switch (config.getNotation()) {
            case NATURAL: {
                JsonGenerator bodyGenerator;
                JsonGenerator rawGenerator = new JsonFactory().createJsonGenerator(writer);
                if (config.isHumanReadableFormatting()) {
                    rawGenerator.useDefaultPrettyPrinter();
                }
                JsonGenerator jsonGenerator = writingList ? JacksonArrayWrapperGenerator.createArrayWrapperGenerator(rawGenerator, config.isRootUnwrapping() ? 0 : 1) : (bodyGenerator = rawGenerator);
                if (config.isRootUnwrapping()) {
                    return new Stax2JacksonWriter(JacksonRootStrippingGenerator.createRootStrippingGenerator(bodyGenerator, writingList ? 2 : 1), config);
                }
                return new Stax2JacksonWriter(bodyGenerator, config);
            }
            case MAPPED: {
                return JsonXmlStreamWriter.createWriter(writer, config);
            }
            case BADGERFISH: {
                return new BadgerFishXMLStreamWriter(writer);
            }
            case MAPPED_JETTISON: {
                Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                return new MappedXMLStreamWriter(new MappedNamespaceConvention(jmConfig), writer);
            }
        }
        return null;
    }

    public static XMLStreamReader createReader(Reader reader, JSONConfiguration config, String rootName) throws XMLStreamException {
        return Stax2JsonFactory.createReader(reader, config, rootName, false);
    }

    public static XMLStreamReader createReader(Reader reader, JSONConfiguration config, String rootName, boolean readingList) throws XMLStreamException {
        Reader nonEmptyReader = Stax2JsonFactory.ensureNonEmptyReader(reader);
        switch (config.getNotation()) {
            case NATURAL: {
                try {
                    JsonParser nonListParser;
                    JsonParser rawParser = new JsonFactory().createJsonParser(nonEmptyReader);
                    JsonParser jsonParser = nonListParser = config.isRootUnwrapping() ? JacksonRootAddingParser.createRootAddingParser(rawParser, rootName) : rawParser;
                    if (!readingList) {
                        return new Jackson2StaxReader(nonListParser, config);
                    }
                    return new Jackson2StaxReader(JacksonRootAddingParser.createRootAddingParser(nonListParser, "jsonArrayRootElement"), config);
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case MAPPED: {
                try {
                    return new JsonXmlStreamReader(nonEmptyReader, rootName, config);
                }
                catch (IOException ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case MAPPED_JETTISON: {
                try {
                    Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                    return new MappedXMLStreamReader(new JSONObject(new JSONTokener(ReaderWriter.readFromAsString(nonEmptyReader))), new MappedNamespaceConvention(jmConfig));
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case BADGERFISH: {
                try {
                    return new BadgerFishXMLStreamReader(new JSONObject(new JSONTokener(ReaderWriter.readFromAsString(nonEmptyReader))));
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
        }
        throw new IllegalArgumentException("Unknown JSON config");
    }

    private static Reader ensureNonEmptyReader(Reader reader) throws XMLStreamException {
        try {
            Reader mr = reader.markSupported() ? reader : new BufferedReader(reader);
            mr.mark(1);
            if (mr.read() == -1) {
                throw new XMLStreamException("JSON expression can not be empty!");
            }
            mr.reset();
            return mr;
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }
}

