/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.ByteBufferTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public final class TagUtil {
    private static final int MAX_TAGS_LENGTH = 65535;
    static final Iterator<Tag> EMPTY_TAGS_ITR = new Iterator<Tag>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        @SuppressWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="Intentional")
        public Tag next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private TagUtil() {
    }

    public static byte[] cloneValue(Tag tag) {
        int tagLength = tag.getValueLength();
        byte[] tagArr = new byte[tagLength];
        if (tag.hasArray()) {
            Bytes.putBytes(tagArr, 0, tag.getValueArray(), tag.getValueOffset(), tagLength);
        } else {
            ByteBufferUtils.copyFromBufferToArray(tagArr, tag.getValueByteBuffer(), tag.getValueOffset(), 0, tagLength);
        }
        return tagArr;
    }

    public static List<Tag> asList(byte[] b, int offset, int length) {
        int tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos, 2);
            tags.add(new ArrayBackedTag(b, pos, tagLen + 2));
        }
        return tags;
    }

    public static List<Tag> asList(ByteBuffer b, int offset, int length) {
        int tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = ByteBufferUtils.readAsInt(b, pos, 2);
            tags.add(new ByteBufferTag(b, pos, tagLen + 2));
        }
        return tags;
    }

    public static byte[] fromList(List<Tag> tags) {
        if (tags == null || tags.isEmpty()) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        int length = 0;
        for (Tag tag : tags) {
            length += tag.getValueLength() + 3;
        }
        byte[] b = new byte[length];
        int pos = 0;
        for (Tag tag : tags) {
            int tlen = tag.getValueLength();
            pos = Bytes.putAsShort(b, pos, tlen + 1);
            pos = Bytes.putByte(b, pos, tag.getType());
            if (tag.hasArray()) {
                pos = Bytes.putBytes(b, pos, tag.getValueArray(), tag.getValueOffset(), tlen);
                continue;
            }
            ByteBufferUtils.copyFromBufferToArray(b, tag.getValueByteBuffer(), tag.getValueOffset(), pos, tlen);
            pos += tlen;
        }
        return b;
    }

    public static long getValueAsLong(Tag tag) {
        if (tag.hasArray()) {
            return Bytes.toLong(tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
        }
        return ByteBufferUtils.toLong(tag.getValueByteBuffer(), tag.getValueOffset());
    }

    public static byte getValueAsByte(Tag tag) {
        if (tag.hasArray()) {
            return tag.getValueArray()[tag.getValueOffset()];
        }
        return ByteBufferUtils.toByte(tag.getValueByteBuffer(), tag.getValueOffset());
    }

    public static String getValueAsString(Tag tag) {
        if (tag.hasArray()) {
            return Bytes.toString(tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
        }
        return Bytes.toString(TagUtil.cloneValue(tag));
    }

    public static boolean matchingValue(Tag t1, Tag t2) {
        if (t1.hasArray() && t2.hasArray()) {
            return Bytes.equals(t1.getValueArray(), t1.getValueOffset(), t1.getValueLength(), t2.getValueArray(), t2.getValueOffset(), t2.getValueLength());
        }
        if (t1.hasArray()) {
            return ByteBufferUtils.equals(t2.getValueByteBuffer(), t2.getValueOffset(), t2.getValueLength(), t1.getValueArray(), t1.getValueOffset(), t1.getValueLength());
        }
        if (t2.hasArray()) {
            return ByteBufferUtils.equals(t1.getValueByteBuffer(), t1.getValueOffset(), t1.getValueLength(), t2.getValueArray(), t2.getValueOffset(), t2.getValueLength());
        }
        return ByteBufferUtils.equals(t1.getValueByteBuffer(), t1.getValueOffset(), t1.getValueLength(), t2.getValueByteBuffer(), t2.getValueOffset(), t2.getValueLength());
    }

    public static void copyValueTo(Tag tag, byte[] out, int offset) {
        if (tag.hasArray()) {
            Bytes.putBytes(out, offset, tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
        } else {
            ByteBufferUtils.copyFromBufferToArray(out, tag.getValueByteBuffer(), tag.getValueOffset(), offset, tag.getValueLength());
        }
    }

    public static Pair<Integer, Integer> readVIntValuePart(Tag tag, int offset) throws IOException {
        if (tag.hasArray()) {
            return StreamUtils.readRawVarint32(tag.getValueArray(), offset);
        }
        return StreamUtils.readRawVarint32(tag.getValueByteBuffer(), offset);
    }

    public static List<Tag> carryForwardTags(Cell cell) {
        return TagUtil.carryForwardTags(null, cell);
    }

    public static List<Tag> carryForwardTags(List<Tag> tagsOrNull, Cell cell) {
        Iterator<Tag> itr = CellUtil.tagsIterator(cell);
        if (itr == EMPTY_TAGS_ITR) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        while (itr.hasNext()) {
            tags.add(itr.next());
        }
        return tags;
    }

    public static byte[] concatTags(byte[] tags, Cell cell) {
        int cellTagsLen = cell.getTagsLength();
        if (cellTagsLen == 0) {
            return tags;
        }
        byte[] b = new byte[tags.length + cellTagsLen];
        int pos = Bytes.putBytes(b, 0, tags, 0, tags.length);
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(b, ((ByteBufferCell)cell).getTagsByteBuffer(), ((ByteBufferCell)cell).getTagsPosition(), pos, cellTagsLen);
        } else {
            Bytes.putBytes(b, pos, cell.getTagsArray(), cell.getTagsOffset(), cellTagsLen);
        }
        return b;
    }

    public static List<Tag> carryForwardTTLTag(List<Tag> tagsOrNull, long ttl) {
        if (ttl == Long.MAX_VALUE) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>(1);
        } else {
            Iterator<Tag> tagsItr = tags.iterator();
            while (tagsItr.hasNext()) {
                Tag tag = tagsItr.next();
                if (tag.getType() != 8) continue;
                tagsItr.remove();
                break;
            }
        }
        tags.add(new ArrayBackedTag(8, Bytes.toBytes(ttl)));
        return tags;
    }

    public static void checkForTagsLength(int tagsLength) {
        if (tagsLength > 65535) {
            throw new IllegalArgumentException("tagslength " + tagsLength + " > " + 65535);
        }
    }
}

