/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public abstract class AsyncRpcRetryingCaller<T> {
    private static final Log LOG = LogFactory.getLog(AsyncRpcRetryingCaller.class);
    private final HashedWheelTimer retryTimer;
    private final long startNs;
    private final long pauseNs;
    private int tries = 1;
    private final int maxAttempts;
    private final int startLogErrorsCnt;
    private final List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions;
    private final long rpcTimeoutNs;
    protected final long operationTimeoutNs;
    protected final AsyncConnectionImpl conn;
    protected final CompletableFuture<T> future;
    protected final HBaseRpcController controller;

    public AsyncRpcRetryingCaller(HashedWheelTimer retryTimer, AsyncConnectionImpl conn, long pauseNs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        this.retryTimer = retryTimer;
        this.conn = conn;
        this.pauseNs = pauseNs;
        this.maxAttempts = maxAttempts;
        this.operationTimeoutNs = operationTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.future = new CompletableFuture();
        this.controller = conn.rpcControllerFactory.newController();
        this.exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.startNs = System.nanoTime();
    }

    private long elapsedMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
    }

    protected long remainingTimeNs() {
        return this.operationTimeoutNs - (System.nanoTime() - this.startNs);
    }

    protected void completeExceptionally() {
        this.future.completeExceptionally(new RetriesExhaustedException(this.tries - 1, this.exceptions));
    }

    protected void resetCallTimeout() {
        long callTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            callTimeoutNs = this.remainingTimeNs();
            if (callTimeoutNs <= 0L) {
                this.completeExceptionally();
                return;
            }
            callTimeoutNs = Math.min(callTimeoutNs, this.rpcTimeoutNs);
        } else {
            callTimeoutNs = this.rpcTimeoutNs;
        }
        ConnectionUtils.resetController(this.controller, callTimeoutNs);
    }

    protected void onError(Throwable error, Supplier<String> errMsg, Consumer<Throwable> updateCachedLocation) {
        long delayNs;
        if ((error = ConnectionUtils.translateException(error)) instanceof DoNotRetryIOException) {
            this.future.completeExceptionally(error);
            return;
        }
        if (this.tries > this.startLogErrorsCnt) {
            LOG.warn((Object)(errMsg.get() + ", tries = " + this.tries + ", maxAttempts = " + this.maxAttempts + ", timeout = " + TimeUnit.NANOSECONDS.toMillis(this.operationTimeoutNs) + " ms, time elapsed = " + this.elapsedMs() + " ms"), error);
        }
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(error, EnvironmentEdgeManager.currentTime(), "");
        this.exceptions.add(qt);
        if (this.tries >= this.maxAttempts) {
            this.completeExceptionally();
            return;
        }
        if (this.operationTimeoutNs > 0L) {
            long maxDelayNs = this.remainingTimeNs() - ConnectionUtils.SLEEP_DELTA_NS;
            if (maxDelayNs <= 0L) {
                this.completeExceptionally();
                return;
            }
            delayNs = Math.min(maxDelayNs, ConnectionUtils.getPauseTime(this.pauseNs, this.tries - 1));
        } else {
            delayNs = ConnectionUtils.getPauseTime(this.pauseNs, this.tries - 1);
        }
        updateCachedLocation.accept(error);
        ++this.tries;
        this.retryTimer.newTimeout(t -> this.doCall(), delayNs, TimeUnit.NANOSECONDS);
    }

    protected abstract void doCall();

    CompletableFuture<T> call() {
        this.doCall();
        return this.future;
    }
}

