/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.io.netty.util.Timeout;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
class AsyncScanSingleRegionRpcRetryingCaller {
    private static final Log LOG = LogFactory.getLog(AsyncScanSingleRegionRpcRetryingCaller.class);
    private final HashedWheelTimer retryTimer;
    private final Scan scan;
    private final ScanMetrics scanMetrics;
    private final long scannerId;
    private final ScanResultCache resultCache;
    private final RawScanResultConsumer consumer;
    private final ClientProtos.ClientService.Interface stub;
    private final HRegionLocation loc;
    private final boolean regionServerRemote;
    private final long scannerLeaseTimeoutPeriodNs;
    private final long pauseNs;
    private final int maxAttempts;
    private final long scanTimeoutNs;
    private final long rpcTimeoutNs;
    private final int startLogErrorsCnt;
    private final Runnable completeWhenNoMoreResultsInRegion;
    private final CompletableFuture<Boolean> future;
    private final HBaseRpcController controller;
    private byte[] nextStartRowWhenError;
    private boolean includeNextStartRowWhenError;
    private long nextCallStartNs;
    private int tries;
    private final List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions;
    private long nextCallSeq = -1L;

    public AsyncScanSingleRegionRpcRetryingCaller(HashedWheelTimer retryTimer, AsyncConnectionImpl conn, Scan scan, ScanMetrics scanMetrics, long scannerId, ScanResultCache resultCache, RawScanResultConsumer consumer, ClientProtos.ClientService.Interface stub, HRegionLocation loc, boolean isRegionServerRemote, long scannerLeaseTimeoutPeriodNs, long pauseNs, int maxAttempts, long scanTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        this.retryTimer = retryTimer;
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        this.scannerId = scannerId;
        this.resultCache = resultCache;
        this.consumer = consumer;
        this.stub = stub;
        this.loc = loc;
        this.regionServerRemote = isRegionServerRemote;
        this.scannerLeaseTimeoutPeriodNs = scannerLeaseTimeoutPeriodNs;
        this.pauseNs = pauseNs;
        this.maxAttempts = maxAttempts;
        this.scanTimeoutNs = scanTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.completeWhenNoMoreResultsInRegion = scan.isReversed() ? this::completeReversedWhenNoMoreResultsInRegion : this::completeWhenNoMoreResultsInRegion;
        this.future = new CompletableFuture();
        this.controller = conn.rpcControllerFactory.newController();
        this.exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
    }

    private long elapsedMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.nextCallStartNs);
    }

    private long remainingTimeNs() {
        return this.scanTimeoutNs - (System.nanoTime() - this.nextCallStartNs);
    }

    private void closeScanner() {
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, this.regionServerRemote);
        ConnectionUtils.resetController(this.controller, this.rpcTimeoutNs);
        ClientProtos.ScanRequest req = RequestConverter.buildScanRequest(this.scannerId, 0, true, false);
        this.stub.scan(this.controller, req, resp -> {
            if (this.controller.failed()) {
                LOG.warn((Object)("Call to " + this.loc.getServerName() + " for closing scanner id = " + this.scannerId + " for " + this.loc.getRegionInfo().getEncodedName() + " of " + this.loc.getRegionInfo().getTable() + " failed, ignore, probably already closed"), (Throwable)this.controller.getFailed());
            }
        });
    }

    private void completeExceptionally(boolean closeScanner) {
        this.resultCache.clear();
        if (closeScanner) {
            this.closeScanner();
        }
        this.future.completeExceptionally(new RetriesExhaustedException(this.tries - 1, this.exceptions));
    }

    private void completeNoMoreResults() {
        this.future.complete(false);
    }

    private void completeWithNextStartRow(byte[] row, boolean inclusive) {
        this.scan.withStartRow(row, inclusive);
        this.future.complete(true);
    }

    private void completeWhenError(boolean closeScanner) {
        ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, closeScanner);
        this.resultCache.clear();
        if (closeScanner) {
            this.closeScanner();
        }
        if (this.nextStartRowWhenError != null) {
            this.scan.withStartRow(this.nextStartRowWhenError, this.includeNextStartRowWhenError);
        }
        this.future.complete(true);
    }

    private void onError(Throwable error) {
        long delayNs;
        error = ConnectionUtils.translateException(error);
        if (this.tries > this.startLogErrorsCnt) {
            LOG.warn((Object)("Call to " + this.loc.getServerName() + " for scanner id = " + this.scannerId + " for " + this.loc.getRegionInfo().getEncodedName() + " of " + this.loc.getRegionInfo().getTable() + " failed, , tries = " + this.tries + ", maxAttempts = " + this.maxAttempts + ", timeout = " + TimeUnit.NANOSECONDS.toMillis(this.scanTimeoutNs) + " ms, time elapsed = " + this.elapsedMs() + " ms"), error);
        }
        boolean scannerClosed = error instanceof UnknownScannerException || error instanceof NotServingRegionException || error instanceof RegionServerStoppedException;
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(error, EnvironmentEdgeManager.currentTime(), "");
        this.exceptions.add(qt);
        if (this.tries >= this.maxAttempts) {
            this.completeExceptionally(!scannerClosed);
            return;
        }
        if (this.scanTimeoutNs > 0L) {
            long maxDelayNs = this.remainingTimeNs() - ConnectionUtils.SLEEP_DELTA_NS;
            if (maxDelayNs <= 0L) {
                this.completeExceptionally(!scannerClosed);
                return;
            }
            delayNs = Math.min(maxDelayNs, ConnectionUtils.getPauseTime(this.pauseNs, this.tries - 1));
        } else {
            delayNs = ConnectionUtils.getPauseTime(this.pauseNs, this.tries - 1);
        }
        if (scannerClosed) {
            this.completeWhenError(false);
            return;
        }
        if (error instanceof OutOfOrderScannerNextException || error instanceof ScannerResetException) {
            this.completeWhenError(true);
            return;
        }
        if (error instanceof DoNotRetryIOException) {
            this.completeExceptionally(true);
            return;
        }
        ++this.tries;
        this.retryTimer.newTimeout(t -> this.call(), delayNs, TimeUnit.NANOSECONDS);
    }

    private void updateNextStartRowWhenError(Result result) {
        this.nextStartRowWhenError = result.getRow();
        this.includeNextStartRowWhenError = result.mayHaveMoreCellsInRow();
    }

    private void completeWhenNoMoreResultsInRegion() {
        if (ConnectionUtils.noMoreResultsForScan(this.scan, this.loc.getRegionInfo())) {
            this.completeNoMoreResults();
        } else {
            this.completeWithNextStartRow(this.loc.getRegionInfo().getEndKey(), true);
        }
    }

    private void completeReversedWhenNoMoreResultsInRegion() {
        if (ConnectionUtils.noMoreResultsForReverseScan(this.scan, this.loc.getRegionInfo())) {
            this.completeNoMoreResults();
        } else {
            this.completeWithNextStartRow(this.loc.getRegionInfo().getStartKey(), false);
        }
    }

    private void completeOrNext(ClientProtos.ScanResponse resp, int numberOfCompleteRows) {
        if (resp.hasMoreResults() && !resp.getMoreResults()) {
            this.completeNoMoreResults();
            return;
        }
        if (this.scan.getLimit() > 0) {
            int newLimit = this.scan.getLimit() - numberOfCompleteRows;
            assert (newLimit > 0);
            this.scan.setLimit(newLimit);
        }
        if (!resp.getMoreResultsInRegion()) {
            this.completeWhenNoMoreResultsInRegion.run();
            return;
        }
        this.next();
    }

    private void onComplete(HBaseRpcController controller, ClientProtos.ScanResponse resp) {
        Result[] results;
        if (controller.failed()) {
            this.onError(controller.getFailed());
            return;
        }
        ConnectionUtils.updateServerSideMetrics(this.scanMetrics, resp);
        boolean isHeartbeatMessage = resp.hasHeartbeatMessage() && resp.getHeartbeatMessage();
        int numberOfCompleteRowsBefore = this.resultCache.numberOfCompleteRows();
        try {
            Result[] rawResults = ResponseConverter.getResults(controller.cellScanner(), resp);
            ConnectionUtils.updateResultsMetrics(this.scanMetrics, rawResults, isHeartbeatMessage);
            results = this.resultCache.addAndGet(Optional.ofNullable(rawResults).orElse(ScanResultCache.EMPTY_RESULT_ARRAY), isHeartbeatMessage);
        }
        catch (IOException e) {
            LOG.warn((Object)"decode scan response failed", (Throwable)e);
            this.completeWhenError(true);
            return;
        }
        ScanControllerImpl scanController = new ScanControllerImpl();
        if (results.length > 0) {
            this.updateNextStartRowWhenError(results[results.length - 1]);
            this.consumer.onNext(results, scanController);
        } else if (resp.hasHeartbeatMessage() && resp.getHeartbeatMessage()) {
            this.consumer.onHeartbeat(scanController);
        }
        ScanControllerState state = scanController.destroy();
        if (state == ScanControllerState.TERMINATED) {
            if (resp.getMoreResultsInRegion()) {
                this.closeScanner();
            }
            this.completeNoMoreResults();
            return;
        }
        int numberOfCompleteRows = this.resultCache.numberOfCompleteRows() - numberOfCompleteRowsBefore;
        if (state == ScanControllerState.SUSPENDED && scanController.resumer.prepare(resp, numberOfCompleteRows)) {
            return;
        }
        this.completeOrNext(resp, numberOfCompleteRows);
    }

    private void call() {
        long callTimeoutNs;
        if (this.scanTimeoutNs > 0L) {
            long remainingNs = this.scanTimeoutNs - (System.nanoTime() - this.nextCallStartNs);
            if (remainingNs <= 0L) {
                this.completeExceptionally(true);
                return;
            }
            callTimeoutNs = remainingNs;
        } else {
            callTimeoutNs = 0L;
        }
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, this.regionServerRemote);
        if (this.tries > 1) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, this.regionServerRemote);
        }
        ConnectionUtils.resetController(this.controller, callTimeoutNs);
        ClientProtos.ScanRequest req = RequestConverter.buildScanRequest(this.scannerId, this.scan.getCaching(), false, this.nextCallSeq, false, false, this.scan.getLimit());
        this.stub.scan(this.controller, req, resp -> this.onComplete(this.controller, (ClientProtos.ScanResponse)resp));
    }

    private void next() {
        ++this.nextCallSeq;
        this.tries = 1;
        this.exceptions.clear();
        this.nextCallStartNs = System.nanoTime();
        this.call();
    }

    private void renewLease() {
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, this.regionServerRemote);
        ++this.nextCallSeq;
        ConnectionUtils.resetController(this.controller, this.rpcTimeoutNs);
        ClientProtos.ScanRequest req = RequestConverter.buildScanRequest(this.scannerId, 0, false, this.nextCallSeq, false, true, -1);
        this.stub.scan(this.controller, req, resp -> {});
    }

    public CompletableFuture<Boolean> start(HBaseRpcController controller, ClientProtos.ScanResponse respWhenOpen) {
        this.onComplete(controller, respWhenOpen);
        return this.future;
    }

    private final class ScanResumerImpl
    implements RawScanResultConsumer.ScanResumer {
        private ScanResumerState state = ScanResumerState.INITIALIZED;
        private ClientProtos.ScanResponse resp;
        private int numberOfCompleteRows;
        private Timeout leaseRenewer;

        private ScanResumerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume() {
            int localNumberOfCompleteRows;
            ClientProtos.ScanResponse localResp;
            ScanResumerImpl scanResumerImpl = this;
            synchronized (scanResumerImpl) {
                if (this.state == ScanResumerState.INITIALIZED) {
                    this.state = ScanResumerState.RESUMED;
                    return;
                }
                if (this.state == ScanResumerState.RESUMED) {
                    return;
                }
                this.state = ScanResumerState.RESUMED;
                if (this.leaseRenewer != null) {
                    this.leaseRenewer.cancel();
                }
                localResp = this.resp;
                localNumberOfCompleteRows = this.numberOfCompleteRows;
            }
            AsyncScanSingleRegionRpcRetryingCaller.this.completeOrNext(localResp, localNumberOfCompleteRows);
        }

        private void scheduleRenewLeaseTask() {
            this.leaseRenewer = AsyncScanSingleRegionRpcRetryingCaller.this.retryTimer.newTimeout(t -> this.tryRenewLease(), AsyncScanSingleRegionRpcRetryingCaller.this.scannerLeaseTimeoutPeriodNs / 2L, TimeUnit.NANOSECONDS);
        }

        private synchronized void tryRenewLease() {
            if (this.state == ScanResumerState.RESUMED) {
                return;
            }
            AsyncScanSingleRegionRpcRetryingCaller.this.renewLease();
            this.scheduleRenewLeaseTask();
        }

        synchronized boolean prepare(ClientProtos.ScanResponse resp, int numberOfCompleteRows) {
            if (this.state == ScanResumerState.RESUMED) {
                return false;
            }
            this.state = ScanResumerState.SUSPENDED;
            this.resp = resp;
            this.numberOfCompleteRows = numberOfCompleteRows;
            if (resp.getMoreResultsInRegion()) {
                this.scheduleRenewLeaseTask();
            }
            return true;
        }
    }

    private static enum ScanResumerState {
        INITIALIZED,
        SUSPENDED,
        RESUMED;

    }

    private final class ScanControllerImpl
    implements RawScanResultConsumer.ScanController {
        private final Thread callerThread = Thread.currentThread();
        private ScanControllerState state = ScanControllerState.INITIALIZED;
        private ScanResumerImpl resumer;

        private ScanControllerImpl() {
        }

        private void preCheck() {
            Preconditions.checkState(Thread.currentThread() == this.callerThread, "The current thread is %s, expected thread is %s, you should not call this method outside onNext or onHeartbeat", Thread.currentThread(), this.callerThread);
            Preconditions.checkState(this.state.equals((Object)ScanControllerState.INITIALIZED), "Invalid Stopper state %s", new Object[]{this.state});
        }

        @Override
        public RawScanResultConsumer.ScanResumer suspend() {
            ScanResumerImpl resumer;
            this.preCheck();
            this.state = ScanControllerState.SUSPENDED;
            this.resumer = resumer = new ScanResumerImpl();
            return resumer;
        }

        @Override
        public void terminate() {
            this.preCheck();
            this.state = ScanControllerState.TERMINATED;
        }

        ScanControllerState destroy() {
            ScanControllerState state = this.state;
            this.state = ScanControllerState.DESTROYED;
            return state;
        }
    }

    private static enum ScanControllerState {
        INITIALIZED,
        SUSPENDED,
        TERMINATED,
        DESTROYED;

    }
}

