/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationPeerZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Public
@Deprecated
public class ReplicationAdmin
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationAdmin.class);
    public static final String TNAME = "tableName";
    public static final String CFNAME = "columnFamilyName";
    public static final String REPLICATIONTYPE = "replicationType";
    public static final String REPLICATIONGLOBAL = Integer.toString(1);
    public static final String REPLICATIONSERIAL = Integer.toString(2);
    private final Connection connection;
    private final ReplicationQueuesClient replicationQueuesClient;
    private final ReplicationPeers replicationPeers;
    private final ZooKeeperWatcher zkw;
    private Admin admin;

    public ReplicationAdmin(Configuration conf) throws IOException {
        this.connection = ConnectionFactory.createConnection(conf);
        this.admin = this.connection.getAdmin();
        try {
            this.zkw = this.createZooKeeperWatcher();
            try {
                this.replicationQueuesClient = ReplicationFactory.getReplicationQueuesClient(new ReplicationQueuesClientArguments(conf, this.connection, this.zkw));
                this.replicationQueuesClient.init();
                this.replicationPeers = ReplicationFactory.getReplicationPeers(this.zkw, conf, this.replicationQueuesClient, this.connection);
                this.replicationPeers.init();
            }
            catch (Exception exception) {
                if (this.zkw != null) {
                    this.zkw.close();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            this.connection.close();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IOException("Error initializing the replication admin client.", exception);
        }
    }

    private ZooKeeperWatcher createZooKeeperWatcher() throws IOException {
        return new ZooKeeperWatcher(this.connection.getConfiguration(), "ReplicationAdmin", new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.error((Object)why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        });
    }

    @Deprecated
    public void addPeer(String id, ReplicationPeerConfig peerConfig, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
        if (tableCfs != null) {
            peerConfig.setTableCFsMap(tableCfs);
        }
        this.admin.addReplicationPeer(id, peerConfig);
    }

    @Deprecated
    public void addPeer(String id, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        this.checkNamespacesAndTableCfsConfigConflict(peerConfig.getNamespaces(), peerConfig.getTableCFsMap());
        this.admin.addReplicationPeer(id, peerConfig);
    }

    @Deprecated
    public static Map<TableName, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        return ReplicationSerDeHelper.parseTableCFsFromConfig(tableCFsConfig);
    }

    @Deprecated
    public void updatePeerConfig(String id, ReplicationPeerConfig peerConfig) throws IOException {
        this.admin.updateReplicationPeerConfig(id, peerConfig);
    }

    @Deprecated
    public void removePeer(String id) throws IOException {
        this.admin.removeReplicationPeer(id);
    }

    @Deprecated
    public void enablePeer(String id) throws IOException {
        this.admin.enableReplicationPeer(id);
    }

    @Deprecated
    public void disablePeer(String id) throws IOException {
        this.admin.disableReplicationPeer(id);
    }

    @Deprecated
    public int getPeersCount() throws IOException {
        return this.admin.listReplicationPeers().size();
    }

    @Deprecated
    public Map<String, ReplicationPeerConfig> listPeerConfigs() throws IOException {
        List<ReplicationPeerDescription> peers = this.admin.listReplicationPeers();
        TreeMap<String, ReplicationPeerConfig> result = new TreeMap<String, ReplicationPeerConfig>();
        for (ReplicationPeerDescription peer : peers) {
            result.put(peer.getPeerId(), peer.getPeerConfig());
        }
        return result;
    }

    @Deprecated
    public ReplicationPeerConfig getPeerConfig(String id) throws IOException {
        return this.admin.getReplicationPeerConfig(id);
    }

    @Deprecated
    public String getPeerTableCFs(String id) throws IOException {
        ReplicationPeerConfig peerConfig = this.admin.getReplicationPeerConfig(id);
        return ReplicationSerDeHelper.convertToString(peerConfig.getTableCFsMap());
    }

    @Deprecated
    public void appendPeerTableCFs(String id, String tableCfs) throws ReplicationException, IOException {
        this.appendPeerTableCFs(id, ReplicationSerDeHelper.parseTableCFsFromConfig(tableCfs));
    }

    @Deprecated
    public void appendPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
        if (tableCfs == null) {
            throw new ReplicationException("tableCfs is null");
        }
        ReplicationPeerConfig peerConfig = this.admin.getReplicationPeerConfig(id);
        Map<TableName, List<String>> preTableCfs = peerConfig.getTableCFsMap();
        if (preTableCfs == null) {
            this.setPeerTableCFs(id, tableCfs);
            return;
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection<String> appendCfs = entry.getValue();
            if (preTableCfs.containsKey(table)) {
                List<String> cfs = preTableCfs.get(table);
                if (cfs == null || appendCfs == null || appendCfs.isEmpty()) {
                    preTableCfs.put(table, null);
                    continue;
                }
                HashSet<String> cfSet = new HashSet<String>(cfs);
                cfSet.addAll(appendCfs);
                preTableCfs.put(table, Lists.newArrayList(cfSet));
                continue;
            }
            if (appendCfs == null || appendCfs.isEmpty()) {
                preTableCfs.put(table, null);
                continue;
            }
            preTableCfs.put(table, Lists.newArrayList(appendCfs));
        }
        this.updatePeerConfig(id, peerConfig);
    }

    @Deprecated
    public void removePeerTableCFs(String id, String tableCf) throws ReplicationException, IOException {
        this.removePeerTableCFs(id, ReplicationSerDeHelper.parseTableCFsFromConfig(tableCf));
    }

    @Deprecated
    public void removePeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
        if (tableCfs == null) {
            throw new ReplicationException("tableCfs is null");
        }
        ReplicationPeerConfig peerConfig = this.admin.getReplicationPeerConfig(id);
        Map<TableName, List<String>> preTableCfs = peerConfig.getTableCFsMap();
        if (preTableCfs == null) {
            throw new ReplicationException("Table-Cfs for peer" + id + " is null");
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection<String> removeCfs = entry.getValue();
            if (preTableCfs.containsKey(table)) {
                List<String> cfs = preTableCfs.get(table);
                if (cfs == null && (removeCfs == null || removeCfs.isEmpty())) {
                    preTableCfs.remove(table);
                    continue;
                }
                if (cfs != null && removeCfs != null && !removeCfs.isEmpty()) {
                    HashSet<String> cfSet = new HashSet<String>(cfs);
                    cfSet.removeAll(removeCfs);
                    if (cfSet.isEmpty()) {
                        preTableCfs.remove(table);
                        continue;
                    }
                    preTableCfs.put(table, Lists.newArrayList(cfSet));
                    continue;
                }
                if (cfs == null && removeCfs != null && !removeCfs.isEmpty()) {
                    throw new ReplicationException("Cannot remove cf of table: " + table + " which doesn't specify cfs from table-cfs config in peer: " + id);
                }
                if (cfs == null || removeCfs != null && !removeCfs.isEmpty()) continue;
                throw new ReplicationException("Cannot remove table: " + table + " which has specified cfs from table-cfs config in peer: " + id);
            }
            throw new ReplicationException("No table: " + table + " in table-cfs config of peer: " + id);
        }
        this.updatePeerConfig(id, peerConfig);
    }

    @Deprecated
    public void setPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws IOException {
        ReplicationPeerConfig peerConfig = this.getPeerConfig(id);
        peerConfig.setTableCFsMap(tableCfs);
        this.updatePeerConfig(id, peerConfig);
    }

    @Deprecated
    public boolean getPeerState(String id) throws ReplicationException, IOException {
        List<ReplicationPeerDescription> peers = this.admin.listReplicationPeers(id);
        if (peers.isEmpty() || !id.equals(peers.get(0).getPeerId())) {
            throw new ReplicationPeerNotFoundException(id);
        }
        return peers.get(0).isEnabled();
    }

    @Override
    public void close() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.admin.close();
    }

    @Deprecated
    public List<HashMap<String, String>> listReplicated() throws IOException {
        ArrayList<HashMap<String, String>> replicationColFams = new ArrayList<HashMap<String, String>>();
        this.admin.listReplicatedTableCFs().forEach(tableCFs -> {
            String table = tableCFs.getTable().getNameAsString();
            tableCFs.getColumnFamilyMap().forEach((cf, scope) -> {
                HashMap<String, String> replicationEntry = new HashMap<String, String>();
                replicationEntry.put(TNAME, table);
                replicationEntry.put(CFNAME, (String)cf);
                replicationEntry.put(REPLICATIONTYPE, scope == 1 ? REPLICATIONGLOBAL : REPLICATIONSERIAL);
                replicationColFams.add(replicationEntry);
            });
        });
        return replicationColFams;
    }

    @Deprecated
    public void enableTableRep(TableName tableName) throws IOException {
        this.admin.enableTableReplication(tableName);
    }

    @Deprecated
    public void disableTableRep(TableName tableName) throws IOException {
        this.admin.disableTableReplication(tableName);
    }

    @Deprecated
    @VisibleForTesting
    public void peerAdded(String id) throws ReplicationException {
        this.replicationPeers.peerConnected(id);
    }

    @Deprecated
    @VisibleForTesting
    List<ReplicationPeer> listReplicationPeers() throws IOException {
        Map<String, ReplicationPeerConfig> peers = this.listPeerConfigs();
        if (peers == null || peers.size() <= 0) {
            return null;
        }
        ArrayList<ReplicationPeer> listOfPeers = new ArrayList<ReplicationPeer>(peers.size());
        for (Map.Entry<String, ReplicationPeerConfig> peerEntry : peers.entrySet()) {
            String peerId = peerEntry.getKey();
            try {
                Pair<ReplicationPeerConfig, Configuration> pair = this.replicationPeers.getPeerConf(peerId);
                Configuration peerConf = pair.getSecond();
                ReplicationPeerZKImpl peer = new ReplicationPeerZKImpl(this.zkw, pair.getSecond(), peerId, pair.getFirst(), this.connection);
                listOfPeers.add(peer);
            }
            catch (ReplicationException e) {
                LOG.warn((Object)("Failed to get valid replication peers. Error connecting to peer cluster with peerId=" + peerId + ". Error message=" + e.getMessage()));
                LOG.debug((Object)"Failure details to get valid replication peers.", (Throwable)e);
            }
        }
        return listOfPeers;
    }

    private void checkNamespacesAndTableCfsConfigConflict(Set<String> namespaces, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        if (namespaces == null || namespaces.isEmpty()) {
            return;
        }
        if (tableCfs == null || tableCfs.isEmpty()) {
            return;
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            if (!namespaces.contains(table.getNamespaceAsString())) continue;
            throw new ReplicationException("Table-cfs config conflict with namespaces config in peer");
        }
    }
}

