/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;

@InterfaceAudience.Private
public class ByteBufferWriterOutputStream
extends OutputStream
implements ByteBufferWriter {
    private static final int TEMP_BUF_LENGTH = 4096;
    private final OutputStream os;
    private byte[] tempBuf = null;

    public ByteBufferWriterOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(ByteBuffer b, int off, int len) throws IOException {
        byte[] buf = null;
        if (len > 4096) {
            buf = new byte[len];
        } else {
            if (this.tempBuf == null) {
                this.tempBuf = new byte[4096];
            }
            buf = this.tempBuf;
        }
        ByteBufferUtils.copyFromBufferToArray(buf, b, off, 0, len);
        this.os.write(buf, 0, len);
    }

    @Override
    public void writeInt(int i) throws IOException {
        StreamUtils.writeInt(this.os, i);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

