/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.aes;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.utils.Utils;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CryptoAES {
    private final CryptoCipher encryptor;
    private final CryptoCipher decryptor;
    private final Integrity integrity;

    public CryptoAES(String transformation, Properties properties, byte[] inKey, byte[] outKey, byte[] inIv, byte[] outIv) throws IOException {
        this.checkTransformation(transformation);
        this.encryptor = Utils.getCipherInstance(transformation, properties);
        try {
            SecretKeySpec outKEYSpec = new SecretKeySpec(outKey, "AES");
            IvParameterSpec outIVSpec = new IvParameterSpec(outIv);
            this.encryptor.init(1, outKEYSpec, outIVSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IOException("Failed to initialize encryptor", e);
        }
        this.decryptor = Utils.getCipherInstance(transformation, properties);
        try {
            SecretKeySpec inKEYSpec = new SecretKeySpec(inKey, "AES");
            IvParameterSpec inIVSpec = new IvParameterSpec(inIv);
            this.decryptor.init(2, inKEYSpec, inIVSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IOException("Failed to initialize decryptor", e);
        }
        this.integrity = new Integrity(outKey, inKey);
    }

    public byte[] wrap(byte[] data, int offset, int len) throws SaslException {
        byte[] mac = this.integrity.getHMAC(data, offset, len);
        this.integrity.incMySeqNum();
        byte[] encrypted = new byte[len + 10];
        try {
            int n = this.encryptor.update(data, offset, len, encrypted, 0);
            this.encryptor.update(mac, 0, 10, encrypted, n);
        }
        catch (ShortBufferException sbe) {
            throw new SaslException("Error happens during encrypt data", sbe);
        }
        byte[] wrapped = new byte[encrypted.length + 4];
        System.arraycopy(encrypted, 0, wrapped, 0, encrypted.length);
        System.arraycopy(this.integrity.getSeqNum(), 0, wrapped, encrypted.length, 4);
        return wrapped;
    }

    public byte[] unwrap(byte[] data, int offset, int len) throws SaslException {
        byte[] decrypted = new byte[len - 4];
        byte[] peerSeqNum = new byte[4];
        try {
            this.decryptor.update(data, offset, len - 4, decrypted, 0);
        }
        catch (ShortBufferException sbe) {
            throw new SaslException("Error happens during decrypt data", sbe);
        }
        System.arraycopy(data, offset + decrypted.length, peerSeqNum, 0, 4);
        byte[] msg = new byte[decrypted.length - 10];
        byte[] mac = new byte[10];
        System.arraycopy(decrypted, 0, msg, 0, msg.length);
        System.arraycopy(decrypted, msg.length, mac, 0, 10);
        if (!this.integrity.compareHMAC(mac, peerSeqNum, msg, 0, msg.length)) {
            throw new SaslException("Unmatched MAC");
        }
        if (!this.integrity.comparePeerSeqNum(peerSeqNum)) {
            throw new SaslException("Out of order sequencing of messages. Got: " + this.integrity.byteToInt(peerSeqNum) + " Expected: " + this.integrity.peerSeqNum);
        }
        this.integrity.incPeerSeqNum();
        return msg;
    }

    private void checkTransformation(String transformation) throws IOException {
        if ("AES/CTR/NoPadding".equalsIgnoreCase(transformation)) {
            return;
        }
        throw new IOException("AES cipher transformation is not supported: " + transformation);
    }

    private static class Integrity {
        private int mySeqNum = 0;
        private int peerSeqNum = 0;
        private byte[] seqNum = new byte[4];
        private byte[] myKey;
        private byte[] peerKey;

        Integrity(byte[] outKey, byte[] inKey) throws IOException {
            this.myKey = outKey;
            this.peerKey = inKey;
        }

        byte[] getHMAC(byte[] msg, int start, int len) throws SaslException {
            this.intToByte(this.mySeqNum);
            return this.calculateHMAC(this.myKey, this.seqNum, msg, start, len);
        }

        boolean compareHMAC(byte[] expectedHMAC, byte[] peerSeqNum, byte[] msg, int start, int len) throws SaslException {
            byte[] mac = this.calculateHMAC(this.peerKey, peerSeqNum, msg, start, len);
            return Arrays.equals(mac, expectedHMAC);
        }

        boolean comparePeerSeqNum(byte[] peerSeqNum) {
            return this.peerSeqNum == this.byteToInt(peerSeqNum);
        }

        byte[] getSeqNum() {
            return this.seqNum;
        }

        void incMySeqNum() {
            ++this.mySeqNum;
        }

        void incPeerSeqNum() {
            ++this.peerSeqNum;
        }

        private byte[] calculateHMAC(byte[] key, byte[] seqNum, byte[] msg, int start, int len) throws SaslException {
            byte[] seqAndMsg = new byte[4 + len];
            System.arraycopy(seqNum, 0, seqAndMsg, 0, 4);
            System.arraycopy(msg, start, seqAndMsg, 4, len);
            try {
                SecretKeySpec keyKi = new SecretKeySpec(key, "HmacMD5");
                Mac m = Mac.getInstance("HmacMD5");
                m.init(keyKi);
                m.update(seqAndMsg);
                byte[] hMAC_MD5 = m.doFinal();
                byte[] macBuffer = new byte[10];
                System.arraycopy(hMAC_MD5, 0, macBuffer, 0, 10);
                return macBuffer;
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Invalid bytes used for key of HMAC-MD5 hash.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Error creating instance of MD5 MAC algorithm", e);
            }
        }

        private void intToByte(int num) {
            for (int i = 3; i >= 0; --i) {
                this.seqNum[i] = (byte)(num & 0xFF);
                num >>>= 8;
            }
        }

        private int byteToInt(byte[] seqNum) {
            int answer = 0;
            for (int i = 0; i < 4; ++i) {
                answer <<= 8;
                answer |= seqNum[i] & 0xFF;
            }
            return answer;
        }
    }
}

