/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Public
@SuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="None. Address sometime.")
public class RemoteWithExtrasException
extends RemoteException {
    private final String hostname;
    private final int port;
    private final boolean doNotRetry;
    private static final ClassLoader CLASS_LOADER;

    public RemoteWithExtrasException(String className, String msg, boolean doNotRetry) {
        this(className, msg, null, -1, doNotRetry);
    }

    public RemoteWithExtrasException(String className, String msg, String hostname, int port, boolean doNotRetry) {
        super(className, msg);
        this.hostname = hostname;
        this.port = port;
        this.doNotRetry = doNotRetry;
    }

    @Override
    public IOException unwrapRemoteException() {
        Class<?> realClass;
        try {
            realClass = Class.forName(this.getClassName(), false, CLASS_LOADER);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                realClass = Class.forName(this.getClassName(), false, super.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                return new DoNotRetryIOException("Unable to load exception received from server:" + e.getMessage(), this);
            }
        }
        try {
            return this.instantiateException(realClass.asSubclass(IOException.class));
        }
        catch (Exception e) {
            return new DoNotRetryIOException("Unable to instantiate exception received from server:" + e.getMessage(), this);
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        IOException ex = cn.newInstance(this.getMessage());
        ex.initCause(this);
        return ex;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isDoNotRetry() {
        return this.doNotRetry;
    }

    static {
        ClassLoader parent = RemoteWithExtrasException.class.getClassLoader();
        Configuration conf = HBaseConfiguration.create();
        CLASS_LOADER = new DynamicClassLoader(conf, parent);
    }
}

