/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;

@InterfaceAudience.Public
public class QuotaSettingsFactory {
    static List<QuotaSettings> fromUserQuotas(String userName, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(userName, null, null, quotas);
    }

    static List<QuotaSettings> fromUserQuotas(String userName, TableName tableName, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(userName, tableName, null, quotas);
    }

    static List<QuotaSettings> fromUserQuotas(String userName, String namespace, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(userName, null, namespace, quotas);
    }

    static List<QuotaSettings> fromTableQuotas(TableName tableName, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(null, tableName, null, quotas);
    }

    static List<QuotaSettings> fromNamespaceQuotas(String namespace, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(null, null, namespace, quotas);
    }

    private static List<QuotaSettings> fromQuotas(String userName, TableName tableName, String namespace, QuotaProtos.Quotas quotas) {
        ArrayList<QuotaSettings> settings = new ArrayList<QuotaSettings>();
        if (quotas.hasThrottle()) {
            settings.addAll(QuotaSettingsFactory.fromThrottle(userName, tableName, namespace, quotas.getThrottle()));
        }
        if (quotas.getBypassGlobals()) {
            settings.add(new QuotaGlobalsSettingsBypass(userName, tableName, namespace, true));
        }
        if (quotas.hasSpace()) {
            settings.add(QuotaSettingsFactory.fromSpace(tableName, namespace, quotas.getSpace()));
        }
        return settings;
    }

    private static List<QuotaSettings> fromThrottle(String userName, TableName tableName, String namespace, QuotaProtos.Throttle throttle) {
        ArrayList<QuotaSettings> settings = new ArrayList<QuotaSettings>();
        if (throttle.hasReqNum()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, ThrottleType.REQUEST_NUMBER, throttle.getReqNum()));
        }
        if (throttle.hasReqSize()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, ThrottleType.REQUEST_SIZE, throttle.getReqSize()));
        }
        if (throttle.hasWriteNum()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, ThrottleType.WRITE_NUMBER, throttle.getWriteNum()));
        }
        if (throttle.hasWriteSize()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, ThrottleType.WRITE_SIZE, throttle.getWriteSize()));
        }
        if (throttle.hasReadNum()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, ThrottleType.READ_NUMBER, throttle.getReadNum()));
        }
        if (throttle.hasReadSize()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, ThrottleType.READ_SIZE, throttle.getReadSize()));
        }
        return settings;
    }

    static QuotaSettings fromSpace(TableName table, String namespace, QuotaProtos.SpaceQuota protoQuota) {
        if (table == null && namespace == null || table != null && namespace != null) {
            throw new IllegalArgumentException("Can only construct SpaceLimitSettings for a table or namespace.");
        }
        if (table != null) {
            return SpaceLimitSettings.fromSpaceQuota(table, protoQuota);
        }
        return SpaceLimitSettings.fromSpaceQuota(namespace, protoQuota);
    }

    public static QuotaSettings throttleUser(String userName, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttle(userName, null, null, type, limit, timeUnit);
    }

    public static QuotaSettings throttleUser(String userName, TableName tableName, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttle(userName, tableName, null, type, limit, timeUnit);
    }

    public static QuotaSettings throttleUser(String userName, String namespace, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttle(userName, null, namespace, type, limit, timeUnit);
    }

    public static QuotaSettings unthrottleUser(String userName) {
        return QuotaSettingsFactory.throttle(userName, null, null, null, 0L, null);
    }

    public static QuotaSettings unthrottleUser(String userName, TableName tableName) {
        return QuotaSettingsFactory.throttle(userName, tableName, null, null, 0L, null);
    }

    public static QuotaSettings unthrottleUser(String userName, String namespace) {
        return QuotaSettingsFactory.throttle(userName, null, namespace, null, 0L, null);
    }

    public static QuotaSettings throttleTable(TableName tableName, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttle(null, tableName, null, type, limit, timeUnit);
    }

    public static QuotaSettings unthrottleTable(TableName tableName) {
        return QuotaSettingsFactory.throttle(null, tableName, null, null, 0L, null);
    }

    public static QuotaSettings throttleNamespace(String namespace, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttle(null, null, namespace, type, limit, timeUnit);
    }

    public static QuotaSettings unthrottleNamespace(String namespace) {
        return QuotaSettingsFactory.throttle(null, null, namespace, null, 0L, null);
    }

    private static QuotaSettings throttle(String userName, TableName tableName, String namespace, ThrottleType type, long limit, TimeUnit timeUnit) {
        QuotaProtos.ThrottleRequest.Builder builder = QuotaProtos.ThrottleRequest.newBuilder();
        if (type != null) {
            builder.setType(ProtobufUtil.toProtoThrottleType(type));
        }
        if (timeUnit != null) {
            builder.setTimedQuota(ProtobufUtil.toTimedQuota(limit, timeUnit, QuotaScope.MACHINE));
        }
        return new ThrottleSettings(userName, tableName, namespace, builder.build());
    }

    public static QuotaSettings bypassGlobals(String userName, boolean bypassGlobals) {
        return new QuotaGlobalsSettingsBypass(userName, null, null, bypassGlobals);
    }

    public static QuotaSettings limitTableSpace(TableName tableName, long sizeLimit, SpaceViolationPolicy violationPolicy) {
        return new SpaceLimitSettings(tableName, sizeLimit, violationPolicy);
    }

    public static QuotaSettings removeTableSpaceLimit(TableName tableName) {
        return new SpaceLimitSettings(tableName);
    }

    public static QuotaSettings limitNamespaceSpace(String namespace, long sizeLimit, SpaceViolationPolicy violationPolicy) {
        return new SpaceLimitSettings(namespace, sizeLimit, violationPolicy);
    }

    public static QuotaSettings removeNamespaceSpaceLimit(String namespace) {
        return new SpaceLimitSettings(namespace);
    }

    static class QuotaGlobalsSettingsBypass
    extends QuotaSettings {
        private final boolean bypassGlobals;

        QuotaGlobalsSettingsBypass(String userName, TableName tableName, String namespace, boolean bypassGlobals) {
            super(userName, tableName, namespace);
            this.bypassGlobals = bypassGlobals;
        }

        @Override
        public QuotaType getQuotaType() {
            return QuotaType.GLOBAL_BYPASS;
        }

        @Override
        protected void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder builder) {
            builder.setBypassGlobals(this.bypassGlobals);
        }

        public String toString() {
            return "GLOBAL_BYPASS => " + this.bypassGlobals;
        }
    }
}

