/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Objects;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class SpaceLimitSettings
extends QuotaSettings {
    private final QuotaProtos.SpaceLimitRequest proto;

    SpaceLimitSettings(TableName tableName, long sizeLimit, SpaceViolationPolicy violationPolicy) {
        super(null, Objects.requireNonNull(tableName), null);
        if (sizeLimit < 0L) {
            throw new IllegalArgumentException("Size limit must be a non-negative value.");
        }
        this.proto = this.buildProtoAddQuota(sizeLimit, Objects.requireNonNull(violationPolicy));
    }

    SpaceLimitSettings(TableName tableName) {
        super(null, Objects.requireNonNull(tableName), null);
        this.proto = this.buildProtoRemoveQuota();
    }

    SpaceLimitSettings(String namespace, long sizeLimit, SpaceViolationPolicy violationPolicy) {
        super(null, null, Objects.requireNonNull(namespace));
        if (sizeLimit < 0L) {
            throw new IllegalArgumentException("Size limit must be a non-negative value.");
        }
        this.proto = this.buildProtoAddQuota(sizeLimit, Objects.requireNonNull(violationPolicy));
    }

    SpaceLimitSettings(String namespace) {
        super(null, null, Objects.requireNonNull(namespace));
        this.proto = this.buildProtoRemoveQuota();
    }

    private QuotaProtos.SpaceLimitRequest buildProtoAddQuota(long sizeLimit, SpaceViolationPolicy violationPolicy) {
        return QuotaProtos.SpaceLimitRequest.newBuilder().setQuota(QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(sizeLimit).setViolationPolicy(ProtobufUtil.toProtoViolationPolicy(violationPolicy)).build()).build();
    }

    private QuotaProtos.SpaceLimitRequest buildProtoRemoveQuota() {
        return QuotaProtos.SpaceLimitRequest.newBuilder().setQuota(QuotaProtos.SpaceQuota.newBuilder().setRemove(true).build()).build();
    }

    QuotaProtos.SpaceLimitRequest getProto() {
        return this.proto.toBuilder().build();
    }

    @Override
    public QuotaType getQuotaType() {
        return QuotaType.SPACE;
    }

    @Override
    protected void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder builder) {
        builder.setSpaceLimit(this.proto);
    }

    static SpaceLimitSettings fromSpaceQuota(TableName tableName, QuotaProtos.SpaceQuota proto) {
        SpaceLimitSettings.validateProtoArguments(proto);
        return new SpaceLimitSettings(tableName, proto.getSoftLimit(), ProtobufUtil.toViolationPolicy(proto.getViolationPolicy()));
    }

    static SpaceLimitSettings fromSpaceQuota(String namespace, QuotaProtos.SpaceQuota proto) {
        SpaceLimitSettings.validateProtoArguments(proto);
        return new SpaceLimitSettings(namespace, proto.getSoftLimit(), ProtobufUtil.toViolationPolicy(proto.getViolationPolicy()));
    }

    static void validateProtoArguments(QuotaProtos.SpaceQuota proto) {
        if (!Objects.requireNonNull(proto).hasSoftLimit()) {
            throw new IllegalArgumentException("Cannot handle SpaceQuota without a soft limit");
        }
        if (!proto.hasViolationPolicy()) {
            throw new IllegalArgumentException("Cannot handle SpaceQuota without a violation policy");
        }
    }

    public int hashCode() {
        return Objects.hash(this.getTableName(), this.getNamespace(), this.proto);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceLimitSettings)) {
            return false;
        }
        SpaceLimitSettings other = (SpaceLimitSettings)o;
        return Objects.equals(this.getTableName(), other.getTableName()) && Objects.equals(this.getNamespace(), other.getNamespace()) && Objects.equals(this.proto, other.proto);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE => SPACE");
        if (this.getTableName() != null) {
            sb.append(", TABLE => ").append(this.getTableName());
        }
        if (this.getNamespace() != null) {
            sb.append(", NAMESPACE => ").append(this.getNamespace());
        }
        if (this.proto.getQuota().getRemove()) {
            sb.append(", REMOVE => ").append(this.proto.getQuota().getRemove());
        } else {
            sb.append(", LIMIT => ").append(this.proto.getQuota().getSoftLimit());
            sb.append(", VIOLATION_POLICY => ").append(this.proto.getQuota().getViolationPolicy());
        }
        return sb.toString();
    }
}

