/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsHeapMemoryManagerSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
public class MetricsHeapMemoryManagerSourceImpl
extends BaseSourceImpl
implements MetricsHeapMemoryManagerSource {
    private final MetricHistogram blockedFlushHistogram = this.getMetricsRegistry().newSizeHistogram("blockedFlushes", "Histogram for the number of blocked flushes in the memstore");
    private final MetricHistogram unblockedFlushHistogram = this.getMetricsRegistry().newSizeHistogram("unblockedFlushes", "Histogram for the number of unblocked flushes in the memstore");
    private final MetricHistogram incMemStoreSizeHistogram = this.getMetricsRegistry().newSizeHistogram("increaseMemStoreSize", "Histogram for the heap memory tuner expanding memstore global size limit in bytes");
    private final MetricHistogram decMemStoreSizeHistogram = this.getMetricsRegistry().newSizeHistogram("decreaseMemStoreSize", "Histogram for the heap memory tuner shrinking memstore global size limit in bytes");
    private final MetricHistogram incBlockCacheSizeHistogram = this.getMetricsRegistry().newSizeHistogram("increaseBlockCacheSize", "Histogram for the heap memory tuner expanding blockcache max heap size in bytes");
    private final MetricHistogram decBlockCacheSizeHistogram = this.getMetricsRegistry().newSizeHistogram("decreaseBlockCacheSize", "Histogram for the heap memory tuner shrinking blockcache max heap size in bytes");
    private final MutableGaugeLong blockedFlushGauge = this.getMetricsRegistry().newGauge("blockedFlushGauge", "Gauge for the blocked flush count before tuning", 0L);
    private final MutableGaugeLong unblockedFlushGauge = this.getMetricsRegistry().newGauge("unblockedFlushGauge", "Gauge for the unblocked flush count before tuning", 0L);
    private final MutableGaugeLong memStoreSizeGauge = this.getMetricsRegistry().newGauge("memStoreSize", "Global MemStore used in bytes by the RegionServer", 0L);
    private final MutableGaugeLong blockCacheSizeGauge = this.getMetricsRegistry().newGauge("blockCacheSize", "BlockCache used in bytes by the RegionServer", 0L);
    private final MutableFastCounter doNothingCounter = this.getMetricsRegistry().newCounter("tunerDoNothingCounter", "The number of times that tuner neither expands memstore global size limit nor expands blockcache max size", 0L);
    private final MutableFastCounter aboveHeapOccupancyLowWatermarkCounter = this.getMetricsRegistry().newCounter("aboveHeapOccupancyLowWaterMarkCounter", "The number of times that heap occupancy percent is above low watermark", 0L);

    public MetricsHeapMemoryManagerSourceImpl() {
        this("Memory", "Metrics about HBase RegionServer's memory", "regionserver", "RegionServer,sub=Memory");
    }

    public MetricsHeapMemoryManagerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void updateBlockedFlushCount(long blockedFlushCount) {
        if (blockedFlushCount > 0L) {
            this.blockedFlushHistogram.add(blockedFlushCount);
            this.blockedFlushGauge.set(blockedFlushCount);
        }
    }

    @Override
    public void updateUnblockedFlushCount(long unblockedFlushCount) {
        if (unblockedFlushCount > 0L) {
            this.unblockedFlushHistogram.add(unblockedFlushCount);
            this.unblockedFlushGauge.set(unblockedFlushCount);
        }
    }

    @Override
    public void setCurBlockCacheSizeGauge(long blockcacheSize) {
        this.blockCacheSizeGauge.set(blockcacheSize);
    }

    @Override
    public void setCurMemStoreSizeGauge(long memstoreSize) {
        this.memStoreSizeGauge.set(memstoreSize);
    }

    @Override
    public void updateMemStoreDeltaSizeHistogram(int memStoreDeltaSize) {
        if (memStoreDeltaSize >= 0) {
            this.incMemStoreSizeHistogram.add(memStoreDeltaSize);
        } else if (memStoreDeltaSize < 0) {
            this.decMemStoreSizeHistogram.add(-memStoreDeltaSize);
        }
    }

    @Override
    public void updateBlockCacheDeltaSizeHistogram(int blockCacheDeltaSize) {
        if (blockCacheDeltaSize >= 0) {
            this.incBlockCacheSizeHistogram.add(blockCacheDeltaSize);
        } else if (blockCacheDeltaSize < 0) {
            this.decBlockCacheSizeHistogram.add(-blockCacheDeltaSize);
        }
    }

    @Override
    public void increaseTunerDoNothingCounter() {
        this.doNothingCounter.incr();
    }

    @Override
    public void increaseAboveHeapOccupancyLowWatermarkCounter() {
        this.aboveHeapOccupancyLowWatermarkCounter.incr();
    }
}

