/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public final class Superusers {
    private static final Log LOG = LogFactory.getLog(Superusers.class);
    public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
    private static List<String> superUsers;
    private static List<String> superGroups;
    private static User systemUser;

    private Superusers() {
    }

    public static void initialize(Configuration conf) throws IOException {
        String[] superUserList;
        superUsers = new ArrayList<String>();
        superGroups = new ArrayList<String>();
        systemUser = User.getCurrent();
        if (systemUser == null) {
            throw new IllegalStateException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current user name is " + systemUser.getShortName()));
        }
        String currentUser = systemUser.getShortName();
        for (String name : superUserList = conf.getStrings(SUPERUSER_CONF_KEY, new String[0])) {
            if (AuthUtil.isGroupPrincipal(name)) {
                superGroups.add(AuthUtil.getGroupName(name));
                continue;
            }
            superUsers.add(name);
        }
        superUsers.add(currentUser);
    }

    public static boolean isSuperUser(User user) {
        if (superUsers == null) {
            throw new IllegalStateException("Super users/super groups lists haven't been initialized properly.");
        }
        if (superUsers.contains(user.getShortName())) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!superGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSuperUsers() {
        return superUsers;
    }

    public static User getSystemUser() {
        return systemUser;
    }
}

