/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.jcraft.jsch.jce;

import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.MAC;

public class HMACSHA1
implements MAC {
    private static final String name = "hmac-sha1";
    private static final int bsize = 20;
    private Mac mac;
    private final byte[] tmp = new byte[4];

    public int getBlockSize() {
        return 20;
    }

    public void init(byte[] byArray) throws Exception {
        Object object;
        if (byArray.length > 20) {
            object = new byte[20];
            System.arraycopy(byArray, 0, object, 0, 20);
            byArray = object;
        }
        object = new SecretKeySpec(byArray, "HmacSHA1");
        this.mac = Mac.getInstance("HmacSHA1");
        this.mac.init((Key)object);
    }

    public void update(int n) {
        this.tmp[0] = (byte)(n >>> 24);
        this.tmp[1] = (byte)(n >>> 16);
        this.tmp[2] = (byte)(n >>> 8);
        this.tmp[3] = (byte)n;
        this.update(this.tmp, 0, 4);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
    }

    public void doFinal(byte[] byArray, int n) {
        try {
            this.mac.doFinal(byArray, n);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
    }

    public String getName() {
        return name;
    }
}

