/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2;

import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.DefaultByteBufHolder;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.Unpooled;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;

public final class DefaultHttp2GoAwayFrame
extends DefaultByteBufHolder
implements Http2GoAwayFrame {
    private final long errorCode;
    private int extraStreamIds;

    public DefaultHttp2GoAwayFrame(Http2Error error) {
        this(error.code());
    }

    public DefaultHttp2GoAwayFrame(long errorCode) {
        this(errorCode, Unpooled.EMPTY_BUFFER);
    }

    public DefaultHttp2GoAwayFrame(Http2Error error, ByteBuf content) {
        this(error.code(), content);
    }

    public DefaultHttp2GoAwayFrame(long errorCode, ByteBuf content) {
        super(content);
        this.errorCode = errorCode;
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    @Override
    public int extraStreamIds() {
        return this.extraStreamIds;
    }

    @Override
    public Http2GoAwayFrame setExtraStreamIds(int extraStreamIds) {
        if (extraStreamIds < 0) {
            throw new IllegalArgumentException("extraStreamIds must be non-negative");
        }
        this.extraStreamIds = extraStreamIds;
        return this;
    }

    @Override
    public Http2GoAwayFrame copy() {
        return (Http2GoAwayFrame)super.copy();
    }

    @Override
    public Http2GoAwayFrame duplicate() {
        return (Http2GoAwayFrame)super.duplicate();
    }

    @Override
    public Http2GoAwayFrame retainedDuplicate() {
        return (Http2GoAwayFrame)super.retainedDuplicate();
    }

    @Override
    public Http2GoAwayFrame replace(ByteBuf content) {
        return new DefaultHttp2GoAwayFrame(this.errorCode, content).setExtraStreamIds(this.extraStreamIds);
    }

    @Override
    public Http2GoAwayFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public Http2GoAwayFrame retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public Http2GoAwayFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public Http2GoAwayFrame touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2GoAwayFrame)) {
            return false;
        }
        DefaultHttp2GoAwayFrame other = (DefaultHttp2GoAwayFrame)o;
        return super.equals(o) && this.errorCode == other.errorCode && this.content().equals(other.content()) && this.extraStreamIds == other.extraStreamIds;
    }

    @Override
    public int hashCode() {
        int hash = 237395317;
        hash = hash * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        hash = hash * 31 + this.content().hashCode();
        hash = hash * 31 + this.extraStreamIds;
        return hash;
    }

    @Override
    public String toString() {
        return "DefaultHttp2GoAwayFrame(errorCode=" + this.errorCode + ", content=" + this.content() + ", extraStreamIds=" + this.extraStreamIds + ")";
    }
}

