/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.resolver.dns;

import java.net.IDN;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.hadoop.hbase.shaded.io.netty.channel.AddressedEnvelope;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelFuture;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelInitializer;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.channel.FixedRecvByteBufAllocator;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.DatagramChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DatagramDnsResponse;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsResponse;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.HostsFileEntriesResolver;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.InetNameResolver;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsCache;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsCacheEntry;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsNameResolverContext;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsQueryContext;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsQueryContextManager;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsServerAddresses;
import org.apache.hadoop.hbase.shaded.io.netty.util.NetUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.FastThreadLocal;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.Future;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.Promise;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.ObjectUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class DnsNameResolver
extends InetNameResolver {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
    static final InetSocketAddress ANY_LOCAL_ADDR = new InetSocketAddress(0);
    static final InternetProtocolFamily[] DEFAULT_RESOLVE_ADDRESS_TYPES = new InternetProtocolFamily[2];
    private static final DatagramDnsResponseDecoder DECODER;
    private static final DatagramDnsQueryEncoder ENCODER;
    final DnsServerAddresses nameServerAddresses;
    final ChannelFuture bindFuture;
    final DatagramChannel ch;
    final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        @Override
        protected DnsServerAddressStream initialValue() throws Exception {
            return DnsNameResolver.this.nameServerAddresses.stream();
        }
    };
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final boolean traceEnabled;
    private final InternetProtocolFamily[] resolvedAddressTypes;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final boolean optResourceEnabled;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress, DnsServerAddresses nameServerAddresses, DnsCache resolveCache, long queryTimeoutMillis, InternetProtocolFamily[] resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver) {
        super(eventLoop);
        ObjectUtil.checkNotNull(channelFactory, "channelFactory");
        ObjectUtil.checkNotNull(localAddress, "localAddress");
        this.nameServerAddresses = ObjectUtil.checkNotNull(nameServerAddresses, "nameServerAddresses");
        this.queryTimeoutMillis = ObjectUtil.checkPositive(queryTimeoutMillis, "queryTimeoutMillis");
        this.resolvedAddressTypes = ObjectUtil.checkNonEmpty(resolvedAddressTypes, "resolvedAddressTypes");
        this.recursionDesired = recursionDesired;
        this.maxQueriesPerResolve = ObjectUtil.checkPositive(maxQueriesPerResolve, "maxQueriesPerResolve");
        this.traceEnabled = traceEnabled;
        this.maxPayloadSize = ObjectUtil.checkPositive(maxPayloadSize, "maxPayloadSize");
        this.optResourceEnabled = optResourceEnabled;
        this.hostsFileEntriesResolver = ObjectUtil.checkNotNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        this.resolveCache = resolveCache;
        this.bindFuture = this.newChannel(channelFactory, localAddress);
        this.ch = (DatagramChannel)this.bindFuture.channel();
        this.ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(maxPayloadSize));
    }

    private ChannelFuture newChannel(ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress) {
        Bootstrap b = new Bootstrap();
        b.group(this.executor());
        b.channelFactory(channelFactory);
        final DnsResponseHandler responseHandler = new DnsResponseHandler();
        b.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(DECODER, ENCODER, responseHandler);
            }
        });
        ChannelFuture bindFuture = b.bind(localAddress);
        bindFuture.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                DnsNameResolver.this.resolveCache.clear();
            }
        });
        return bindFuture;
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public List<InternetProtocolFamily> resolvedAddressTypes() {
        return Arrays.asList(this.resolvedAddressTypes);
    }

    InternetProtocolFamily[] resolveAddressTypesUnsafe() {
        return this.resolvedAddressTypes;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    @Override
    public void close() {
        this.ch.close();
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    private InetAddress resolveHostsFileEntry(String hostname) {
        return this.hostsFileEntriesResolver != null ? this.hostsFileEntriesResolver.address(hostname) : null;
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        this.doResolve(inetHost, promise, this.resolveCache);
    }

    protected void doResolve(String inetHost, Promise<InetAddress> promise, DnsCache resolveCache) throws Exception {
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString(inetHost);
        if (bytes != null) {
            promise.setSuccess(InetAddress.getByAddress(bytes));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess(hostsFileEntry);
            return;
        }
        if (!this.doResolveCached(hostname, promise, resolveCache)) {
            this.doResolveUncached(hostname, promise, resolveCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveCached(String hostname, Promise<InetAddress> promise, DnsCache resolveCache) {
        List<DnsCacheEntry> cachedEntries = resolveCache.get(hostname);
        if (cachedEntries == null) {
            return false;
        }
        InetAddress address = null;
        Throwable cause = null;
        List<DnsCacheEntry> list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (cachedEntries.get(0).cause() != null) {
                cause = cachedEntries.get(0).cause();
            } else {
                block3: for (InternetProtocolFamily f : this.resolvedAddressTypes) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        address = e.address();
                        continue block3;
                    }
                }
            }
        }
        if (address != null) {
            DnsNameResolver.setSuccess(promise, address);
        } else if (cause != null) {
            if (!promise.tryFailure(cause)) {
                logger.warn("Failed to notify failure to a promise: {}", (Object)promise, (Object)cause);
            }
        } else {
            return false;
        }
        return true;
    }

    private static void setSuccess(Promise<InetAddress> promise, InetAddress result) {
        if (!promise.trySuccess(result)) {
            logger.warn("Failed to notify success ({}) to a promise: {}", (Object)result, (Object)promise);
        }
    }

    private void doResolveUncached(String hostname, Promise<InetAddress> promise, DnsCache resolveCache) {
        DnsNameResolverContext<InetAddress> ctx = new DnsNameResolverContext<InetAddress>(this, hostname, promise, resolveCache){

            @Override
            protected boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries) {
                int numEntries = resolvedEntries.size();
                for (int i = 0; i < numEntries; ++i) {
                    InetAddress a = resolvedEntries.get(i).address();
                    if (!addressType.isInstance(a)) continue;
                    DnsNameResolver.setSuccess(this.promise(), a);
                    return true;
                }
                return false;
            }
        };
        ctx.resolve();
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        this.doResolveAll(inetHost, promise, this.resolveCache);
    }

    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise, DnsCache resolveCache) throws Exception {
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString(inetHost);
        if (bytes != null) {
            promise.setSuccess(Collections.singletonList(InetAddress.getByAddress(bytes)));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess(Collections.singletonList(hostsFileEntry));
            return;
        }
        if (!this.doResolveAllCached(hostname, promise, resolveCache)) {
            this.doResolveAllUncached(hostname, promise, resolveCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveAllCached(String hostname, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        List<DnsCacheEntry> cachedEntries = resolveCache.get(hostname);
        if (cachedEntries == null) {
            return false;
        }
        ArrayList<InetAddress> result = null;
        Throwable cause = null;
        List<DnsCacheEntry> list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (cachedEntries.get(0).cause() != null) {
                cause = cachedEntries.get(0).cause();
            } else {
                for (InternetProtocolFamily f : this.resolvedAddressTypes) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        if (result == null) {
                            result = new ArrayList<InetAddress>(numEntries);
                        }
                        result.add(e.address());
                    }
                }
            }
        }
        if (result != null) {
            promise.trySuccess(result);
        } else if (cause != null) {
            promise.tryFailure(cause);
        } else {
            return false;
        }
        return true;
    }

    private void doResolveAllUncached(String hostname, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        DnsNameResolverContext<List<InetAddress>> ctx = new DnsNameResolverContext<List<InetAddress>>(this, hostname, promise, resolveCache){

            @Override
            protected boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries) {
                ArrayList<InetAddress> result = null;
                int numEntries = resolvedEntries.size();
                for (int i = 0; i < numEntries; ++i) {
                    InetAddress a = resolvedEntries.get(i).address();
                    if (!addressType.isInstance(a)) continue;
                    if (result == null) {
                        result = new ArrayList<InetAddress>(numEntries);
                    }
                    result.add(a);
                }
                if (result != null) {
                    this.promise().trySuccess(result);
                    return true;
                }
                return false;
            }
        };
        ctx.resolve();
    }

    private static String hostname(String inetHost) {
        return IDN.toASCII(inetHost);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Iterable<DnsRecord> additional) {
        return this.query(this.nextNameServerAddress(), question, additional);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), question, Collections.<DnsRecord>emptyList(), promise);
    }

    private InetSocketAddress nextNameServerAddress() {
        return this.nameServerAddrStream.get().next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query0(nameServerAddr, question, Collections.<DnsRecord>emptyList(), this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additional) {
        return this.query0(nameServerAddr, question, additional, this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, Collections.<DnsRecord>emptyList(), promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additional, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, additional, promise);
    }

    private Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additional, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(ObjectUtil.checkNotNull(promise, "promise"));
        try {
            new DnsQueryContext(this, nameServerAddr, question, additional, castPromise).query();
            return castPromise;
        }
        catch (Exception e) {
            return castPromise.setFailure(e);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    static {
        if (Boolean.getBoolean("java.net.preferIPv6Addresses")) {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv6;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv4;
            logger.debug("-Djava.net.preferIPv6Addresses: true");
        } else {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv4;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv6;
            logger.debug("-Djava.net.preferIPv6Addresses: false");
        }
        DECODER = new DatagramDnsResponseDecoder();
        ENCODER = new DatagramDnsQueryEncoder();
    }

    private final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private DnsResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                DnsQueryContext qCtx;
                DatagramDnsResponse res = (DatagramDnsResponse)msg;
                int queryId = res.id();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} RECEIVED: [{}: {}], {}", DnsNameResolver.this.ch, queryId, res.sender(), res);
                }
                if ((qCtx = DnsNameResolver.this.queryContextManager.get(res.sender(), queryId)) == null) {
                    logger.warn("{} Received a DNS response with an unknown ID: {}", (Object)DnsNameResolver.this.ch, (Object)queryId);
                    return;
                }
                qCtx.finish(res);
            }
            finally {
                ReferenceCountUtil.safeRelease(msg);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("{} Unexpected exception: ", (Object)DnsNameResolver.this.ch, (Object)cause);
        }
    }
}

