/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.io.netty.util.Constant;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.PlatformDependent;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.ThreadLocalRandom;

public abstract class AbstractConstant<T extends AbstractConstant<T>>
implements Constant<T> {
    private final int id;
    private final String name;
    private volatile long uniquifier;
    private ByteBuffer directBuffer;

    protected AbstractConstant(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final int id() {
        return this.id;
    }

    public final String toString() {
        return this.name();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public final int compareTo(T o) {
        long otherUV;
        if (this == o) {
            return 0;
        }
        T other = o;
        int returnCode = this.hashCode() - ((AbstractConstant)other).hashCode();
        if (returnCode != 0) {
            return returnCode;
        }
        long thisUV = this.uniquifier();
        if (thisUV < (otherUV = super.uniquifier())) {
            return -1;
        }
        if (thisUV > otherUV) {
            return 1;
        }
        throw new Error("failed to compare two different constants");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long uniquifier() {
        long uniquifier = this.uniquifier;
        if (uniquifier == 0L) {
            AbstractConstant abstractConstant = this;
            synchronized (abstractConstant) {
                while ((uniquifier = this.uniquifier) == 0L) {
                    if (PlatformDependent.hasUnsafe()) {
                        this.directBuffer = ByteBuffer.allocateDirect(1);
                        this.uniquifier = PlatformDependent.directBufferAddress(this.directBuffer);
                        continue;
                    }
                    this.directBuffer = null;
                    this.uniquifier = ThreadLocalRandom.current().nextLong();
                }
            }
        }
        return uniquifier;
    }
}

