/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.math.complex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.FieldElement;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.MathRuntimeException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.complex.ComplexField;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.util.FastMath;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Complex
implements FieldElement<Complex>,
Serializable {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    private static final long serialVersionUID = -6195664516687396620L;
    private final double imaginary;
    private final double real;
    private final transient boolean isNaN;
    private final transient boolean isInfinite;

    public Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
        this.isNaN = Double.isNaN(real) || Double.isNaN(imaginary);
        this.isInfinite = !this.isNaN && (Double.isInfinite(real) || Double.isInfinite(imaginary));
    }

    public double abs() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        if (FastMath.abs(this.real) < FastMath.abs(this.imaginary)) {
            if (this.imaginary == 0.0) {
                return FastMath.abs(this.real);
            }
            double q = this.real / this.imaginary;
            return FastMath.abs(this.imaginary) * FastMath.sqrt(1.0 + q * q);
        }
        if (this.real == 0.0) {
            return FastMath.abs(this.imaginary);
        }
        double q = this.imaginary / this.real;
        return FastMath.abs(this.real) * FastMath.sqrt(1.0 + q * q);
    }

    @Override
    public Complex add(Complex rhs) {
        return this.createComplex(this.real + rhs.getReal(), this.imaginary + rhs.getImaginary());
    }

    public Complex conjugate() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(this.real, -this.imaginary);
    }

    @Override
    public Complex divide(Complex rhs) {
        if (this.isNaN() || rhs.isNaN()) {
            return NaN;
        }
        double c = rhs.getReal();
        double d = rhs.getImaginary();
        if (c == 0.0 && d == 0.0) {
            return NaN;
        }
        if (rhs.isInfinite() && !this.isInfinite()) {
            return ZERO;
        }
        if (FastMath.abs(c) < FastMath.abs(d)) {
            double q = c / d;
            double denominator = c * q + d;
            return this.createComplex((this.real * q + this.imaginary) / denominator, (this.imaginary * q - this.real) / denominator);
        }
        double q = d / c;
        double denominator = d * q + c;
        return this.createComplex((this.imaginary * q + this.real) / denominator, (this.imaginary - this.real * q) / denominator);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Complex) {
            Complex rhs = (Complex)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return this.real == rhs.real && this.imaginary == rhs.imaginary;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 7;
        }
        return 37 * (17 * MathUtils.hash(this.imaginary) + MathUtils.hash(this.real));
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    @Override
    public Complex multiply(Complex rhs) {
        if (this.isNaN() || rhs.isNaN()) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(rhs.real) || Double.isInfinite(rhs.imaginary)) {
            return INF;
        }
        return this.createComplex(this.real * rhs.real - this.imaginary * rhs.imaginary, this.real * rhs.imaginary + this.imaginary * rhs.real);
    }

    @Override
    public Complex multiply(double rhs) {
        if (this.isNaN() || Double.isNaN(rhs)) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(rhs)) {
            return INF;
        }
        return this.createComplex(this.real * rhs, this.imaginary * rhs);
    }

    public Complex negate() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(-this.real, -this.imaginary);
    }

    @Override
    public Complex subtract(Complex rhs) {
        if (this.isNaN() || rhs.isNaN()) {
            return NaN;
        }
        return this.createComplex(this.real - rhs.getReal(), this.imaginary - rhs.getImaginary());
    }

    public Complex acos() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.add(this.sqrt1z().multiply(I)).log().multiply(I.negate());
    }

    public Complex asin() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.sqrt1z().add(this.multiply(I)).log().multiply(I.negate());
    }

    public Complex atan() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.add(I).divide(I.subtract(this)).log().multiply(I.divide(this.createComplex(2.0, 0.0)));
    }

    public Complex cos() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(FastMath.cos(this.real) * MathUtils.cosh(this.imaginary), -FastMath.sin(this.real) * MathUtils.sinh(this.imaginary));
    }

    public Complex cosh() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(MathUtils.cosh(this.real) * FastMath.cos(this.imaginary), MathUtils.sinh(this.real) * FastMath.sin(this.imaginary));
    }

    public Complex exp() {
        if (this.isNaN()) {
            return NaN;
        }
        double expReal = FastMath.exp(this.real);
        return this.createComplex(expReal * FastMath.cos(this.imaginary), expReal * FastMath.sin(this.imaginary));
    }

    public Complex log() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(FastMath.log(this.abs()), FastMath.atan2(this.imaginary, this.real));
    }

    public Complex pow(Complex x) {
        if (x == null) {
            throw new NullPointerException();
        }
        return this.log().multiply(x).exp();
    }

    public Complex sin() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(FastMath.sin(this.real) * MathUtils.cosh(this.imaginary), FastMath.cos(this.real) * MathUtils.sinh(this.imaginary));
    }

    public Complex sinh() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(MathUtils.sinh(this.real) * FastMath.cos(this.imaginary), MathUtils.cosh(this.real) * FastMath.sin(this.imaginary));
    }

    public Complex sqrt() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return this.createComplex(0.0, 0.0);
        }
        double t = FastMath.sqrt((FastMath.abs(this.real) + this.abs()) / 2.0);
        if (this.real >= 0.0) {
            return this.createComplex(t, this.imaginary / (2.0 * t));
        }
        return this.createComplex(FastMath.abs(this.imaginary) / (2.0 * t), MathUtils.indicator(this.imaginary) * t);
    }

    public Complex sqrt1z() {
        return this.createComplex(1.0, 0.0).subtract(this.multiply(this)).sqrt();
    }

    public Complex tan() {
        if (this.isNaN()) {
            return NaN;
        }
        double real2 = 2.0 * this.real;
        double imaginary2 = 2.0 * this.imaginary;
        double d = FastMath.cos(real2) + MathUtils.cosh(imaginary2);
        return this.createComplex(FastMath.sin(real2) / d, MathUtils.sinh(imaginary2) / d);
    }

    public Complex tanh() {
        if (this.isNaN()) {
            return NaN;
        }
        double real2 = 2.0 * this.real;
        double imaginary2 = 2.0 * this.imaginary;
        double d = MathUtils.cosh(real2) + FastMath.cos(imaginary2);
        return this.createComplex(MathUtils.sinh(real2) / d, FastMath.sin(imaginary2) / d);
    }

    public double getArgument() {
        return FastMath.atan2(this.getImaginary(), this.getReal());
    }

    public List<Complex> nthRoot(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N, n);
        }
        ArrayList<Complex> result = new ArrayList<Complex>();
        if (this.isNaN()) {
            result.add(NaN);
            return result;
        }
        if (this.isInfinite()) {
            result.add(INF);
            return result;
        }
        double nthRootOfAbs = FastMath.pow(this.abs(), 1.0 / (double)n);
        double nthPhi = this.getArgument() / (double)n;
        double slice = Math.PI * 2 / (double)n;
        double innerPart = nthPhi;
        for (int k = 0; k < n; ++k) {
            double realPart = nthRootOfAbs * FastMath.cos(innerPart);
            double imaginaryPart = nthRootOfAbs * FastMath.sin(innerPart);
            result.add(this.createComplex(realPart, imaginaryPart));
            innerPart += slice;
        }
        return result;
    }

    protected Complex createComplex(double realPart, double imaginaryPart) {
        return new Complex(realPart, imaginaryPart);
    }

    protected final Object readResolve() {
        return this.createComplex(this.real, this.imaginary);
    }

    public ComplexField getField() {
        return ComplexField.getInstance();
    }
}

