/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
public class RawFloat
implements DataType<Float> {
    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(Float val) {
        return 4;
    }

    @Override
    public Class<Float> encodedClass() {
        return Float.class;
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + 4);
        return 4;
    }

    @Override
    public Float decode(PositionedByteRange src) {
        float val = Bytes.toFloat(src.getBytes(), src.getOffset() + src.getPosition());
        this.skip(src);
        return Float.valueOf(val);
    }

    @Override
    public int encode(PositionedByteRange dst, Float val) {
        Bytes.putFloat(dst.getBytes(), dst.getOffset() + dst.getPosition(), val.floatValue());
        return this.skip(dst);
    }

    public float decodeFloat(byte[] buff, int offset) {
        return Bytes.toFloat(buff, offset);
    }

    public int encodeFloat(byte[] buff, int offset, float val) {
        return Bytes.putFloat(buff, offset, val);
    }
}

