/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.MurmurHash3;

@InterfaceAudience.Private
@InterfaceStability.Stable
public abstract class Hash {
    public static final int INVALID_HASH = -1;
    public static final int JENKINS_HASH = 0;
    public static final int MURMUR_HASH = 1;
    public static final int MURMUR_HASH3 = 2;

    public static int parseHashType(String name) {
        if ("jenkins".equalsIgnoreCase(name)) {
            return 0;
        }
        if ("murmur".equalsIgnoreCase(name)) {
            return 1;
        }
        if ("murmur3".equalsIgnoreCase(name)) {
            return 2;
        }
        return -1;
    }

    public static int getHashType(Configuration conf) {
        String name = conf.get("hbase.hash.type", "murmur");
        return Hash.parseHashType(name);
    }

    public static Hash getInstance(int type) {
        switch (type) {
            case 0: {
                return JenkinsHash.getInstance();
            }
            case 1: {
                return MurmurHash.getInstance();
            }
            case 2: {
                return MurmurHash3.getInstance();
            }
        }
        return null;
    }

    public static Hash getInstance(Configuration conf) {
        int type = Hash.getHashType(conf);
        return Hash.getInstance(type);
    }

    public abstract <T> int hash(HashKey<T> var1, int var2);
}

