/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueACL;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class QueueConfigurationParser {
    private static final Log LOG = LogFactory.getLog(QueueConfigurationParser.class);
    private boolean aclsEnabled = false;
    protected Queue root = null;
    static final String NAME_SEPARATOR = ":";
    static final String QUEUE_TAG = "queue";
    static final String ACL_SUBMIT_JOB_TAG = "acl-submit-job";
    static final String ACL_ADMINISTER_JOB_TAG = "acl-administer-jobs";
    @Deprecated
    static final String ACLS_ENABLED_TAG = "aclsEnabled";
    static final String PROPERTIES_TAG = "properties";
    static final String STATE_TAG = "state";
    static final String QUEUE_NAME_TAG = "name";
    static final String QUEUES_TAG = "queues";
    static final String PROPERTY_TAG = "property";
    static final String KEY_TAG = "key";
    static final String VALUE_TAG = "value";

    QueueConfigurationParser() {
    }

    QueueConfigurationParser(String confFile, boolean areAclsEnabled) {
        this.aclsEnabled = areAclsEnabled;
        File file = new File(confFile).getAbsoluteFile();
        if (!file.exists()) {
            throw new RuntimeException("Configuration file not found at " + confFile);
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.loadFrom(in);
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
        }
        IOUtils.closeStream(in);
    }

    QueueConfigurationParser(InputStream xmlInput, boolean areAclsEnabled) {
        this.aclsEnabled = areAclsEnabled;
        this.loadFrom(xmlInput);
    }

    private void loadFrom(InputStream xmlInput) {
        try {
            this.root = this.loadResource(xmlInput);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void setAclsEnabled(boolean aclsEnabled) {
        this.aclsEnabled = aclsEnabled;
    }

    boolean isAclsEnabled() {
        return this.aclsEnabled;
    }

    Queue getRoot() {
        return this.root;
    }

    void setRoot(Queue root) {
        this.root = root;
    }

    protected Queue loadResource(InputStream resourceInput) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setNamespaceAware(true);
        try {
            docBuilderFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            LOG.info((Object)("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + NAME_SEPARATOR + e));
        }
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = null;
        Element queuesNode = null;
        doc = builder.parse(resourceInput);
        queuesNode = doc.getDocumentElement();
        return this.parseResource(queuesNode);
    }

    private Queue parseResource(Element queuesNode) {
        Queue rootNode = null;
        try {
            NodeList props;
            if (!QUEUES_TAG.equals(queuesNode.getTagName())) {
                LOG.info((Object)"Bad conf file: top-level element not <queues>");
                throw new RuntimeException("No queues defined ");
            }
            NamedNodeMap nmp = queuesNode.getAttributes();
            Node acls = nmp.getNamedItem(ACLS_ENABLED_TAG);
            if (acls != null) {
                LOG.warn((Object)"Configuring aclsEnabled flag in mapred-queues.xml is not valid. This tag is ignored. Configure mapreduce.cluster.acls.enabled in mapred-site.xml. See the  documentation of mapreduce.cluster.acls.enabled, which is used for enabling job level authorization and  queue level authorization.");
            }
            if ((props = queuesNode.getChildNodes()) == null || props.getLength() <= 0) {
                LOG.info((Object)" Bad configuration no queues defined ");
                throw new RuntimeException(" No queues defined ");
            }
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                if (!propNode.getNodeName().equals(QUEUE_TAG)) {
                    LOG.info((Object)"At root level only \" queue \" tags are allowed ");
                    throw new RuntimeException("Malformed xml document no queue defined ");
                }
                Element prop = (Element)propNode;
                Queue q = this.createHierarchy("", prop);
                if (rootNode == null) {
                    rootNode = new Queue();
                    rootNode.setName("");
                }
                rootNode.addChild(q);
            }
            return rootNode;
        }
        catch (DOMException e) {
            LOG.info((Object)("Error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
    }

    private Queue createHierarchy(String parent, Element queueNode) {
        if (queueNode == null) {
            return null;
        }
        String name = "";
        Queue newQueue = new Queue();
        HashMap<String, AccessControlList> acls = new HashMap<String, AccessControlList>();
        NodeList fields = queueNode.getChildNodes();
        this.validate(queueNode);
        ArrayList<Element> subQueues = new ArrayList<Element>();
        String submitKey = "";
        String adminKey = "";
        for (int j = 0; j < fields.getLength(); ++j) {
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if (QUEUE_NAME_TAG.equals(field.getTagName())) {
                String nameValue = field.getTextContent();
                if (field.getTextContent() == null || field.getTextContent().trim().equals("") || field.getTextContent().contains(NAME_SEPARATOR)) {
                    throw new RuntimeException("Improper queue name : " + nameValue);
                }
                if (!parent.equals("")) {
                    name = name + parent + NAME_SEPARATOR;
                }
                name = name + nameValue;
                newQueue.setName(name);
                submitKey = QueueManager.toFullPropertyName(name, QueueACL.SUBMIT_JOB.getAclName());
                adminKey = QueueManager.toFullPropertyName(name, QueueACL.ADMINISTER_JOBS.getAclName());
            }
            if (QUEUE_TAG.equals(field.getTagName()) && field.hasChildNodes()) {
                subQueues.add(field);
            }
            if (this.isAclsEnabled()) {
                if (ACL_SUBMIT_JOB_TAG.equals(field.getTagName())) {
                    acls.put(submitKey, new AccessControlList(field.getTextContent()));
                }
                if (ACL_ADMINISTER_JOB_TAG.equals(field.getTagName())) {
                    acls.put(adminKey, new AccessControlList(field.getTextContent()));
                }
            }
            if (PROPERTIES_TAG.equals(field.getTagName())) {
                Properties properties = this.populateProperties(field);
                newQueue.setProperties(properties);
            }
            if (!STATE_TAG.equals(field.getTagName())) continue;
            String state = field.getTextContent();
            newQueue.setState(QueueState.getState(state));
        }
        if (!acls.containsKey(submitKey)) {
            acls.put(submitKey, new AccessControlList(" "));
        }
        if (!acls.containsKey(adminKey)) {
            acls.put(adminKey, new AccessControlList(" "));
        }
        newQueue.setAcls(acls);
        for (Element field : subQueues) {
            newQueue.addChild(this.createHierarchy(newQueue.getName(), field));
        }
        return newQueue;
    }

    private Properties populateProperties(Element field) {
        Properties props = new Properties();
        NodeList propfields = field.getChildNodes();
        for (int i = 0; i < propfields.getLength(); ++i) {
            NamedNodeMap nmp;
            Node prop = propfields.item(i);
            if (!(prop instanceof Element) || !PROPERTY_TAG.equals(prop.getNodeName()) || !prop.hasAttributes() || (nmp = prop.getAttributes()).getNamedItem(KEY_TAG) == null || nmp.getNamedItem(VALUE_TAG) == null) continue;
            props.setProperty(nmp.getNamedItem(KEY_TAG).getTextContent(), nmp.getNamedItem(VALUE_TAG).getTextContent());
        }
        return props;
    }

    private void validate(Node node) {
        NodeList fields = node.getChildNodes();
        HashSet<String> siblings = new HashSet<String>();
        for (int i = 0; i < fields.getLength(); ++i) {
            if (!(fields.item(i) instanceof Element)) continue;
            siblings.add(fields.item(i).getNodeName());
        }
        if (!siblings.contains(QUEUE_NAME_TAG)) {
            throw new RuntimeException(" Malformed xml formation queue name not specified ");
        }
        if (siblings.contains(QUEUE_TAG) && (siblings.contains(ACL_ADMINISTER_JOB_TAG) || siblings.contains(ACL_SUBMIT_JOB_TAG) || siblings.contains(STATE_TAG))) {
            throw new RuntimeException(" Malformed xml formation queue tag and acls tags or state tags are siblings ");
        }
    }

    private static String getSimpleQueueName(String fullQName) {
        int index = fullQName.lastIndexOf(NAME_SEPARATOR);
        if (index < 0) {
            return fullQName;
        }
        return fullQName.substring(index + 1, fullQName.length());
    }

    static Element getQueueElement(Document document, JobQueueInfo jqi) {
        List<JobQueueInfo> children;
        Element q = document.createElement(QUEUE_TAG);
        Element qName = document.createElement(QUEUE_NAME_TAG);
        qName.setTextContent(QueueConfigurationParser.getSimpleQueueName(jqi.getQueueName()));
        q.appendChild(qName);
        Properties props = jqi.getProperties();
        Element propsElement = document.createElement(PROPERTIES_TAG);
        if (props != null) {
            Set<String> propList = props.stringPropertyNames();
            for (String prop : propList) {
                Element propertyElement = document.createElement(PROPERTY_TAG);
                propertyElement.setAttribute(KEY_TAG, prop);
                propertyElement.setAttribute(VALUE_TAG, (String)props.get(prop));
                propsElement.appendChild(propertyElement);
            }
        }
        q.appendChild(propsElement);
        String queueState = jqi.getState().getStateName();
        if (queueState != null && !queueState.equals(QueueState.UNDEFINED.getStateName())) {
            Element qStateElement = document.createElement(STATE_TAG);
            qStateElement.setTextContent(queueState);
            q.appendChild(qStateElement);
        }
        if ((children = jqi.getChildren()) != null) {
            for (JobQueueInfo child : children) {
                q.appendChild(QueueConfigurationParser.getQueueElement(document, child));
            }
        }
        return q;
    }
}

