/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class HBaseConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseConfiguration.class);

    @Deprecated
    public HBaseConfiguration() {
        HBaseConfiguration.addHbaseResources(this);
        LOG.warn("instantiating HBaseConfiguration() is deprecated. Please use HBaseConfiguration#create() to construct a plain Configuration");
    }

    @Deprecated
    public HBaseConfiguration(Configuration c) {
        this();
        HBaseConfiguration.merge(this, c);
    }

    private static void checkDefaultsVersion(Configuration conf) {
        if (conf.getBoolean("hbase.defaults.for.version.skip", Boolean.FALSE)) {
            return;
        }
        String defaultsVersion = conf.get("hbase.defaults.for.version");
        String thisVersion = VersionInfo.getVersion();
        if (!thisVersion.equals(defaultsVersion)) {
            throw new RuntimeException("hbase-default.xml file seems to be for an older version of HBase (" + defaultsVersion + "), this version is " + thisVersion);
        }
    }

    public static Configuration addHbaseResources(Configuration conf) {
        conf.addResource("hbase-default.xml");
        conf.addResource("hbase-site.xml");
        HBaseConfiguration.checkDefaultsVersion(conf);
        return conf;
    }

    public static Configuration create() {
        Configuration conf = new Configuration();
        conf.setClassLoader(HBaseConfiguration.class.getClassLoader());
        return HBaseConfiguration.addHbaseResources(conf);
    }

    public static Configuration create(Configuration that) {
        Configuration conf = HBaseConfiguration.create();
        HBaseConfiguration.merge(conf, that);
        return conf;
    }

    public static void merge(Configuration destConf, Configuration srcConf) {
        for (Map.Entry<String, String> e : srcConf) {
            destConf.set(e.getKey(), e.getValue());
        }
    }

    public static Configuration subset(Configuration srcConf, String prefix) {
        Configuration newConf = new Configuration(false);
        for (Map.Entry<String, String> entry : srcConf) {
            String newKey;
            if (!entry.getKey().startsWith(prefix) || (newKey = entry.getKey().substring(prefix.length())).isEmpty()) continue;
            newConf.set(newKey, entry.getValue());
        }
        return newConf;
    }

    public static void setWithPrefix(Configuration conf, String prefix, Iterable<Map.Entry<String, String>> properties) {
        for (Map.Entry<String, String> entry : properties) {
            conf.set(prefix + entry.getKey(), entry.getValue());
        }
    }

    public static boolean isShowConfInServlet() {
        boolean isShowConf = false;
        try {
            if (Class.forName("org.apache.hadoop.conf.ConfServlet") != null) {
                isShowConf = true;
            }
        }
        catch (LinkageError e) {
            LOG.warn("Error thrown: ", (Throwable)e);
        }
        catch (ClassNotFoundException ce) {
            LOG.debug("ClassNotFound: ConfServlet");
        }
        return isShowConf;
    }

    public static int getInt(Configuration conf, String name, String deprecatedName, int defaultValue) {
        if (conf.get(deprecatedName) != null) {
            LOG.warn(String.format("Config option \"%s\" is deprecated. Instead, use \"%s\"", deprecatedName, name));
            return conf.getInt(deprecatedName, defaultValue);
        }
        return conf.getInt(name, defaultValue);
    }

    public static String getPassword(Configuration conf, String alias, String defPass) throws IOException {
        String passwd = null;
        try {
            Method m = Configuration.class.getMethod("getPassword", String.class);
            char[] p = (char[])m.invoke((Object)conf, alias);
            if (p != null) {
                LOG.debug(String.format("Config option \"%s\" was found through the Configuration getPassword method.", alias));
                passwd = new String(p);
            } else {
                LOG.debug(String.format("Config option \"%s\" was not found. Using provided default value", alias));
                passwd = defPass;
            }
        }
        catch (NoSuchMethodException e) {
            LOG.debug(String.format("Credential.getPassword method is not available. Falling back to configuration.", new Object[0]));
            passwd = conf.get(alias, defPass);
        }
        catch (SecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e.getMessage(), e);
        }
        return passwd;
    }

    public static Configuration createClusterConf(Configuration baseConf, String clusterKey) throws IOException {
        return HBaseConfiguration.createClusterConf(baseConf, clusterKey, null);
    }

    public static Configuration createClusterConf(Configuration baseConf, String clusterKey, String overridePrefix) throws IOException {
        Configuration clusterConf = HBaseConfiguration.create(baseConf);
        if (clusterKey != null && !clusterKey.isEmpty()) {
            HBaseConfiguration.applyClusterKeyToConf(clusterConf, clusterKey);
        }
        if (overridePrefix != null && !overridePrefix.isEmpty()) {
            Configuration clusterSubset = HBaseConfiguration.subset(clusterConf, overridePrefix);
            HBaseConfiguration.merge(clusterConf, clusterSubset);
        }
        return clusterConf;
    }

    private static void applyClusterKeyToConf(Configuration conf, String key) throws IOException {
        ZKConfig.ZKClusterKey zkClusterKey = ZKConfig.transformClusterKey(key);
        conf.set("hbase.zookeeper.quorum", zkClusterKey.getQuorumString());
        conf.setInt("hbase.zookeeper.property.clientPort", zkClusterKey.getClientPort());
        conf.set("zookeeper.znode.parent", zkClusterKey.getZnodeParent());
    }

    public static void main(String[] args) throws Exception {
        HBaseConfiguration.create().writeXml(System.out);
    }
}

