/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.primitives.Longs;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"UNKNOWN"}, justification="Findbugs doesn't like the way we are negating the result of a compare in below")
public class CellComparatorImpl
implements CellComparator {
    static final Logger LOG = LoggerFactory.getLogger(CellComparatorImpl.class);
    public static final CellComparatorImpl COMPARATOR = new CellComparatorImpl();
    public static final CellComparatorImpl META_COMPARATOR = new MetaCellComparator();

    @Override
    public int compare(Cell a, Cell b) {
        return this.compare(a, b, false);
    }

    public final int compare(Cell a, Cell b, boolean ignoreSequenceid) {
        int c = this.compareRows(a, b);
        if (c != 0) {
            return c;
        }
        c = this.compareWithoutRow(a, b);
        if (c != 0) {
            return c;
        }
        if (!ignoreSequenceid) {
            return Longs.compare(b.getSequenceId(), a.getSequenceId());
        }
        return c;
    }

    public final int compareColumns(Cell left, Cell right) {
        int diff = this.compareFamilies(left, right);
        if (diff != 0) {
            return diff;
        }
        return this.compareQualifiers(left, right);
    }

    @Override
    public final int compareFamilies(Cell left, Cell right) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)right.getFamilyLength());
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), (int)right.getFamilyLength());
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getFamilyArray(), left.getFamilyOffset(), (int)left.getFamilyLength(), ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)right.getFamilyLength());
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
    }

    @Override
    public final int compareQualifiers(Cell left, Cell right) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), right.getQualifierLength());
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), right.getQualifierLength());
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
    }

    @Override
    public int compareRows(Cell left, Cell right) {
        if (left == right) {
            return 0;
        }
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)left.getRowLength(), ((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), (int)right.getRowLength());
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)left.getRowLength(), right.getRowArray(), right.getRowOffset(), (int)right.getRowLength());
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getRowArray(), left.getRowOffset(), (int)left.getRowLength(), ((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), (int)right.getRowLength());
        }
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    @Override
    public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)left.getRowLength(), right, roffset, rlength);
        }
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
    }

    @Override
    public final int compareWithoutRow(Cell left, Cell right) {
        byte lFamLength = left.getFamilyLength();
        byte rFamLength = right.getFamilyLength();
        int lQualLength = left.getQualifierLength();
        int rQualLength = right.getQualifierLength();
        if (lFamLength + lQualLength == 0 && left.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (rFamLength + rQualLength == 0 && right.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        if (lFamLength != rFamLength) {
            return this.compareFamilies(left, right);
        }
        int diff = this.compareColumns(left, right);
        if (diff != 0) {
            return diff;
        }
        diff = this.compareTimestamps(left, right);
        if (diff != 0) {
            return diff;
        }
        return (0xFF & right.getTypeByte()) - (0xFF & left.getTypeByte());
    }

    @Override
    public int compareTimestamps(Cell left, Cell right) {
        return this.compareTimestamps(left.getTimestamp(), right.getTimestamp());
    }

    @Override
    public int compareTimestamps(long ltimestamp, long rtimestamp) {
        if (ltimestamp < rtimestamp) {
            return 1;
        }
        if (ltimestamp > rtimestamp) {
            return -1;
        }
        return 0;
    }

    public static class MetaCellComparator
    extends CellComparatorImpl {
        @Override
        public int compareRows(Cell left, Cell right) {
            return this.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
        }

        @Override
        public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
            return this.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
        }

        private int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            int rightFarDelimiter;
            int leftFarDelimiter;
            int rightDelimiter;
            int rpart;
            int leftDelimiter = Bytes.searchDelimiterIndex(left, loffset, llength, 44);
            int lpart = leftDelimiter < 0 ? llength : leftDelimiter - loffset;
            int result = Bytes.compareTo(left, loffset, lpart, right, roffset, rpart = (rightDelimiter = Bytes.searchDelimiterIndex(right, roffset, rlength, 44)) < 0 ? rlength : rightDelimiter - roffset);
            if (result != 0) {
                return result;
            }
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            if ((result = Bytes.compareTo(left, leftDelimiter, lpart = ((leftFarDelimiter = Bytes.searchDelimiterIndexInReverse(left, ++leftDelimiter, llength - (leftDelimiter - loffset), 44)) < 0 ? llength + loffset : leftFarDelimiter) - leftDelimiter, right, rightDelimiter, rpart = ((rightFarDelimiter = Bytes.searchDelimiterIndexInReverse(right, ++rightDelimiter, rlength - (rightDelimiter - roffset), 44)) < 0 ? rlength + roffset : rightFarDelimiter) - rightDelimiter)) != 0) {
                return result;
            }
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            result = Bytes.compareTo(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
            return result;
        }
    }
}

