/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RawCell;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.RawComparator;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyValue
implements ExtendedCell {
    private static final ArrayList<Tag> EMPTY_ARRAY_LIST = new ArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(KeyValue.class);
    public static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 8 + 8;
    public static final char COLUMN_FAMILY_DELIMITER = ':';
    public static final byte[] COLUMN_FAMILY_DELIM_ARRAY = new byte[]{58};
    @Deprecated
    public static final KVComparator COMPARATOR = new KVComparator();
    @Deprecated
    public static final KVComparator META_COMPARATOR = new MetaComparator();
    public static final int KEY_LENGTH_SIZE = 4;
    public static final int TYPE_SIZE = 1;
    public static final int ROW_LENGTH_SIZE = 2;
    public static final int FAMILY_LENGTH_SIZE = 1;
    public static final int TIMESTAMP_SIZE = 8;
    public static final int TIMESTAMP_TYPE_SIZE = 9;
    public static final int KEY_INFRASTRUCTURE_SIZE = 12;
    public static final int ROW_OFFSET = 8;
    public static final int ROW_KEY_OFFSET = 10;
    public static final int KEYVALUE_INFRASTRUCTURE_SIZE = 8;
    public static final int TAGS_LENGTH_SIZE = 2;
    public static final int KEYVALUE_WITH_TAGS_INFRASTRUCTURE_SIZE = 10;
    public static final KeyValue LOWESTKEY = new KeyValue(HConstants.EMPTY_BYTE_ARRAY, Long.MAX_VALUE);
    protected byte[] bytes = null;
    protected int offset = 0;
    protected int length = 0;
    private long seqId = 0L;

    public static long getKeyValueDataStructureSize(int rlength, int flength, int qlength, int vlength) {
        return 8L + KeyValue.getKeyDataStructureSize(rlength, flength, qlength) + (long)vlength;
    }

    public static long getKeyValueDataStructureSize(int rlength, int flength, int qlength, int vlength, int tagsLength) {
        if (tagsLength == 0) {
            return KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, vlength);
        }
        return 10L + KeyValue.getKeyDataStructureSize(rlength, flength, qlength) + (long)vlength + (long)tagsLength;
    }

    public static long getKeyValueDataStructureSize(int klength, int vlength, int tagsLength) {
        if (tagsLength == 0) {
            return 8L + (long)klength + (long)vlength;
        }
        return 10L + (long)klength + (long)vlength + (long)tagsLength;
    }

    public static long getKeyDataStructureSize(int rlength, int flength, int qlength) {
        return 12L + (long)rlength + (long)flength + (long)qlength;
    }

    @Override
    public long getSequenceId() {
        return this.seqId;
    }

    @Override
    public void setSequenceId(long seqId) {
        this.seqId = seqId;
    }

    public KeyValue() {
    }

    public KeyValue(byte[] bytes) {
        this(bytes, 0);
    }

    public KeyValue(byte[] bytes, int offset) {
        this(bytes, offset, KeyValue.getLength(bytes, offset));
    }

    public KeyValue(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public KeyValue(byte[] bytes, int offset, int length, long ts) {
        this(bytes, offset, length, null, 0, 0, null, 0, 0, ts, Type.Maximum, null, 0, 0, null);
    }

    public KeyValue(byte[] row, long timestamp) {
        this(row, null, null, timestamp, Type.Maximum, null);
    }

    public KeyValue(byte[] row, long timestamp, Type type) {
        this(row, null, null, timestamp, type, null);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier) {
        this(row, family, qualifier, Long.MAX_VALUE, Type.Maximum);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, byte[] value) {
        this(row, family, qualifier, Long.MAX_VALUE, Type.Put, value);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, Type type) {
        this(row, family, qualifier, timestamp, type, null);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        this(row, family, qualifier, timestamp, Type.Put, value);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value, Tag[] tags) {
        this(row, family, qualifier, timestamp, value, tags != null ? Arrays.asList(tags) : null);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value, List<Tag> tags) {
        this(row, 0, row == null ? 0 : row.length, family, 0, family == null ? 0 : family.length, qualifier, 0, qualifier == null ? 0 : qualifier.length, timestamp, Type.Put, value, 0, value == null ? 0 : value.length, tags);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, Type type, byte[] value) {
        this(row, 0, Bytes.len(row), family, 0, Bytes.len(family), qualifier, 0, Bytes.len(qualifier), timestamp, type, value, 0, Bytes.len(value));
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, Type type, byte[] value, List<Tag> tags) {
        this(row, family, qualifier, 0, qualifier == null ? 0 : qualifier.length, timestamp, type, value, 0, value == null ? 0 : value.length, tags);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, Type type, byte[] value, byte[] tags) {
        this(row, family, qualifier, 0, qualifier == null ? 0 : qualifier.length, timestamp, type, value, 0, value == null ? 0 : value.length, tags);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, List<Tag> tags) {
        this(row, 0, row == null ? 0 : row.length, family, 0, family == null ? 0 : family.length, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength, tags);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, byte[] tags) {
        this(row, 0, row == null ? 0 : row.length, family, 0, family == null ? 0 : family.length, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength, tags, 0, tags == null ? 0 : tags.length);
    }

    public KeyValue(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength) {
        this(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength, null);
    }

    public KeyValue(byte[] buffer, int boffset, byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, Tag[] tags) {
        this.bytes = buffer;
        this.length = KeyValue.writeByteArray(buffer, boffset, row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength, tags);
        this.offset = boffset;
    }

    public KeyValue(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, List<Tag> tags) {
        this.bytes = KeyValue.createByteArray(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength, tags);
        this.length = this.bytes.length;
        this.offset = 0;
    }

    public KeyValue(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, byte[] tags, int tagsOffset, int tagsLength) {
        this.bytes = KeyValue.createByteArray(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength, tags, tagsOffset, tagsLength);
        this.length = this.bytes.length;
        this.offset = 0;
    }

    public KeyValue(int rlength, int flength, int qlength, long timestamp, Type type, int vlength) {
        this(rlength, flength, qlength, timestamp, type, vlength, 0);
    }

    public KeyValue(int rlength, int flength, int qlength, long timestamp, Type type, int vlength, int tagsLength) {
        this.bytes = KeyValue.createEmptyByteArray(rlength, flength, qlength, timestamp, type, vlength, tagsLength);
        this.length = this.bytes.length;
        this.offset = 0;
    }

    public KeyValue(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, ByteBuffer qualifier, long ts, Type type, ByteBuffer value, List<Tag> tags) {
        this.bytes = KeyValue.createByteArray(row, roffset, rlength, family, foffset, flength, qualifier, 0, qualifier == null ? 0 : qualifier.remaining(), ts, type, value, 0, value == null ? 0 : value.remaining(), tags);
        this.length = this.bytes.length;
        this.offset = 0;
    }

    public KeyValue(Cell c) {
        this(c.getRowArray(), c.getRowOffset(), c.getRowLength(), c.getFamilyArray(), c.getFamilyOffset(), c.getFamilyLength(), c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength(), c.getTimestamp(), Type.codeToType(c.getTypeByte()), c.getValueArray(), c.getValueOffset(), c.getValueLength(), c.getTagsArray(), c.getTagsOffset(), c.getTagsLength());
        this.seqId = c.getSequenceId();
    }

    private static byte[] createEmptyByteArray(int rlength, int flength, int qlength, long timestamp, Type type, int vlength, int tagsLength) {
        if (rlength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row > 32767");
        }
        if (flength > 127) {
            throw new IllegalArgumentException("Family > 127");
        }
        if (qlength > Integer.MAX_VALUE - rlength - flength) {
            throw new IllegalArgumentException("Qualifier > 2147483647");
        }
        RawCell.checkForTagsLength(tagsLength);
        long longkeylength = KeyValue.getKeyDataStructureSize(rlength, flength, qlength);
        if (longkeylength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("keylength " + longkeylength + " > " + Integer.MAX_VALUE);
        }
        int keylength = (int)longkeylength;
        if (vlength > 0x7FFFFFFE) {
            throw new IllegalArgumentException("Valuer > 2147483646");
        }
        byte[] bytes = new byte[(int)KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, vlength, tagsLength)];
        int pos = 0;
        pos = Bytes.putInt(bytes, pos, keylength);
        pos = Bytes.putInt(bytes, pos, vlength);
        pos = Bytes.putShort(bytes, pos, (short)(rlength & 0xFFFF));
        pos += rlength;
        pos = Bytes.putByte(bytes, pos, (byte)(flength & 0xFF));
        pos += flength + qlength;
        pos = Bytes.putLong(bytes, pos, timestamp);
        pos = Bytes.putByte(bytes, pos, type.getCode());
        pos += vlength;
        if (tagsLength > 0) {
            pos = Bytes.putAsShort(bytes, pos, tagsLength);
        }
        return bytes;
    }

    static void checkParameters(byte[] row, int rlength, byte[] family, int flength, int qlength, int vlength) throws IllegalArgumentException {
        if (rlength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row > 32767");
        }
        if (row == null) {
            throw new IllegalArgumentException("Row is null");
        }
        int n = flength = family == null ? 0 : flength;
        if (flength > 127) {
            throw new IllegalArgumentException("Family > 127");
        }
        if (qlength > Integer.MAX_VALUE - rlength - flength) {
            throw new IllegalArgumentException("Qualifier > 2147483647");
        }
        long longKeyLength = KeyValue.getKeyDataStructureSize(rlength, flength, qlength);
        if (longKeyLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("keylength " + longKeyLength + " > " + Integer.MAX_VALUE);
        }
        if (vlength > 0x7FFFFFFE) {
            throw new IllegalArgumentException("Value length " + vlength + " > " + 0x7FFFFFFE);
        }
    }

    public static int writeByteArray(byte[] buffer, int boffset, byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, Tag[] tags) {
        KeyValue.checkParameters(row, rlength, family, flength, qlength, vlength);
        int tagsLength = 0;
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                tagsLength += t.getValueLength() + 3;
            }
        }
        RawCell.checkForTagsLength(tagsLength);
        int keyLength = (int)KeyValue.getKeyDataStructureSize(rlength, flength, qlength);
        int keyValueLength = (int)KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, vlength, tagsLength);
        if (keyValueLength > buffer.length - boffset) {
            throw new IllegalArgumentException("Buffer size " + (buffer.length - boffset) + " < " + keyValueLength);
        }
        int pos = boffset;
        pos = Bytes.putInt(buffer, pos, keyLength);
        pos = Bytes.putInt(buffer, pos, vlength);
        pos = Bytes.putShort(buffer, pos, (short)(rlength & 0xFFFF));
        pos = Bytes.putBytes(buffer, pos, row, roffset, rlength);
        pos = Bytes.putByte(buffer, pos, (byte)(flength & 0xFF));
        if (flength != 0) {
            pos = Bytes.putBytes(buffer, pos, family, foffset, flength);
        }
        if (qlength != 0) {
            pos = Bytes.putBytes(buffer, pos, qualifier, qoffset, qlength);
        }
        pos = Bytes.putLong(buffer, pos, timestamp);
        pos = Bytes.putByte(buffer, pos, type.getCode());
        if (value != null && value.length > 0) {
            pos = Bytes.putBytes(buffer, pos, value, voffset, vlength);
        }
        if (tagsLength > 0) {
            pos = Bytes.putAsShort(buffer, pos, tagsLength);
            for (Tag t : tags) {
                int tlen = t.getValueLength();
                pos = Bytes.putAsShort(buffer, pos, tlen + 1);
                pos = Bytes.putByte(buffer, pos, t.getType());
                Tag.copyValueTo(t, buffer, pos);
                pos += tlen;
            }
        }
        return keyValueLength;
    }

    private static byte[] createByteArray(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength, byte[] tags, int tagsOffset, int tagsLength) {
        KeyValue.checkParameters(row, rlength, family, flength, qlength, vlength);
        RawCell.checkForTagsLength(tagsLength);
        int keyLength = (int)KeyValue.getKeyDataStructureSize(rlength, flength, qlength);
        byte[] bytes = new byte[(int)KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, vlength, tagsLength)];
        int pos = 0;
        pos = Bytes.putInt(bytes, pos, keyLength);
        pos = Bytes.putInt(bytes, pos, vlength);
        pos = Bytes.putShort(bytes, pos, (short)(rlength & 0xFFFF));
        pos = Bytes.putBytes(bytes, pos, row, roffset, rlength);
        pos = Bytes.putByte(bytes, pos, (byte)(flength & 0xFF));
        if (flength != 0) {
            pos = Bytes.putBytes(bytes, pos, family, foffset, flength);
        }
        if (qlength != 0) {
            pos = Bytes.putBytes(bytes, pos, qualifier, qoffset, qlength);
        }
        pos = Bytes.putLong(bytes, pos, timestamp);
        pos = Bytes.putByte(bytes, pos, type.getCode());
        if (value != null && value.length > 0) {
            pos = Bytes.putBytes(bytes, pos, value, voffset, vlength);
        }
        if (tagsLength > 0) {
            pos = Bytes.putAsShort(bytes, pos, tagsLength);
            pos = Bytes.putBytes(bytes, pos, tags, tagsOffset, tagsLength);
        }
        return bytes;
    }

    private static byte[] createByteArray(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, Object qualifier, int qoffset, int qlength, long timestamp, Type type, Object value, int voffset, int vlength, List<Tag> tags) {
        KeyValue.checkParameters(row, rlength, family, flength, qlength, vlength);
        int tagsLength = 0;
        if (tags != null && !tags.isEmpty()) {
            for (Tag t : tags) {
                tagsLength += t.getValueLength() + 3;
            }
        }
        RawCell.checkForTagsLength(tagsLength);
        int keyLength = (int)KeyValue.getKeyDataStructureSize(rlength, flength, qlength);
        byte[] bytes = new byte[(int)KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, vlength, tagsLength)];
        int pos = 0;
        pos = Bytes.putInt(bytes, pos, keyLength);
        pos = Bytes.putInt(bytes, pos, vlength);
        pos = Bytes.putShort(bytes, pos, (short)(rlength & 0xFFFF));
        pos = Bytes.putBytes(bytes, pos, row, roffset, rlength);
        pos = Bytes.putByte(bytes, pos, (byte)(flength & 0xFF));
        if (flength != 0) {
            pos = Bytes.putBytes(bytes, pos, family, foffset, flength);
        }
        if (qlength > 0) {
            pos = qualifier instanceof ByteBuffer ? Bytes.putByteBuffer(bytes, pos, (ByteBuffer)qualifier) : Bytes.putBytes(bytes, pos, (byte[])qualifier, qoffset, qlength);
        }
        pos = Bytes.putLong(bytes, pos, timestamp);
        pos = Bytes.putByte(bytes, pos, type.getCode());
        if (vlength > 0) {
            pos = value instanceof ByteBuffer ? Bytes.putByteBuffer(bytes, pos, (ByteBuffer)value) : Bytes.putBytes(bytes, pos, (byte[])value, voffset, vlength);
        }
        if (tagsLength > 0) {
            pos = Bytes.putAsShort(bytes, pos, tagsLength);
            for (Tag t : tags) {
                int tlen = t.getValueLength();
                pos = Bytes.putAsShort(bytes, pos, tlen + 1);
                pos = Bytes.putByte(bytes, pos, t.getType());
                Tag.copyValueTo(t, bytes, pos);
                pos += tlen;
            }
        }
        return bytes;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Cell)) {
            return false;
        }
        return CellUtil.equals(this, (Cell)other);
    }

    public int hashCode() {
        return this.calculateHashForKey(this);
    }

    private int calculateHashForKey(Cell cell) {
        int rowHash = Bytes.hashCode(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
        int familyHash = Bytes.hashCode(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
        int qualifierHash = Bytes.hashCode(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        int hash = 31 * rowHash + familyHash;
        hash = 31 * hash + qualifierHash;
        hash = 31 * hash + (int)cell.getTimestamp();
        hash = 31 * hash + cell.getTypeByte();
        return hash;
    }

    public KeyValue clone() throws CloneNotSupportedException {
        super.clone();
        byte[] b = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, b, 0, this.length);
        KeyValue ret = new KeyValue(b, 0, b.length);
        ret.setSequenceId(this.seqId);
        return ret;
    }

    public KeyValue shallowCopy() {
        KeyValue shallowCopy = new KeyValue(this.bytes, this.offset, this.length);
        shallowCopy.setSequenceId(this.seqId);
        return shallowCopy;
    }

    public String toString() {
        if (this.bytes == null || this.bytes.length == 0) {
            return "empty";
        }
        return KeyValue.keyToString(this.bytes, this.offset + 8, this.getKeyLength()) + "/vlen=" + this.getValueLength() + "/seqid=" + this.seqId;
    }

    public static String keyToString(byte[] k) {
        if (k == null) {
            return "";
        }
        return KeyValue.keyToString(k, 0, k.length);
    }

    public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("row", Bytes.toStringBinary(this.getRowArray(), this.getRowOffset(), this.getRowLength()));
        stringMap.put("family", Bytes.toStringBinary(this.getFamilyArray(), this.getFamilyOffset(), this.getFamilyLength()));
        stringMap.put("qualifier", Bytes.toStringBinary(this.getQualifierArray(), this.getQualifierOffset(), this.getQualifierLength()));
        stringMap.put("timestamp", this.getTimestamp());
        stringMap.put("vlen", this.getValueLength());
        Iterator<Tag> tags = this.getTags();
        if (tags != null) {
            ArrayList<String> tagsString = new ArrayList<String>();
            while (tags.hasNext()) {
                tagsString.add(tags.next().toString());
            }
            stringMap.put("tag", tagsString);
        }
        return stringMap;
    }

    public static String keyToString(byte[] b, int o, int l) {
        if (b == null) {
            return "";
        }
        short rowlength = Bytes.toShort(b, o);
        String row = Bytes.toStringBinary(b, o + 2, rowlength);
        int columnoffset = o + 2 + 1 + rowlength;
        byte familylength = b[columnoffset - 1];
        int columnlength = l - (columnoffset - o + 9);
        String family = familylength == 0 ? "" : Bytes.toStringBinary(b, columnoffset, familylength);
        String qualifier = columnlength == 0 ? "" : Bytes.toStringBinary(b, columnoffset + familylength, columnlength - familylength);
        long timestamp = Bytes.toLong(b, o + (l - 9));
        String timestampStr = KeyValue.humanReadableTimestamp(timestamp);
        byte type = b[o + l - 1];
        return row + "/" + family + (family != null && family.length() > 0 ? ":" : "") + qualifier + "/" + timestampStr + "/" + (Object)((Object)Type.codeToType(type));
    }

    public static String humanReadableTimestamp(long timestamp) {
        if (timestamp == Long.MAX_VALUE) {
            return "LATEST_TIMESTAMP";
        }
        if (timestamp == Long.MIN_VALUE) {
            return "OLDEST_TIMESTAMP";
        }
        return String.valueOf(timestamp);
    }

    @VisibleForTesting
    public byte[] getBuffer() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    private static int getLength(byte[] bytes, int offset) {
        int klength = 8 + Bytes.toInt(bytes, offset);
        int vlength = Bytes.toInt(bytes, offset + 4);
        return klength + vlength;
    }

    public int getKeyOffset() {
        return this.offset + 8;
    }

    public String getKeyString() {
        return Bytes.toStringBinary(this.getBuffer(), this.getKeyOffset(), this.getKeyLength());
    }

    public int getKeyLength() {
        return Bytes.toInt(this.bytes, this.offset);
    }

    @Override
    public byte[] getValueArray() {
        return this.bytes;
    }

    @Override
    public int getValueOffset() {
        int voffset = this.getKeyOffset() + this.getKeyLength();
        return voffset;
    }

    @Override
    public int getValueLength() {
        int vlength = Bytes.toInt(this.bytes, this.offset + 4);
        return vlength;
    }

    @Override
    public byte[] getRowArray() {
        return this.bytes;
    }

    @Override
    public int getRowOffset() {
        return this.offset + 10;
    }

    @Override
    public short getRowLength() {
        return Bytes.toShort(this.bytes, this.getKeyOffset());
    }

    @Override
    public byte[] getFamilyArray() {
        return this.bytes;
    }

    @Override
    public int getFamilyOffset() {
        return this.getFamilyOffset(this.getRowLength());
    }

    private int getFamilyOffset(int rlength) {
        return this.offset + 10 + rlength + 1;
    }

    @Override
    public byte getFamilyLength() {
        return this.getFamilyLength(this.getFamilyOffset());
    }

    public byte getFamilyLength(int foffset) {
        return this.bytes[foffset - 1];
    }

    @Override
    public byte[] getQualifierArray() {
        return this.bytes;
    }

    @Override
    public int getQualifierOffset() {
        return this.getQualifierOffset(this.getFamilyOffset());
    }

    private int getQualifierOffset(int foffset) {
        return foffset + this.getFamilyLength(foffset);
    }

    @Override
    public int getQualifierLength() {
        return this.getQualifierLength(this.getRowLength(), this.getFamilyLength());
    }

    private int getQualifierLength(int rlength, int flength) {
        return this.getKeyLength() - (int)KeyValue.getKeyDataStructureSize(rlength, flength, 0);
    }

    public int getTimestampOffset() {
        return this.getTimestampOffset(this.getKeyLength());
    }

    private int getTimestampOffset(int keylength) {
        return this.getKeyOffset() + keylength - 9;
    }

    public boolean isLatestTimestamp() {
        return Bytes.equals(this.getBuffer(), this.getTimestampOffset(), 8, HConstants.LATEST_TIMESTAMP_BYTES, 0, 8);
    }

    public boolean updateLatestStamp(byte[] now) {
        if (this.isLatestTimestamp()) {
            int tsOffset = this.getTimestampOffset();
            System.arraycopy(now, 0, this.bytes, tsOffset, 8);
            return true;
        }
        return false;
    }

    @Override
    public void setTimestamp(long ts) {
        Bytes.putBytes(this.bytes, this.getTimestampOffset(), Bytes.toBytes(ts), 0, 8);
    }

    @Override
    public void setTimestamp(byte[] ts) {
        Bytes.putBytes(this.bytes, this.getTimestampOffset(), ts, 0, 8);
    }

    public byte[] getKey() {
        int keylength = this.getKeyLength();
        byte[] key = new byte[keylength];
        System.arraycopy(this.getBuffer(), this.getKeyOffset(), key, 0, keylength);
        return key;
    }

    @Override
    public long getTimestamp() {
        return this.getTimestamp(this.getKeyLength());
    }

    long getTimestamp(int keylength) {
        int tsOffset = this.getTimestampOffset(keylength);
        return Bytes.toLong(this.bytes, tsOffset);
    }

    @Override
    public byte getTypeByte() {
        return this.bytes[this.offset + this.getKeyLength() - 1 + 8];
    }

    @Override
    public int getTagsOffset() {
        int tagsLen = this.getTagsLength();
        if (tagsLen == 0) {
            return this.offset + this.length;
        }
        return this.offset + this.length - tagsLen;
    }

    @Override
    public int getTagsLength() {
        int tagsLen = this.length - (this.getKeyLength() + this.getValueLength() + 8);
        if (tagsLen > 0) {
            tagsLen -= 2;
        }
        return tagsLen;
    }

    @Override
    public byte[] getTagsArray() {
        return this.bytes;
    }

    public KeyValue createKeyOnly(boolean lenAsVal) {
        int dataLen = lenAsVal ? 4 : 0;
        byte[] newBuffer = new byte[this.getKeyLength() + 8 + dataLen];
        System.arraycopy(this.bytes, this.offset, newBuffer, 0, Math.min(newBuffer.length, this.length));
        Bytes.putInt(newBuffer, 4, dataLen);
        if (lenAsVal) {
            Bytes.putInt(newBuffer, newBuffer.length - dataLen, this.getValueLength());
        }
        return new KeyValue(newBuffer);
    }

    public static int getDelimiter(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new IllegalArgumentException("Passed buffer is null");
        }
        int result = -1;
        for (int i = offset; i < length + offset; ++i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int getDelimiterInReverse(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new IllegalArgumentException("Passed buffer is null");
        }
        int result = -1;
        for (int i = offset + length - 1; i >= offset; --i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    public static KeyValue create(DataInput in) throws IOException {
        return KeyValue.create(in.readInt(), in);
    }

    public static KeyValue create(int length, DataInput in) throws IOException {
        if (length <= 0) {
            if (length == 0) {
                return null;
            }
            throw new IOException("Failed read " + length + " bytes, stream corrupt?");
        }
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new KeyValue(bytes, 0, length);
    }

    public static long write(KeyValue kv, DataOutput out) throws IOException {
        int length = kv.getLength();
        out.writeInt(length);
        out.write(kv.getBuffer(), kv.getOffset(), length);
        return (long)length + 4L;
    }

    @Deprecated
    public static long oswrite(KeyValue kv, OutputStream out, boolean withTags) throws IOException {
        ByteBufferUtils.putInt(out, kv.getSerializedSize(withTags));
        return (long)kv.write(out, withTags) + 4L;
    }

    @Override
    public int write(OutputStream out, boolean withTags) throws IOException {
        int len = this.getSerializedSize(withTags);
        out.write(this.bytes, this.offset, len);
        return len;
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        if (withTags) {
            return this.length;
        }
        return this.getKeyLength() + this.getValueLength() + 8;
    }

    @Override
    public void write(ByteBuffer buf, int offset) {
        ByteBufferUtils.copyFromArrayToBuffer(buf, offset, this.bytes, this.offset, this.length);
    }

    @Override
    public long heapSize() {
        return (long)ClassSize.align(FIXED_OVERHEAD) + (this.offset == 0 ? ClassSize.sizeOfByteArray(this.length) : (long)this.length);
    }

    @Override
    public ExtendedCell deepClone() {
        byte[] copy = Bytes.copy(this.bytes, this.offset, this.length);
        KeyValue kv = new KeyValue(copy, 0, copy.length);
        kv.setSequenceId(this.getSequenceId());
        return kv;
    }

    public static class KeyOnlyKeyValue
    extends KeyValue {
        private short rowLen = (short)-1;

        public KeyOnlyKeyValue() {
        }

        public KeyOnlyKeyValue(byte[] b) {
            this(b, 0, b.length);
        }

        public KeyOnlyKeyValue(byte[] b, int offset, int length) {
            this.bytes = b;
            this.length = length;
            this.offset = offset;
            this.rowLen = Bytes.toShort(this.bytes, this.offset);
        }

        public void set(KeyOnlyKeyValue keyOnlyKeyValue) {
            this.bytes = keyOnlyKeyValue.bytes;
            this.length = keyOnlyKeyValue.length;
            this.offset = keyOnlyKeyValue.offset;
            this.rowLen = keyOnlyKeyValue.rowLen;
        }

        public void clear() {
            this.rowLen = (short)-1;
            this.bytes = null;
            this.offset = 0;
            this.length = 0;
        }

        @Override
        public int getKeyOffset() {
            return this.offset;
        }

        public void setKey(byte[] key, int offset, int length) {
            this.bytes = key;
            this.offset = offset;
            this.length = length;
            this.rowLen = Bytes.toShort(this.bytes, this.offset);
        }

        @Override
        public byte[] getKey() {
            int keylength = this.getKeyLength();
            byte[] key = new byte[keylength];
            System.arraycopy(this.bytes, this.getKeyOffset(), key, 0, keylength);
            return key;
        }

        @Override
        public byte[] getRowArray() {
            return this.bytes;
        }

        @Override
        public int getRowOffset() {
            return this.getKeyOffset() + 2;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.bytes;
        }

        @Override
        public byte getFamilyLength() {
            return this.bytes[this.getFamilyOffset() - 1];
        }

        @Override
        public int getFamilyOffset() {
            return this.offset + 2 + this.getRowLength() + 1;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.bytes;
        }

        @Override
        public int getQualifierLength() {
            return this.getQualifierLength(this.getRowLength(), this.getFamilyLength());
        }

        @Override
        public int getQualifierOffset() {
            return this.getFamilyOffset() + this.getFamilyLength();
        }

        @Override
        public int getKeyLength() {
            return this.length;
        }

        @Override
        public short getRowLength() {
            return this.rowLen;
        }

        @Override
        public byte getTypeByte() {
            return this.bytes[this.offset + this.getKeyLength() - 1];
        }

        @Override
        private int getQualifierLength(int rlength, int flength) {
            return this.getKeyLength() - (int)KeyOnlyKeyValue.getKeyDataStructureSize(rlength, flength, 0);
        }

        @Override
        public long getTimestamp() {
            int tsOffset = this.getTimestampOffset();
            return Bytes.toLong(this.bytes, tsOffset);
        }

        @Override
        public int getTimestampOffset() {
            return this.getKeyOffset() + this.getKeyLength() - 9;
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public byte[] getValueArray() {
            throw new IllegalArgumentException("KeyOnlyKeyValue does not work with values.");
        }

        @Override
        public int getValueOffset() {
            throw new IllegalArgumentException("KeyOnlyKeyValue does not work with values.");
        }

        @Override
        public int getValueLength() {
            throw new IllegalArgumentException("KeyOnlyKeyValue does not work with values.");
        }

        @Override
        public int getTagsLength() {
            return 0;
        }

        @Override
        public String toString() {
            if (this.bytes == null || this.bytes.length == 0) {
                return "empty";
            }
            return KeyOnlyKeyValue.keyToString(this.bytes, this.offset, this.getKeyLength()) + "/vlen=0/mvcc=0";
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public long heapSize() {
            return super.heapSize() + 2L;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            throw new IllegalStateException("A reader should never return this type of a Cell");
        }
    }

    public static interface SamePrefixComparator<T> {
        public int compareIgnoringPrefix(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7);
    }

    @Deprecated
    public static class KVComparator
    implements RawComparator<Cell>,
    SamePrefixComparator<byte[]> {
        public String getLegacyKeyComparatorName() {
            return "org.apache.hadoop.hbase.KeyValue$KeyComparator";
        }

        @Override
        public int compare(byte[] l, int loff, int llen, byte[] r, int roff, int rlen) {
            return this.compareFlatKey(l, loff, llen, r, roff, rlen);
        }

        protected int compareRowKey(Cell left, Cell right) {
            return CellComparatorImpl.COMPARATOR.compareRows(left, right);
        }

        public int compareFlatKey(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            short rrowlength;
            short lrowlength = Bytes.toShort(left, loffset);
            int compare = this.compareRows(left, loffset + 2, lrowlength, right, roffset + 2, rrowlength = Bytes.toShort(right, roffset));
            if (compare != 0) {
                return compare;
            }
            return this.compareWithoutRow(0, left, loffset, llength, right, roffset, rlength, rrowlength);
        }

        public int compareFlatKey(byte[] left, byte[] right) {
            return this.compareFlatKey(left, 0, left.length, right, 0, right.length);
        }

        public int compareKey(Cell cell, byte[] row, int roff, int rlen, byte[] fam, int foff, int flen, byte[] col, int coff, int clen, long ts, byte type) {
            int compare = this.compareRows(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), row, roff, rlen);
            if (compare != 0) {
                return compare;
            }
            if (cell.getFamilyLength() + cell.getQualifierLength() == 0 && cell.getTypeByte() == Type.Minimum.getCode()) {
                return 1;
            }
            if (flen + clen == 0 && type == Type.Minimum.getCode()) {
                return -1;
            }
            compare = this.compareFamilies(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), fam, foff, flen);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareColumns(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), col, coff, clen);
            if (compare != 0) {
                return compare;
            }
            compare = KVComparator.compareTimestamps(cell.getTimestamp(), ts);
            if (compare != 0) {
                return compare;
            }
            return (0xFF & type) - (0xFF & cell.getTypeByte());
        }

        public int compareOnlyKeyPortion(Cell left, Cell right) {
            return PrivateCellUtil.compareKeyIgnoresMvcc(CellComparatorImpl.COMPARATOR, left, right);
        }

        @Override
        public int compare(Cell left, Cell right) {
            int compare = CellComparatorImpl.COMPARATOR.compare(left, right);
            return compare;
        }

        public int compareTimestamps(Cell left, Cell right) {
            return CellComparatorImpl.COMPARATOR.compareTimestamps(left, right);
        }

        public int compareRows(Cell left, Cell right) {
            return this.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
        }

        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
        }

        int compareColumns(Cell left, short lrowlength, Cell right, short rrowlength) {
            return CellComparatorImpl.COMPARATOR.compareColumns(left, right);
        }

        protected int compareColumns(byte[] left, int loffset, int llength, int lfamilylength, byte[] right, int roffset, int rlength, int rfamilylength) {
            int diff = Bytes.compareTo(left, loffset, lfamilylength, right, roffset, rfamilylength);
            if (diff != 0) {
                return diff;
            }
            return Bytes.compareTo(left, loffset + lfamilylength, llength - lfamilylength, right, roffset + rfamilylength, rlength - rfamilylength);
        }

        static int compareTimestamps(long ltimestamp, long rtimestamp) {
            if (ltimestamp < rtimestamp) {
                return 1;
            }
            if (ltimestamp > rtimestamp) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareIgnoringPrefix(int commonPrefix, byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            short rrowlength;
            short lrowlength = Bytes.toShort(left, loffset);
            int comparisonResult = 0;
            if (commonPrefix < 2) {
                rrowlength = Bytes.toShort(right, roffset);
                comparisonResult = this.compareRows(left, loffset + 2, lrowlength, right, roffset + 2, rrowlength);
            } else {
                rrowlength = lrowlength;
                if (commonPrefix < 2 + rrowlength) {
                    int common = commonPrefix - 2;
                    comparisonResult = this.compareRows(left, loffset + common + 2, lrowlength - common, right, roffset + common + 2, rrowlength - common);
                }
            }
            if (comparisonResult != 0) {
                return comparisonResult;
            }
            assert (lrowlength == rrowlength);
            return this.compareWithoutRow(commonPrefix, left, loffset, llength, right, roffset, rlength, lrowlength);
        }

        private int compareWithoutRow(int commonPrefix, byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength, short rowlength) {
            long rtimestamp;
            int commonLength = 3 + rowlength;
            int commonLengthWithTSAndType = 9 + commonLength;
            int lcolumnlength = llength - commonLengthWithTSAndType;
            int rcolumnlength = rlength - commonLengthWithTSAndType;
            byte ltype = left[loffset + (llength - 1)];
            byte rtype = right[roffset + (rlength - 1)];
            if (lcolumnlength == 0 && ltype == Type.Minimum.getCode()) {
                return 1;
            }
            if (rcolumnlength == 0 && rtype == Type.Minimum.getCode()) {
                return -1;
            }
            int lfamilyoffset = commonLength + loffset;
            byte lfamilylength = left[lfamilyoffset - 1];
            int rfamilyoffset = commonLength + roffset;
            byte rfamilylength = right[rfamilyoffset - 1];
            boolean sameFamilySize = lfamilylength == rfamilylength;
            int common = 0;
            if (commonPrefix > 0) {
                common = Math.max(0, commonPrefix - commonLength);
                common = !sameFamilySize ? Math.min(common, Math.min(lfamilylength, rfamilylength)) : Math.min(common, Math.min(lcolumnlength, rcolumnlength));
            }
            if (!sameFamilySize) {
                return Bytes.compareTo(left, lfamilyoffset + common, lfamilylength - common, right, rfamilyoffset + common, rfamilylength - common);
            }
            int comparison = Bytes.compareTo(left, lfamilyoffset + common, lcolumnlength - common, right, rfamilyoffset + common, rcolumnlength - common);
            if (comparison != 0) {
                return comparison;
            }
            long ltimestamp = Bytes.toLong(left, loffset + (llength - 9));
            int compare = KVComparator.compareTimestamps(ltimestamp, rtimestamp = Bytes.toLong(right, roffset + (rlength - 9)));
            if (compare != 0) {
                return compare;
            }
            return (0xFF & rtype) - (0xFF & ltype);
        }

        protected int compareFamilies(byte[] left, int loffset, int lfamilylength, byte[] right, int roffset, int rfamilylength) {
            int diff = Bytes.compareTo(left, loffset, lfamilylength, right, roffset, rfamilylength);
            return diff;
        }

        protected int compareColumns(byte[] left, int loffset, int lquallength, byte[] right, int roffset, int rquallength) {
            int diff = Bytes.compareTo(left, loffset, lquallength, right, roffset, rquallength);
            return diff;
        }

        public boolean matchingRowColumn(Cell left, Cell right) {
            short lrowlength = left.getRowLength();
            short rrowlength = right.getRowLength();
            if (left.getRowLength() + left.getFamilyLength() + left.getQualifierLength() != right.getRowLength() + right.getFamilyLength() + right.getQualifierLength()) {
                return false;
            }
            if (!this.matchingRows(left, lrowlength, right, rrowlength)) {
                return false;
            }
            int lfoffset = left.getFamilyOffset();
            int rfoffset = right.getFamilyOffset();
            int lclength = left.getQualifierLength();
            int rclength = right.getQualifierLength();
            byte lfamilylength = left.getFamilyLength();
            byte rfamilylength = right.getFamilyLength();
            int diff = this.compareFamilies(left.getFamilyArray(), lfoffset, lfamilylength, right.getFamilyArray(), rfoffset, rfamilylength);
            if (diff != 0) {
                return false;
            }
            diff = this.compareColumns(left.getQualifierArray(), left.getQualifierOffset(), lclength, right.getQualifierArray(), right.getQualifierOffset(), rclength);
            return diff == 0;
        }

        public boolean matchingRows(Cell left, Cell right) {
            short lrowlength = left.getRowLength();
            short rrowlength = right.getRowLength();
            return this.matchingRows(left, lrowlength, right, rrowlength);
        }

        private boolean matchingRows(Cell left, short lrowlength, Cell right, short rrowlength) {
            return lrowlength == rrowlength && this.matchingRows(left.getRowArray(), left.getRowOffset(), lrowlength, right.getRowArray(), right.getRowOffset(), rrowlength);
        }

        public boolean matchingRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return Bytes.equals(left, loffset, llength, right, roffset, rlength);
        }

        public byte[] calcIndexKey(byte[] lastKeyOfPreviousBlock, byte[] firstKeyInBlock) {
            byte[] fakeKey = this.getShortMidpointKey(lastKeyOfPreviousBlock, firstKeyInBlock);
            if (this.compareFlatKey(fakeKey, firstKeyInBlock) > 0) {
                LOG.error("Unexpected getShortMidpointKey result, fakeKey:" + Bytes.toStringBinary(fakeKey) + ", firstKeyInBlock:" + Bytes.toStringBinary(firstKeyInBlock));
                return firstKeyInBlock;
            }
            if (lastKeyOfPreviousBlock != null && this.compareFlatKey(lastKeyOfPreviousBlock, fakeKey) >= 0) {
                LOG.error("Unexpected getShortMidpointKey result, lastKeyOfPreviousBlock:" + Bytes.toStringBinary(lastKeyOfPreviousBlock) + ", fakeKey:" + Bytes.toStringBinary(fakeKey));
                return firstKeyInBlock;
            }
            return fakeKey;
        }

        @Deprecated
        public byte[] getShortMidpointKey(byte[] leftKey, byte[] rightKey) {
            short diffIdx;
            if (rightKey == null) {
                throw new IllegalArgumentException("rightKey can not be null");
            }
            if (leftKey == null) {
                return Arrays.copyOf(rightKey, rightKey.length);
            }
            if (this.compareFlatKey(leftKey, rightKey) >= 0) {
                throw new IllegalArgumentException("Unexpected input, leftKey:" + Bytes.toString(leftKey) + ", rightKey:" + Bytes.toString(rightKey));
            }
            short leftRowLength = Bytes.toShort(leftKey, 0);
            short rightRowLength = Bytes.toShort(rightKey, 0);
            int leftCommonLength = 3 + leftRowLength;
            int rightCommonLength = 3 + rightRowLength;
            int leftCommonLengthWithTSAndType = 9 + leftCommonLength;
            int rightCommonLengthWithTSAndType = 9 + rightCommonLength;
            int leftColumnLength = leftKey.length - leftCommonLengthWithTSAndType;
            int rightColumnLength = rightKey.length - rightCommonLengthWithTSAndType;
            if (leftRowLength == rightRowLength && this.compareRows(leftKey, 2, leftRowLength, rightKey, 2, rightRowLength) == 0) {
                int comparison = Bytes.compareTo(leftKey, leftCommonLength, leftColumnLength, rightKey, rightCommonLength, rightColumnLength);
                if (comparison == 0) {
                    return Arrays.copyOf(rightKey, rightKey.length);
                }
                byte[] newKey = Arrays.copyOf(rightKey, rightKey.length);
                Bytes.putLong(newKey, rightKey.length - 9, Long.MAX_VALUE);
                Bytes.putByte(newKey, rightKey.length - 1, Type.Maximum.getCode());
                return newKey;
            }
            short minLength = leftRowLength < rightRowLength ? leftRowLength : rightRowLength;
            for (diffIdx = 0; diffIdx < minLength && leftKey[2 + diffIdx] == rightKey[2 + diffIdx]; diffIdx = (short)(diffIdx + 1)) {
            }
            byte[] newRowKey = null;
            if (diffIdx >= minLength) {
                newRowKey = new byte[diffIdx + 1];
                System.arraycopy(rightKey, 2, newRowKey, 0, diffIdx + 1);
            } else {
                byte diffByte = leftKey[2 + diffIdx];
                if ((0xFF & diffByte) < 255 && diffByte + 1 < (rightKey[2 + diffIdx] & 0xFF)) {
                    newRowKey = new byte[diffIdx + 1];
                    System.arraycopy(leftKey, 2, newRowKey, 0, diffIdx);
                    newRowKey[diffIdx] = (byte)(diffByte + 1);
                } else {
                    newRowKey = new byte[diffIdx + 1];
                    System.arraycopy(rightKey, 2, newRowKey, 0, diffIdx + 1);
                }
            }
            return new KeyValue(newRowKey, null, null, Long.MAX_VALUE, Type.Maximum).getKey();
        }

        protected Object clone() throws CloneNotSupportedException {
            super.clone();
            return new KVComparator();
        }
    }

    @Deprecated
    public static class MetaComparator
    extends KVComparator {
        @Override
        public int compare(Cell left, Cell right) {
            return PrivateCellUtil.compareKeyIgnoresMvcc(CellComparatorImpl.META_COMPARATOR, left, right);
        }

        @Override
        public int compareOnlyKeyPortion(Cell left, Cell right) {
            return this.compare(left, right);
        }

        @Override
        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            int rightFarDelimiter;
            int leftFarDelimiter;
            int rightDelimiter;
            int rpart;
            int leftDelimiter = KeyValue.getDelimiter(left, loffset, llength, 44);
            int lpart = leftDelimiter < 0 ? llength : leftDelimiter - loffset;
            int result = Bytes.compareTo(left, loffset, lpart, right, roffset, rpart = (rightDelimiter = KeyValue.getDelimiter(right, roffset, rlength, 44)) < 0 ? rlength : rightDelimiter - roffset);
            if (result != 0) {
                return result;
            }
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            if ((result = super.compareRows(left, leftDelimiter, lpart = ((leftFarDelimiter = KeyValue.getDelimiterInReverse(left, ++leftDelimiter, llength - (leftDelimiter - loffset), 44)) < 0 ? llength + loffset : leftFarDelimiter) - leftDelimiter, right, rightDelimiter, rpart = ((rightFarDelimiter = KeyValue.getDelimiterInReverse(right, ++rightDelimiter, rlength - (rightDelimiter - roffset), 44)) < 0 ? rlength + roffset : rightFarDelimiter) - rightDelimiter)) != 0) {
                return result;
            }
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            result = Bytes.compareTo(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
            return result;
        }

        @Override
        public byte[] getShortMidpointKey(byte[] leftKey, byte[] rightKey) {
            return Arrays.copyOf(rightKey, rightKey.length);
        }

        @Override
        public String getLegacyKeyComparatorName() {
            return "org.apache.hadoop.hbase.KeyValue$MetaKeyComparator";
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new MetaComparator();
        }

        @Override
        protected int compareRowKey(Cell l, Cell r) {
            byte[] left = l.getRowArray();
            int loffset = l.getRowOffset();
            short llength = l.getRowLength();
            byte[] right = r.getRowArray();
            int roffset = r.getRowOffset();
            short rlength = r.getRowLength();
            return this.compareRows(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static enum Type {
        Minimum(0),
        Put(4),
        Delete(8),
        DeleteFamilyVersion(10),
        DeleteColumn(12),
        DeleteFamily(14),
        Maximum(-1);

        private final byte code;
        private static Type[] codeArray;

        private Type(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public static Type codeToType(byte b) {
            Type t = codeArray[b & 0xFF];
            if (t != null) {
                return t;
            }
            throw new RuntimeException("Unknown code " + b);
        }

        static {
            codeArray = new Type[256];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type t;
                Type.codeArray[t.code & 0xFF] = t = typeArray[i];
            }
        }
    }
}

