/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetaTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTableAccessor.class);
    private static final Logger METALOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hbase.META");
    static final byte[] META_REGION_PREFIX;
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN;

    @Deprecated
    public static NavigableMap<RegionInfo, ServerName> allTableRegions(Connection connection, TableName tableName) throws IOException {
        final TreeMap<RegionInfo, ServerName> regions = new TreeMap<RegionInfo, ServerName>();
        TableVisitorBase visitor = new TableVisitorBase(tableName){

            @Override
            public boolean visitInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    HRegionInfo regionInfo = loc.getRegionInfo();
                    regions.put(regionInfo, loc.getServerName());
                }
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions(connection, visitor, tableName);
        return regions;
    }

    public static void fullScanRegions(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.REGION, visitor);
    }

    public static List<Result> fullScanRegions(Connection connection) throws IOException {
        return MetaTableAccessor.fullScan(connection, QueryType.REGION);
    }

    public static void fullScanTables(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.TABLE, visitor);
    }

    public static List<Result> fullScan(Connection connection, QueryType type) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaTableAccessor.scanMeta(connection, null, null, type, (Visitor)v);
        return v.getResults();
    }

    public static Table getMetaHTable(Connection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("No connection");
        }
        if (connection.isClosed()) {
            throw new IOException("connection is closed");
        }
        return connection.getTable(TableName.META_TABLE_NAME);
    }

    private static Result get(Table t, Get g) throws IOException {
        if (t == null) {
            return null;
        }
        try {
            Result result = t.get(g);
            return result;
        }
        finally {
            t.close();
        }
    }

    @Deprecated
    public static Pair<RegionInfo, ServerName> getRegion(Connection connection, byte[] regionName) throws IOException {
        HRegionLocation location = MetaTableAccessor.getRegionLocation(connection, regionName);
        return location == null ? null : new Pair<HRegionInfo, ServerName>(location.getRegionInfo(), location.getServerName());
    }

    public static HRegionLocation getRegionLocation(Connection connection, byte[] regionName) throws IOException {
        byte[] row = regionName;
        RegionInfo parsedInfo = null;
        try {
            parsedInfo = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            row = MetaTableAccessor.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
        return locations == null ? null : locations.getRegionLocation(parsedInfo == null ? 0 : parsedInfo.getReplicaId());
    }

    public static HRegionLocation getRegionLocation(Connection connection, RegionInfo regionInfo) throws IOException {
        byte[] row = MetaTableAccessor.getMetaKeyForRegion(regionInfo);
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        return MetaTableAccessor.getRegionLocation(r, regionInfo, regionInfo.getReplicaId());
    }

    public static byte[] getMetaKeyForRegion(RegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo).getRegionName();
    }

    public static RegionInfo parseRegionInfoFromRegionName(byte[] regionName) throws IOException {
        byte[][] fields = RegionInfo.parseRegionName(regionName);
        long regionId = Long.parseLong(Bytes.toString(fields[2]));
        int replicaId = fields.length > 3 ? Integer.parseInt(Bytes.toString(fields[3]), 16) : 0;
        return RegionInfoBuilder.newBuilder(TableName.valueOf(fields[0])).setStartKey(fields[1]).setEndKey(fields[2]).setSplit(false).setRegionId(regionId).setReplicaId(replicaId).build();
    }

    public static Result getRegionResult(Connection connection, byte[] regionName) throws IOException {
        Get get = new Get(regionName);
        get.addFamily(HConstants.CATALOG_FAMILY);
        return MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
    }

    @Nullable
    public static Pair<RegionInfo, RegionInfo> getRegionsFromMergeQualifier(Connection connection, byte[] regionName) throws IOException {
        Result result = MetaTableAccessor.getRegionResult(connection, regionName);
        RegionInfo mergeA = MetaTableAccessor.getRegionInfo(result, HConstants.MERGEA_QUALIFIER);
        RegionInfo mergeB = MetaTableAccessor.getRegionInfo(result, HConstants.MERGEB_QUALIFIER);
        if (mergeA == null && mergeB == null) {
            return null;
        }
        return new Pair<RegionInfo, RegionInfo>(mergeA, mergeB);
    }

    public static boolean tableExists(Connection connection, TableName tableName) throws IOException {
        return tableName.equals(TableName.META_TABLE_NAME) || MetaTableAccessor.getTableState(connection, tableName) != null;
    }

    @VisibleForTesting
    public static List<RegionInfo> getAllRegions(Connection connection, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<RegionInfo, ServerName>> result = MetaTableAccessor.getTableRegionsAndLocations(connection, null, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfRegionInfos(result);
    }

    public static List<RegionInfo> getTableRegions(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegions(connection, tableName, false);
    }

    public static List<RegionInfo> getTableRegions(Connection connection, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<RegionInfo, ServerName>> result = MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfRegionInfos(result);
    }

    private static List<RegionInfo> getListOfRegionInfos(List<Pair<RegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegionInfo> result = new ArrayList<RegionInfo>(pairs.size());
        for (Pair<RegionInfo, ServerName> pair : pairs) {
            result.add(pair.getFirst());
        }
        return result;
    }

    public static byte[] getTableStartRowForMeta(TableName tableName, QueryType type) {
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: {
                byte[] startRow = new byte[tableName.getName().length + 2];
                System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
                startRow[startRow.length - 2] = 44;
                startRow[startRow.length - 1] = 44;
                return startRow;
            }
        }
        return tableName.getName();
    }

    public static byte[] getTableStopRowForMeta(TableName tableName, QueryType type) {
        byte[] stopRow;
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: {
                stopRow = new byte[tableName.getName().length + 3];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 3] = 32;
                stopRow[stopRow.length - 2] = 44;
                stopRow[stopRow.length - 1] = 44;
                break;
            }
            default: {
                stopRow = new byte[tableName.getName().length + 1];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 1] = 32;
            }
        }
        return stopRow;
    }

    @Deprecated
    public static Scan getScanForTableName(Connection connection, TableName tableName) {
        byte[] startKey = MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION);
        byte[] stopKey = MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION);
        Scan scan = MetaTableAccessor.getMetaScan(connection, -1);
        scan.setStartRow(startKey);
        scan.setStopRow(stopKey);
        return scan;
    }

    private static Scan getMetaScan(Connection connection, int rowUpperLimit) {
        Scan scan = new Scan();
        int scannerCaching = connection.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
        if (connection.getConfiguration().getBoolean("hbase.meta.replicas.use", false)) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit > 0) {
            scan.setLimit(rowUpperLimit);
            scan.setReadType(Scan.ReadType.PREAD);
        }
        scan.setCaching(scannerCaching);
        return scan;
    }

    public static List<Pair<RegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, true);
    }

    public static List<Pair<RegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, @Nullable TableName tableName, final boolean excludeOfflinedSplitParents) throws IOException {
        if (tableName != null && tableName.equals(TableName.META_TABLE_NAME)) {
            throw new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead");
        }
        CollectingVisitor<Pair<RegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<RegionInfo, ServerName>>(){
            private RegionLocations current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = MetaTableAccessor.getRegionLocations(r);
                if (this.current == null || this.current.getRegionLocation().getRegion() == null) {
                    LOG.warn("No serialized RegionInfo in " + r);
                    return true;
                }
                RegionInfo hri = this.current.getRegionLocation().getRegion();
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (this.current == null) {
                    return;
                }
                for (HRegionLocation loc : this.current.getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair<RegionInfo, ServerName>(loc.getRegion(), loc.getServerName()));
                }
            }
        };
        MetaTableAccessor.scanMeta(connection, MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION), MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION), QueryType.REGION, (Visitor)visitor);
        return visitor.getResults();
    }

    public static NavigableMap<RegionInfo, Result> getServerUserRegions(Connection connection, final ServerName serverName) throws IOException {
        final TreeMap<RegionInfo, Result> hris = new TreeMap<RegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null) {
                    return;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null || loc.getServerName() == null || !loc.getServerName().equals(serverName)) continue;
                    hris.put(loc.getRegion(), r);
                }
            }
        };
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.REGION, (Visitor)v);
        return hris;
    }

    public static void fullScanMetaAndPrint(Connection connection) throws IOException {
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                LOG.info("fullScanMetaAndPrint.Current Meta Row: " + r);
                TableState state = MetaTableAccessor.getTableState(r);
                if (state != null) {
                    LOG.info("Table State: " + state);
                } else {
                    RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                    if (locations == null) {
                        return true;
                    }
                    for (HRegionLocation loc : locations.getRegionLocations()) {
                        if (loc == null) continue;
                        LOG.info("fullScanMetaAndPrint.HRI Print= " + loc.getRegion());
                    }
                }
                return true;
            }
        };
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.ALL, v);
    }

    public static void scanMetaForTableRegions(Connection connection, Visitor visitor, TableName tableName) throws IOException {
        MetaTableAccessor.scanMeta(connection, tableName, QueryType.REGION, Integer.MAX_VALUE, visitor);
    }

    public static void scanMeta(Connection connection, TableName table, QueryType type, int maxRows, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, MetaTableAccessor.getTableStartRowForMeta(table, type), MetaTableAccessor.getTableStopRowForMeta(table, type), type, maxRows, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, type, Integer.MAX_VALUE, visitor);
    }

    public static void scanMeta(Connection connection, Visitor visitor, TableName tableName, byte[] row, int rowLimit) throws IOException {
        byte[] startRow = null;
        byte[] stopRow = null;
        if (tableName != null) {
            startRow = MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION);
            if (row != null) {
                RegionInfo closestRi = MetaTableAccessor.getClosestRegionInfo(connection, tableName, row);
                startRow = RegionInfo.createRegionName(tableName, closestRi.getStartKey(), "00000000000000", false);
            }
            stopRow = MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION);
        }
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, QueryType.REGION, rowLimit, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type, int maxRows, Visitor visitor) throws IOException {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan = MetaTableAccessor.getMetaScan(connection, rowUpperLimit);
        for (byte[] family : type.getFamilies()) {
            scan.addFamily(family);
        }
        if (startRow != null) {
            scan.withStartRow(startRow);
        }
        if (stopRow != null) {
            scan.withStopRow(stopRow);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scanning META starting at row=" + Bytes.toStringBinary(startRow) + " stopping at row=" + Bytes.toStringBinary(stopRow) + " for max=" + rowUpperLimit + " with caching=" + scan.getCaching());
        }
        int currentRow = 0;
        try (Table metaTable = MetaTableAccessor.getMetaHTable(connection);
             ResultScanner scanner = metaTable.getScanner(scan);){
            Result data;
            while ((data = scanner.next()) != null) {
                if (data.isEmpty()) continue;
                if (!visitor.visit(data)) {
                } else if (++currentRow < rowUpperLimit) continue;
                break;
            }
        }
        if (visitor != null && visitor instanceof Closeable) {
            try {
                ((Closeable)((Object)visitor)).close();
            }
            catch (Throwable t) {
                ExceptionUtil.rethrowIfInterrupt(t);
                LOG.debug("Got exception in closing the meta scanner visitor", t);
            }
        }
    }

    @NonNull
    private static RegionInfo getClosestRegionInfo(Connection connection, @NonNull TableName tableName, @NonNull byte[] row) throws IOException {
        byte[] searchRow = RegionInfo.createRegionName(tableName, row, "99999999999999", false);
        Scan scan = MetaTableAccessor.getMetaScan(connection, 1);
        scan.setReversed(true);
        scan.withStartRow(searchRow);
        try (ResultScanner resultScanner = MetaTableAccessor.getMetaHTable(connection).getScanner(scan);){
            Result result = resultScanner.next();
            if (result == null) {
                throw new TableNotFoundException("Cannot find row in META  for table: " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            RegionInfo regionInfo = MetaTableAccessor.getRegionInfo(result);
            if (regionInfo == null) {
                throw new IOException("RegionInfo was null or empty in Meta for " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            RegionInfo regionInfo2 = regionInfo;
            return regionInfo2;
        }
    }

    private static byte[] getCatalogFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    private static byte[] getTableFamily() {
        return HConstants.TABLE_FAMILY;
    }

    private static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    private static byte[] getTableStateColumn() {
        return HConstants.TABLE_STATE_QUALIFIER;
    }

    private static byte[] getRegionStateColumn() {
        return HConstants.STATE_QUALIFIER;
    }

    @VisibleForTesting
    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes("server_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes("serverstartcode_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes("seqnumDuringOpen_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString(serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    @InterfaceAudience.Private
    @Nullable
    public static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        byte[] startcodeColumn = MetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        try {
            return ServerName.valueOf(hostAndPort, Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell, (Throwable)e);
            return null;
        }
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    @Nullable
    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        RegionInfo regionInfo = MetaTableAccessor.getRegionInfo(r, MetaTableAccessor.getRegionInfoColumn());
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(MetaTableAccessor.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(MetaTableAccessor.getCatalogFamily());
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = null;
        serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator iterator = serverMap.entrySet().iterator();
        while (iterator.hasNext() && (replicaId = MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = iterator.next()).getKey())) >= 0) {
            HRegionLocation location = MetaTableAccessor.getRegionLocation(r, regionInfo, replicaId);
            if (location == null || location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return new RegionLocations(locations);
    }

    private static HRegionLocation getRegionLocation(Result r, RegionInfo regionInfo, int replicaId) {
        ServerName serverName = MetaTableAccessor.getServerName(r, replicaId);
        long seqNum = MetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        RegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    public static RegionInfo getRegionInfo(Result data) {
        return MetaTableAccessor.getRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    @Nullable
    private static RegionInfo getRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), qualifier);
        if (cell == null) {
            return null;
        }
        return RegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static PairOfSameType<RegionInfo> getDaughterRegions(Result data) {
        RegionInfo splitA = MetaTableAccessor.getRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        RegionInfo splitB = MetaTableAccessor.getRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType<RegionInfo>(splitA, splitB);
    }

    public static PairOfSameType<RegionInfo> getMergeRegions(Result data) {
        RegionInfo mergeA = MetaTableAccessor.getRegionInfo(data, HConstants.MERGEA_QUALIFIER);
        RegionInfo mergeB = MetaTableAccessor.getRegionInfo(data, HConstants.MERGEB_QUALIFIER);
        return new PairOfSameType<RegionInfo>(mergeA, mergeB);
    }

    @Nullable
    public static TableState getTableState(Connection conn, TableName tableName) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return new TableState(tableName, TableState.State.ENABLED);
        }
        Table metaHTable = MetaTableAccessor.getMetaHTable(conn);
        Get get = new Get(tableName.getName()).addColumn(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn());
        Result result = metaHTable.get(get);
        return MetaTableAccessor.getTableState(result);
    }

    public static Map<TableName, TableState> getTableStates(Connection conn) throws IOException {
        final LinkedHashMap<TableName, TableState> states = new LinkedHashMap<TableName, TableState>();
        Visitor collector = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                TableState state = MetaTableAccessor.getTableState(r);
                if (state != null) {
                    states.put(state.getTableName(), state);
                }
                return true;
            }
        };
        MetaTableAccessor.fullScanTables(conn, collector);
        return states;
    }

    public static void updateTableState(Connection conn, TableName tableName, TableState.State actual) throws IOException {
        MetaTableAccessor.updateTableState(conn, new TableState(tableName, actual));
    }

    @Nullable
    public static TableState getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn());
        if (cell == null) {
            return null;
        }
        try {
            return TableState.parseFrom(TableName.valueOf(r.getRow()), Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength()));
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static int getRegionCount(Configuration c, TableName tableName) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(c);){
            int n = MetaTableAccessor.getRegionCount(connection, tableName);
            return n;
        }
    }

    public static int getRegionCount(Connection connection, TableName tableName) throws IOException {
        try (RegionLocator locator = connection.getRegionLocator(tableName);){
            List<HRegionLocation> locations = locator.getAllRegionLocations();
            int n = locations == null ? 0 : locations.size();
            return n;
        }
    }

    public static Put makePutFromRegionInfo(RegionInfo regionInfo, long ts) throws IOException {
        Put put = new Put(regionInfo.getRegionName(), ts);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        return put;
    }

    private static Delete makeDeleteFromRegionInfo(RegionInfo regionInfo, long ts) {
        if (regionInfo == null) {
            throw new IllegalArgumentException("Can't make a delete for null region");
        }
        Delete delete = new Delete(regionInfo.getRegionName());
        delete.addFamily(MetaTableAccessor.getCatalogFamily(), ts);
        return delete;
    }

    public static Put addDaughtersToPut(Put put, RegionInfo splitA, RegionInfo splitB) throws IOException {
        if (splitA != null) {
            put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.SPLITA_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(splitA)).build());
        }
        if (splitB != null) {
            put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.SPLITB_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(splitB)).build());
        }
        return put;
    }

    private static void putToMetaTable(Connection connection, Put p) throws IOException {
        try (Table table = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.put(table, p);
        }
    }

    private static void put(Table t, Put p) throws IOException {
        MetaTableAccessor.debugLogMutation(p);
        t.put(p);
    }

    public static void putsToMetaTable(Connection connection, List<Put> ps) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(ps);
            t.put(ps);
        }
    }

    private static void deleteFromMetaTable(Connection connection, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaTableAccessor.deleteFromMetaTable(connection, dels);
    }

    private static void deleteFromMetaTable(Connection connection, List<Delete> deletes) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(deletes);
            t.delete(deletes);
        }
    }

    public static void removeRegionReplicasFromMeta(Set<byte[]> metaRows, int replicaIndexToDeleteFrom, int numReplicasToRemove, Connection connection) throws IOException {
        int absoluteIndex = replicaIndexToDeleteFrom + numReplicasToRemove;
        for (byte[] row : metaRows) {
            long now = EnvironmentEdgeManager.currentTime();
            Delete deleteReplicaLocations = new Delete(row);
            for (int i = replicaIndexToDeleteFrom; i < absoluteIndex; ++i) {
                deleteReplicaLocations.addColumns(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getServerColumn(i), now);
                deleteReplicaLocations.addColumns(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(i), now);
                deleteReplicaLocations.addColumns(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getStartCodeColumn(i), now);
            }
            MetaTableAccessor.deleteFromMetaTable(connection, deleteReplicaLocations);
        }
    }

    public static void mutateMetaTable(Connection connection, List<Mutation> mutations) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(mutations);
            t.batch(mutations, null);
        }
    }

    private static void addRegionStateToPut(Put put, RegionState.State state) throws IOException {
        put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(MetaTableAccessor.getRegionStateColumn()).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(state.name())).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSplitsToParent(Connection connection, RegionInfo regionInfo, RegionInfo splitA, RegionInfo splitB) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo, EnvironmentEdgeManager.currentTime());
            MetaTableAccessor.addDaughtersToPut(put, splitA, splitB);
            meta.put(put);
            MetaTableAccessor.debugLogMutation(put);
            LOG.debug("Added region {}", (Object)regionInfo.getRegionNameAsString());
        }
    }

    @VisibleForTesting
    public static void addRegionToMeta(Connection connection, RegionInfo regionInfo) throws IOException {
        MetaTableAccessor.addRegionsToMeta(connection, Collections.singletonList(regionInfo), 1);
    }

    public static void addRegionsToMeta(Connection connection, List<RegionInfo> regionInfos, int regionReplication) throws IOException {
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, EnvironmentEdgeManager.currentTime());
    }

    private static void addRegionsToMeta(Connection connection, List<RegionInfo> regionInfos, int regionReplication, long ts) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (RegionInfo regionInfo : regionInfos) {
            if (!RegionReplicaUtil.isDefaultReplica(regionInfo)) continue;
            Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo, ts);
            MetaTableAccessor.addRegionStateToPut(put, RegionState.State.CLOSED);
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(put, i);
            }
            puts.add(put);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts);
        LOG.info("Added {} regions to meta.", (Object)puts.size());
    }

    public static void mergeRegions(Connection connection, RegionInfo mergedRegion, RegionInfo regionA, RegionInfo regionB, ServerName sn, int regionReplication) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            long time = EnvironmentEdgeManager.currentTime();
            Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo(mergedRegion, time);
            putOfMerged.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(putOfMerged.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.MERGEA_QUALIFIER).setTimestamp(putOfMerged.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(regionA)).build()).add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(putOfMerged.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.MERGEB_QUALIFIER).setTimestamp(putOfMerged.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(regionB)).build());
            MetaTableAccessor.addRegionStateToPut(putOfMerged, RegionState.State.CLOSED);
            Delete deleteA = MetaTableAccessor.makeDeleteFromRegionInfo(regionA, time);
            Delete deleteB = MetaTableAccessor.makeDeleteFromRegionInfo(regionB, time);
            if (sn != null) {
                MetaTableAccessor.addLocation(putOfMerged, sn, 1L, mergedRegion.getReplicaId());
            }
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(putOfMerged, i);
            }
            byte[] tableRow = Bytes.toBytes(mergedRegion.getRegionNameAsString() + 44);
            MetaTableAccessor.multiMutate(connection, meta, tableRow, putOfMerged, deleteA, deleteB);
        }
    }

    public static void splitRegion(Connection connection, RegionInfo parent, RegionInfo splitA, RegionInfo splitB, ServerName sn, int regionReplication) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            long time = EnvironmentEdgeManager.currentTime();
            Put putParent = MetaTableAccessor.makePutFromRegionInfo(RegionInfoBuilder.newBuilder(parent).setOffline(true).setSplit(true).build(), time);
            MetaTableAccessor.addDaughtersToPut(putParent, splitA, splitB);
            Put putA = MetaTableAccessor.makePutFromRegionInfo(splitA, time);
            Put putB = MetaTableAccessor.makePutFromRegionInfo(splitB, time);
            MetaTableAccessor.addRegionStateToPut(putA, RegionState.State.CLOSED);
            MetaTableAccessor.addRegionStateToPut(putB, RegionState.State.CLOSED);
            MetaTableAccessor.addSequenceNum(putA, 1L, splitA.getReplicaId());
            MetaTableAccessor.addSequenceNum(putB, 1L, splitB.getReplicaId());
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(putA, i);
                MetaTableAccessor.addEmptyLocation(putB, i);
            }
            byte[] tableRow = Bytes.toBytes(parent.getRegionNameAsString() + 44);
            MetaTableAccessor.multiMutate(connection, meta, tableRow, putParent, putA, putB);
        }
    }

    private static void updateTableState(Connection connection, TableState state) throws IOException {
        Put put = MetaTableAccessor.makePutFromTableState(state, EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info("Updated {} in hbase:meta", (Object)state);
    }

    public static Put makePutFromTableState(TableState state, long ts) {
        Put put = new Put(state.getTableName().getName(), ts);
        put.addColumn(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn(), state.convert().toByteArray());
        return put;
    }

    public static void deleteTableState(Connection connection, TableName table) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(table.getName());
        delete.addColumns(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn(), time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info("Deleted table " + table + " state from META");
    }

    private static void multiMutate(Connection connection, Table table, byte[] row, Mutation ... mutations) throws IOException {
        MetaTableAccessor.multiMutate(connection, table, row, Arrays.asList(mutations));
    }

    public static void multiMutate(Connection connection, final Table table, byte[] row, final List<Mutation> mutations) throws IOException {
        MetaTableAccessor.debugLogMutations(mutations);
        RegionServerCallable<MultiRowMutationProtos.MutateRowsResponse, MultiRowMutationProtos.MultiRowMutationService.BlockingInterface> callable = new RegionServerCallable<MultiRowMutationProtos.MutateRowsResponse, MultiRowMutationProtos.MultiRowMutationService.BlockingInterface>(connection, table.getName(), row, null){

            @Override
            protected MultiRowMutationProtos.MutateRowsResponse rpcCall() throws Exception {
                MultiRowMutationProtos.MutateRowsRequest.Builder builder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
                for (Mutation mutation : mutations) {
                    if (mutation instanceof Put) {
                        builder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, mutation));
                        continue;
                    }
                    if (mutation instanceof Delete) {
                        builder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, mutation));
                        continue;
                    }
                    throw new DoNotRetryIOException("multi in MetaEditor doesn't support " + mutation.getClass().getName());
                }
                HRegionLocation hrl = this.getLocation();
                HBaseProtos.RegionSpecifier region = ProtobufUtil.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, hrl.getRegion().getRegionName());
                builder.setRegion(region);
                return ((MultiRowMutationProtos.MultiRowMutationService.BlockingInterface)this.getStub()).mutateRows(null, builder.build());
            }

            @Override
            protected void setStubByServiceName(ServerName serviceName) throws IOException {
                CoprocessorRpcChannel channel = table.coprocessorService(this.getRow());
                this.setStub(MultiRowMutationProtos.MultiRowMutationService.newBlockingStub(channel));
            }
        };
        int writeTimeout = connection.getConfiguration().getInt("hbase.rpc.write.timeout", connection.getConfiguration().getInt("hbase.rpc.timeout", 60000));
        callable.prepare(false);
        callable.call(writeTimeout);
    }

    @VisibleForTesting
    public static void updateRegionLocation(Connection connection, RegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        MetaTableAccessor.updateLocation(connection, regionInfo, sn, openSeqNum, masterSystemTime);
    }

    private static void updateLocation(Connection connection, RegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        Put put = new Put(MetaTableAccessor.getMetaKeyForRegion(regionInfo), masterSystemTime);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        MetaTableAccessor.addLocation(put, sn, openSeqNum, regionInfo.getReplicaId());
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info("Updated row {} with server=", (Object)regionInfo.getRegionNameAsString(), (Object)sn);
    }

    public static void deleteRegion(Connection connection, RegionInfo regionInfo) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(regionInfo.getRegionName());
        delete.addFamily(MetaTableAccessor.getCatalogFamily(), time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info("Deleted " + regionInfo.getRegionNameAsString());
    }

    public static void deleteRegions(Connection connection, List<RegionInfo> regionsInfo) throws IOException {
        MetaTableAccessor.deleteRegions(connection, regionsInfo, EnvironmentEdgeManager.currentTime());
    }

    public static void deleteRegions(Connection connection, List<RegionInfo> regionsInfo, long ts) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(regionsInfo.size());
        for (RegionInfo hri : regionsInfo) {
            Delete e = new Delete(hri.getRegionName());
            e.addFamily(MetaTableAccessor.getCatalogFamily(), ts);
            deletes.add(e);
        }
        MetaTableAccessor.deleteFromMetaTable(connection, deletes);
        LOG.info("Deleted {} regions from META", (Object)regionsInfo.size());
        LOG.debug("Deleted regions: {}", regionsInfo);
    }

    public static void overwriteRegions(Connection connection, List<RegionInfo> regionInfos, int regionReplication) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        MetaTableAccessor.deleteRegions(connection, regionInfos, now);
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, now + 1L);
        LOG.info("Overwritten " + regionInfos.size() + " regions to Meta");
        LOG.debug("Overwritten regions: {} ", regionInfos);
    }

    public static void deleteMergeQualifiers(Connection connection, RegionInfo mergedRegion) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(mergedRegion.getRegionName());
        delete.addColumns(MetaTableAccessor.getCatalogFamily(), HConstants.MERGEA_QUALIFIER, time);
        delete.addColumns(MetaTableAccessor.getCatalogFamily(), HConstants.MERGEB_QUALIFIER, time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info("Deleted references in merged region " + mergedRegion.getRegionNameAsString() + ", qualifier=" + Bytes.toStringBinary(HConstants.MERGEA_QUALIFIER) + " and qualifier=" + Bytes.toStringBinary(HConstants.MERGEB_QUALIFIER));
    }

    public static Put addRegionInfo(Put p, RegionInfo hri) throws IOException {
        p.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(HConstants.REGIONINFO_QUALIFIER).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(hri)).build());
        return p;
    }

    public static Put addLocation(Put p, ServerName sn, long openSeqNum, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        return p.add(builder.clear().setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getServerColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(sn.getAddress().toString())).build()).add(builder.clear().setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getStartCodeColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(sn.getStartcode())).build()).add(builder.clear().setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    private static Put addEmptyLocation(Put p, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        return p.add(builder.clear().setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getServerColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).build()).add(builder.clear().setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getStartCodeColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).build()).add(builder.clear().setRow(p.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).build());
    }

    private static void debugLogMutations(List<? extends Mutation> mutations) throws IOException {
        if (!METALOG.isDebugEnabled()) {
            return;
        }
        for (Mutation mutation : mutations) {
            MetaTableAccessor.debugLogMutation(mutation);
        }
    }

    private static void debugLogMutation(Mutation p) throws IOException {
        METALOG.debug("{} {}", (Object)p.getClass().getSimpleName(), (Object)p.toJSON());
    }

    private static Put addSequenceNum(Put p, long openSeqNum, int replicaId) throws IOException {
        return p.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(MetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    static {
        int len = RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
        SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");
    }

    public static abstract class TableVisitorBase
    extends DefaultVisitorBase {
        private TableName tableName;

        public TableVisitorBase(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public final boolean visit(Result rowResult) throws IOException {
            RegionInfo info = MetaTableAccessor.getRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.getTable().equals(this.tableName)) {
                return false;
            }
            return super.visit(rowResult);
        }
    }

    public static abstract class DefaultVisitorBase
    implements Visitor {
        public abstract boolean visitInternal(Result var1) throws IOException;

        @Override
        public boolean visit(Result rowResult) throws IOException {
            RegionInfo info = MetaTableAccessor.getRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.visitInternal(rowResult);
            }
            return true;
        }
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            this.add(r);
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface CloseableVisitor
    extends Visitor,
    Closeable {
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }

    @InterfaceAudience.Private
    public static enum QueryType {
        ALL(HConstants.TABLE_FAMILY, HConstants.CATALOG_FAMILY),
        REGION(new byte[][]{HConstants.CATALOG_FAMILY}),
        TABLE(new byte[][]{HConstants.TABLE_FAMILY});

        private final byte[][] families;

        private QueryType(byte[] ... families) {
            this.families = families;
        }

        byte[][] getFamilies() {
            return this.families;
        }
    }
}

