/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractResponse;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.AsyncRequestFuture;
import org.apache.hadoop.hbase.client.BatchErrors;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.DelayingRunner;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.SingleResponse;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.htrace.core.Tracer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncRequestFutureImpl<CResult>
implements AsyncRequestFuture {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRequestFutureImpl.class);
    private RetryingTimeTracker tracker;
    private final Batch.Callback<CResult> callback;
    private final BatchErrors errors;
    private final ConnectionImplementation.ServerErrorTracker errorsByServer;
    private final ExecutorService pool;
    private final Set<CancellableRegionServerCallable> callsInProgress;
    private final TableName tableName;
    private final AtomicLong actionsInProgress = new AtomicLong(-1L);
    private final Object replicaResultLock = new Object();
    private final Object[] results;
    private final int[] replicaGetIndices;
    private final boolean hasAnyReplicaGets;
    private final long nonceGroup;
    private final CancellableRegionServerCallable currentCallable;
    private final int operationTimeout;
    private final int rpcTimeout;
    private final AsyncProcess asyncProcess;

    public AsyncRequestFutureImpl(AsyncProcessTask task, List<Action> actions, long nonceGroup, AsyncProcess asyncProcess) {
        this.pool = task.getPool();
        this.callback = task.getCallback();
        this.nonceGroup = nonceGroup;
        this.tableName = task.getTableName();
        this.actionsInProgress.set(actions.size());
        if (task.getResults() == null) {
            this.results = task.getNeedResults() ? new Object[actions.size()] : null;
        } else {
            if (task.getResults().length != actions.size()) {
                throw new AssertionError((Object)"results.length");
            }
            this.results = task.getResults();
            for (int i = 0; i != this.results.length; ++i) {
                this.results[i] = null;
            }
        }
        ArrayList<Integer> replicaGetIndices = null;
        boolean hasAnyReplicaGets = false;
        if (this.results != null) {
            boolean hasAnyNonReplicaReqs = false;
            int posInList = 0;
            for (Action action : actions) {
                boolean isReplicaGet = AsyncProcess.isReplicaGet(action.getAction());
                if (isReplicaGet) {
                    hasAnyReplicaGets = true;
                    if (hasAnyNonReplicaReqs) {
                        if (replicaGetIndices == null) {
                            replicaGetIndices = new ArrayList<Integer>(actions.size() - 1);
                        }
                        replicaGetIndices.add(posInList);
                    }
                } else if (!hasAnyNonReplicaReqs) {
                    hasAnyNonReplicaReqs = true;
                    if (posInList > 0) {
                        replicaGetIndices = new ArrayList(actions.size() - 1);
                        for (int i = 0; i < posInList; ++i) {
                            replicaGetIndices.add(i);
                        }
                    }
                }
                ++posInList;
            }
        }
        this.hasAnyReplicaGets = hasAnyReplicaGets;
        if (replicaGetIndices != null) {
            this.replicaGetIndices = new int[replicaGetIndices.size()];
            int i = 0;
            for (Integer el : replicaGetIndices) {
                this.replicaGetIndices[i++] = el;
            }
        } else {
            this.replicaGetIndices = null;
        }
        this.callsInProgress = !hasAnyReplicaGets ? null : Collections.newSetFromMap(new ConcurrentHashMap());
        this.asyncProcess = asyncProcess;
        this.errorsByServer = this.createServerErrorTracker();
        this.errors = new BatchErrors();
        this.operationTimeout = task.getOperationTimeout();
        this.rpcTimeout = task.getRpcTimeout();
        this.currentCallable = task.getCallable();
        if (task.getCallable() == null) {
            this.tracker = new RetryingTimeTracker().start();
        }
    }

    @VisibleForTesting
    protected Set<CancellableRegionServerCallable> getCallsInProgress() {
        return this.callsInProgress;
    }

    @VisibleForTesting
    SingleServerRequestRunnable createSingleServerRequest(MultiAction multiAction, int numAttempt, ServerName server, Set<CancellableRegionServerCallable> callsInProgress) {
        return new SingleServerRequestRunnable(multiAction, numAttempt, server, callsInProgress);
    }

    void groupAndSendMultiAction(List<Action> currentActions, int numAttempt) {
        boolean hasUnknown;
        byte[] regionName;
        HRegionLocation loc;
        HashMap<ServerName, MultiAction> actionsByServer = new HashMap<ServerName, MultiAction>();
        boolean isReplica = false;
        ArrayList<Action> unknownReplicaActions = null;
        for (Action action : currentActions) {
            boolean isReplicaAction;
            RegionLocations locs = this.findAllLocationsOrFail(action, true);
            if (locs == null) continue;
            boolean bl = isReplicaAction = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
            if (isReplica && !isReplicaAction) {
                throw new AssertionError((Object)"Replica and non-replica actions in the same retry");
            }
            isReplica = isReplicaAction;
            loc = locs.getRegionLocation(action.getReplicaId());
            if (loc == null || loc.getServerName() == null) {
                if (isReplica) {
                    if (unknownReplicaActions == null) {
                        unknownReplicaActions = new ArrayList<Action>(1);
                    }
                    unknownReplicaActions.add(action);
                    continue;
                }
                this.manageLocationError(action, null);
                continue;
            }
            regionName = loc.getRegionInfo().getRegionName();
            AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
        }
        boolean doStartReplica = numAttempt == 1 && !isReplica && this.hasAnyReplicaGets;
        boolean bl = hasUnknown = unknownReplicaActions != null && !unknownReplicaActions.isEmpty();
        if (!actionsByServer.isEmpty()) {
            this.sendMultiAction(actionsByServer, numAttempt, doStartReplica && !hasUnknown ? currentActions : null, numAttempt > 1 && !hasUnknown);
        }
        if (hasUnknown) {
            actionsByServer = new HashMap();
            for (Action action : unknownReplicaActions) {
                loc = this.getReplicaLocationOrFail(action);
                if (loc == null) continue;
                regionName = loc.getRegionInfo().getRegionName();
                AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
            }
            if (!actionsByServer.isEmpty()) {
                this.sendMultiAction(actionsByServer, numAttempt, doStartReplica ? currentActions : null, true);
            }
        }
    }

    private HRegionLocation getReplicaLocationOrFail(Action action) {
        int replicaId = action.getReplicaId();
        RegionLocations locs = this.findAllLocationsOrFail(action, true);
        if (locs == null) {
            return null;
        }
        HRegionLocation loc = locs.getRegionLocation(replicaId);
        if (loc == null || loc.getServerName() == null) {
            locs = this.findAllLocationsOrFail(action, false);
            if (locs == null) {
                return null;
            }
            loc = locs.getRegionLocation(replicaId);
        }
        if (loc == null || loc.getServerName() == null) {
            this.manageLocationError(action, null);
            return null;
        }
        return loc;
    }

    private void manageLocationError(Action action, Exception ex) {
        String msg = "Cannot get replica " + action.getReplicaId() + " location for " + action.getAction();
        LOG.error(msg);
        if (ex == null) {
            ex = new IOException(msg);
        }
        this.manageError(action.getOriginalIndex(), action.getAction(), Retry.NO_LOCATION_PROBLEM, ex, null);
    }

    private RegionLocations findAllLocationsOrFail(Action action, boolean useCache) {
        if (action.getAction() == null) {
            throw new IllegalArgumentException("#" + this.asyncProcess.id + ", row cannot be null");
        }
        RegionLocations loc = null;
        try {
            loc = this.asyncProcess.connection.locateRegion(this.tableName, action.getAction().getRow(), useCache, true, action.getReplicaId());
        }
        catch (IOException ex) {
            this.manageLocationError(action, ex);
        }
        return loc;
    }

    void sendMultiAction(Map<ServerName, MultiAction> actionsByServer, int numAttempt, List<Action> actionsForReplicaThread, boolean reuseThread) {
        int actionsRemaining = actionsByServer.size();
        for (Map.Entry<ServerName, MultiAction> e : actionsByServer.entrySet()) {
            MultiAction multiAction;
            ServerName server = e.getKey();
            Collection<Runnable> runnables = this.getNewMultiActionRunnable(server, multiAction = e.getValue(), numAttempt);
            if (runnables.size() > actionsRemaining) {
                actionsRemaining = runnables.size();
            }
            for (Runnable runnable : runnables) {
                if (--actionsRemaining == 0 && reuseThread && numAttempt % 15 != 0) {
                    runnable.run();
                    continue;
                }
                try {
                    this.pool.submit(runnable);
                }
                catch (Throwable t) {
                    if (t instanceof RejectedExecutionException) {
                        LOG.warn("id=" + this.asyncProcess.id + ", task rejected by pool. Unexpected. Server=" + server.getServerName(), t);
                    } else {
                        LOG.warn("Caught unexpected exception/error: ", t);
                    }
                    this.asyncProcess.decTaskCounters(multiAction.getRegions(), server);
                    this.receiveGlobalFailure(multiAction, server, numAttempt, t);
                }
            }
        }
        if (actionsForReplicaThread != null) {
            this.startWaitingForReplicaCalls(actionsForReplicaThread);
        }
    }

    private Collection<? extends Runnable> getNewMultiActionRunnable(ServerName server, MultiAction multiAction, int numAttempt) {
        if (this.asyncProcess.connection.getStatisticsTracker() == null) {
            if (this.asyncProcess.connection.getConnectionMetrics() != null) {
                this.asyncProcess.connection.getConnectionMetrics().incrNormalRunners();
            }
            this.asyncProcess.incTaskCounters(multiAction.getRegions(), server);
            SingleServerRequestRunnable runnable = this.createSingleServerRequest(multiAction, numAttempt, server, this.callsInProgress);
            Tracer tracer = Tracer.curThreadTracer();
            if (tracer == null) {
                return Collections.singletonList(runnable);
            }
            return Collections.singletonList(tracer.wrap((Runnable)runnable, "AsyncProcess.sendMultiAction"));
        }
        HashMap<Long, DelayingRunner> actions = new HashMap<Long, DelayingRunner>(multiAction.size());
        for (Map.Entry<byte[], List<Action>> e : multiAction.actions.entrySet()) {
            Long backoff = this.getBackoff(server, e.getKey());
            DelayingRunner runner = (DelayingRunner)actions.get(backoff);
            if (runner == null) {
                actions.put(backoff, new DelayingRunner(backoff, e));
                continue;
            }
            runner.add(e);
        }
        ArrayList<SingleServerRequestRunnable> toReturn = new ArrayList<SingleServerRequestRunnable>(actions.size());
        for (DelayingRunner runner : actions.values()) {
            this.asyncProcess.incTaskCounters(runner.getActions().getRegions(), server);
            String traceText = "AsyncProcess.sendMultiAction";
            Runnable runnable = this.createSingleServerRequest(runner.getActions(), numAttempt, server, this.callsInProgress);
            if (runner.getSleepTime() > 0L) {
                runner.setRunner(runnable);
                traceText = "AsyncProcess.clientBackoff.sendMultiAction";
                runnable = runner;
                if (this.asyncProcess.connection.getConnectionMetrics() != null) {
                    this.asyncProcess.connection.getConnectionMetrics().incrDelayRunners();
                    this.asyncProcess.connection.getConnectionMetrics().updateDelayInterval(runner.getSleepTime());
                }
            } else if (this.asyncProcess.connection.getConnectionMetrics() != null) {
                this.asyncProcess.connection.getConnectionMetrics().incrNormalRunners();
            }
            runnable = TraceUtil.wrap(runnable, traceText);
            toReturn.add((SingleServerRequestRunnable)runnable);
        }
        return toReturn;
    }

    private Long getBackoff(ServerName server, byte[] regionName) {
        ServerStatisticTracker tracker = this.asyncProcess.connection.getStatisticsTracker();
        ServerStatistics stats = tracker.getStats(server);
        return this.asyncProcess.connection.getBackoffPolicy().getBackoffTime(server, regionName, stats);
    }

    private void startWaitingForReplicaCalls(List<Action> actionsForReplicaThread) {
        long startTime = EnvironmentEdgeManager.currentTime();
        ReplicaCallIssuingRunnable replicaRunnable = new ReplicaCallIssuingRunnable(actionsForReplicaThread, startTime);
        if (this.asyncProcess.primaryCallTimeoutMicroseconds == 0L) {
            replicaRunnable.run();
        } else {
            try {
                this.pool.submit(replicaRunnable);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("id=" + this.asyncProcess.id + " replica task rejected by pool; no replica calls", (Throwable)ree);
            }
        }
    }

    Retry manageError(int originalIndex, Row row, Retry canRetry, Throwable throwable, ServerName server) {
        if (canRetry == Retry.YES && throwable != null && throwable instanceof DoNotRetryIOException) {
            canRetry = Retry.NO_NOT_RETRIABLE;
        }
        if (canRetry != Retry.YES) {
            this.setError(originalIndex, row, throwable, server);
        } else if (this.isActionComplete(originalIndex, row)) {
            canRetry = Retry.NO_OTHER_SUCCEEDED;
        }
        return canRetry;
    }

    private void receiveGlobalFailure(MultiAction rsActions, ServerName server, int numAttempt, Throwable t) {
        this.errorsByServer.reportServerError(server);
        Retry canRetry = this.errorsByServer.canTryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
        this.cleanServerCache(server, t);
        int failed = 0;
        int stopped = 0;
        ArrayList<Action> toReplay = new ArrayList<Action>();
        for (Map.Entry<byte[], List<Action>> e : rsActions.actions.entrySet()) {
            byte[] regionName = e.getKey();
            byte[] row = e.getValue().get(0).getAction().getRow();
            this.updateCachedLocations(server, regionName, row, ClientExceptionsUtil.isMetaClearingException(t) ? null : t);
            for (Action action : e.getValue()) {
                Retry retry = this.manageError(action.getOriginalIndex(), action.getAction(), canRetry, t, server);
                if (retry == Retry.YES) {
                    toReplay.add(action);
                    continue;
                }
                if (retry == Retry.NO_OTHER_SUCCEEDED) {
                    ++stopped;
                    continue;
                }
                ++failed;
            }
        }
        if (toReplay.isEmpty()) {
            this.logNoResubmit(server, numAttempt, rsActions.size(), t, failed, stopped);
        } else {
            this.resubmit(server, toReplay, numAttempt, rsActions.size(), t);
        }
    }

    private void resubmit(ServerName oldServer, List<Action> toReplay, int numAttempt, int failureCount, Throwable throwable) {
        int nextAttemptNumber;
        boolean retryImmediately = throwable instanceof RetryImmediatelyException;
        int n = nextAttemptNumber = retryImmediately ? numAttempt : numAttempt + 1;
        long backOffTime = retryImmediately ? 0L : (throwable instanceof CallQueueTooBigException ? this.errorsByServer.calculateBackoffTime(oldServer, this.asyncProcess.pauseForCQTBE) : this.errorsByServer.calculateBackoffTime(oldServer, this.asyncProcess.pause));
        if (numAttempt > this.asyncProcess.startLogErrorsCnt) {
            LOG.info(this.createLog(numAttempt, failureCount, toReplay.size(), oldServer, throwable, backOffTime, true, null, -1, -1));
        }
        try {
            if (backOffTime > 0L) {
                Thread.sleep(backOffTime);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("#" + this.asyncProcess.id + ", not sent: " + toReplay.size() + " operations, " + oldServer, (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        this.groupAndSendMultiAction(toReplay, nextAttemptNumber);
    }

    private void logNoResubmit(ServerName oldServer, int numAttempt, int failureCount, Throwable throwable, int failed, int stopped) {
        if (failureCount != 0 || numAttempt > this.asyncProcess.startLogErrorsCnt + 1) {
            String timeStr = new Date(this.errorsByServer.getStartTrackingTime()).toString();
            String logMessage = this.createLog(numAttempt, failureCount, 0, oldServer, throwable, -1L, false, timeStr, failed, stopped);
            if (failed != 0) {
                LOG.warn(logMessage);
            } else {
                LOG.info(logMessage);
            }
        }
    }

    private void receiveMultiAction(MultiAction multiAction, ServerName server, MultiResponse responses, int numAttempt) {
        assert (responses != null);
        Map<byte[], MultiResponse.RegionResult> results = responses.getResults();
        this.updateStats(server, results);
        ArrayList<Action> toReplay = new ArrayList<Action>();
        Throwable lastException = null;
        int failureCount = 0;
        int failed = 0;
        int stopped = 0;
        Retry retry = null;
        for (Map.Entry<byte[], List<Action>> regionEntry : multiAction.actions.entrySet()) {
            byte[] regionName = regionEntry.getKey();
            Throwable regionException = responses.getExceptions().get(regionName);
            this.cleanServerCache(server, regionException);
            Map regionResults = results.containsKey(regionName) ? results.get((Object)regionName).result : Collections.emptyMap();
            boolean regionFailureRegistered = false;
            for (Action sentAction : regionEntry.getValue()) {
                Object result = regionResults.get(sentAction.getOriginalIndex());
                if (result == null) {
                    if (regionException == null) {
                        LOG.error("Server sent us neither results nor exceptions for " + Bytes.toStringBinary(regionName) + ", numAttempt:" + numAttempt);
                        regionException = new RuntimeException("Invalid response");
                    }
                    result = regionException;
                }
                if (result instanceof Throwable) {
                    Throwable actionException = (Throwable)result;
                    Row row = sentAction.getAction();
                    Throwable throwable = lastException = regionException != null ? regionException : ClientExceptionsUtil.findException(actionException);
                    if (!regionFailureRegistered) {
                        regionFailureRegistered = true;
                        this.updateCachedLocations(server, regionName, row.getRow(), actionException);
                    }
                    if (retry == null) {
                        this.errorsByServer.reportServerError(server);
                        retry = this.errorsByServer.canTryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
                    }
                    ++failureCount;
                    switch (this.manageError(sentAction.getOriginalIndex(), row, retry, actionException, server)) {
                        case YES: {
                            toReplay.add(sentAction);
                            break;
                        }
                        case NO_OTHER_SUCCEEDED: {
                            ++stopped;
                            break;
                        }
                        default: {
                            ++failed;
                            break;
                        }
                    }
                    continue;
                }
                this.invokeCallBack(regionName, sentAction.getAction().getRow(), result);
                this.setResult(sentAction, result);
            }
        }
        if (toReplay.isEmpty()) {
            this.logNoResubmit(server, numAttempt, failureCount, lastException, failed, stopped);
        } else {
            this.resubmit(server, toReplay, numAttempt, failureCount, lastException);
        }
    }

    private void updateCachedLocations(ServerName server, byte[] regionName, byte[] row, Throwable rowException) {
        if (this.tableName == null) {
            return;
        }
        try {
            this.asyncProcess.connection.updateCachedLocations(this.tableName, regionName, row, rowException, server);
        }
        catch (Throwable ex) {
            LOG.error("Couldn't update cached region locations: " + ex);
        }
    }

    private void invokeCallBack(byte[] regionName, byte[] row, CResult result) {
        if (this.callback != null) {
            try {
                this.callback.update(regionName, row, result);
            }
            catch (Throwable t) {
                LOG.error("User callback threw an exception for " + Bytes.toStringBinary(regionName) + ", ignoring", t);
            }
        }
    }

    private void cleanServerCache(ServerName server, Throwable regionException) {
        if (this.tableName == null && ClientExceptionsUtil.isMetaClearingException(regionException)) {
            this.asyncProcess.connection.clearCaches(server);
        }
    }

    @VisibleForTesting
    protected void updateStats(ServerName server, Map<byte[], MultiResponse.RegionResult> results) {
        boolean stats;
        boolean metrics = this.asyncProcess.connection.getConnectionMetrics() != null;
        boolean bl = stats = this.asyncProcess.connection.getStatisticsTracker() != null;
        if (!stats && !metrics) {
            return;
        }
        for (Map.Entry<byte[], MultiResponse.RegionResult> regionStats : results.entrySet()) {
            byte[] regionName = regionStats.getKey();
            ClientProtos.RegionLoadStats stat = regionStats.getValue().getStat();
            if (stat == null) {
                LOG.error("No ClientProtos.RegionLoadStats found for server=" + server + ", region=" + Bytes.toStringBinary(regionName));
                continue;
            }
            RegionLoadStats regionLoadstats = ProtobufUtil.createRegionLoadStats(stat);
            ResultStatsUtil.updateStats(this.asyncProcess.connection.getStatisticsTracker(), server, regionName, regionLoadstats);
            ResultStatsUtil.updateStats(this.asyncProcess.connection.getConnectionMetrics(), server, regionName, regionLoadstats);
        }
    }

    private String createLog(int numAttempt, int failureCount, int replaySize, ServerName sn, Throwable error, long backOffTime, boolean willRetry, String startTime, int failed, int stopped) {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(this.asyncProcess.id).append(", table=").append(this.tableName).append(", ").append("attempt=").append(numAttempt).append("/").append(this.asyncProcess.numTries).append(", ");
        if (failureCount > 0 || error != null) {
            sb.append("failed=").append(failureCount).append("ops").append(", last exception=").append(error == null ? "null" : error);
        } else {
            sb.append("succeeded");
        }
        sb.append(" on ").append(sn).append(", tracking started ").append(startTime);
        if (willRetry) {
            sb.append(", retrying after=").append(backOffTime).append("ms").append(", replay=").append(replaySize).append("ops");
        } else if (failureCount > 0) {
            if (stopped > 0) {
                sb.append("; not retrying ").append(stopped).append(" due to success from other replica");
            }
            if (failed > 0) {
                sb.append("; not retrying ").append(failed).append(" - final failure");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(Action action, Object result) {
        if (result == null) {
            throw new RuntimeException("Result cannot be null");
        }
        ReplicaResultState state = null;
        boolean isStale = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
        int index = action.getOriginalIndex();
        if (this.results == null) {
            this.decActionCounter(index);
            return;
        }
        state = this.trySetResultSimple(index, action.getAction(), false, result, null, isStale);
        if (state == null) {
            return;
        }
        Object object = state;
        synchronized (object) {
            if (state.callCount == 0) {
                return;
            }
            state.callCount = 0;
        }
        object = this.replicaResultLock;
        synchronized (object) {
            if (this.results[index] != state) {
                throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
            }
            this.updateResult(index, result);
        }
        this.decActionCounter(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setError(int index, Row row, Throwable throwable, ServerName server) {
        ReplicaResultState state = null;
        if (this.results == null) {
            this.errors.add(throwable, row, server);
            this.decActionCounter(index);
            return;
        }
        state = this.trySetResultSimple(index, row, true, throwable, server, false);
        if (state == null) {
            return;
        }
        BatchErrors target = null;
        boolean isActionDone = false;
        Object object = state;
        synchronized (object) {
            switch (state.callCount) {
                case 0: {
                    return;
                }
                case 1: {
                    target = this.errors;
                    isActionDone = true;
                    break;
                }
                default: {
                    assert (state.callCount > 1);
                    if (state.replicaErrors == null) {
                        state.replicaErrors = new BatchErrors();
                    }
                    target = state.replicaErrors;
                }
            }
            --state.callCount;
        }
        target.add(throwable, row, server);
        if (isActionDone) {
            if (state.replicaErrors != null) {
                this.errors.merge(state.replicaErrors);
            }
            object = this.replicaResultLock;
            synchronized (object) {
                if (this.results[index] != state) {
                    throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
                }
                this.updateResult(index, throwable);
            }
            this.decActionCounter(index);
        }
    }

    private boolean isActionComplete(int index, Row row) {
        if (!AsyncProcess.isReplicaGet(row)) {
            return false;
        }
        Object resObj = this.results[index];
        return resObj != null && (!(resObj instanceof ReplicaResultState) || ((ReplicaResultState)resObj).callCount == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicaResultState trySetResultSimple(int index, Row row, boolean isError, Object result, ServerName server, boolean isFromReplica) {
        ReplicaResultState rrs;
        Object resObj = null;
        if (!AsyncProcess.isReplicaGet(row)) {
            if (isFromReplica) {
                throw new AssertionError((Object)("Unexpected stale result for " + row));
            }
            this.updateResult(index, result);
        } else {
            Object object = this.replicaResultLock;
            synchronized (object) {
                resObj = this.results[index];
                if (resObj == null) {
                    if (isFromReplica) {
                        throw new AssertionError((Object)("Unexpected stale result for " + row));
                    }
                    this.updateResult(index, result);
                }
            }
        }
        ReplicaResultState replicaResultState = rrs = resObj instanceof ReplicaResultState ? (ReplicaResultState)resObj : null;
        if (rrs == null && isError) {
            this.errors.add((Throwable)result, row, server);
        }
        if (resObj == null) {
            this.decActionCounter(index);
            return null;
        }
        return rrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decActionCounter(int index) {
        long actionsRemaining = this.actionsInProgress.decrementAndGet();
        if (actionsRemaining < 0L) {
            String error = this.buildDetailedErrorMsg("Incorrect actions in progress", index);
            throw new AssertionError((Object)error);
        }
        if (actionsRemaining == 0L) {
            AtomicLong atomicLong = this.actionsInProgress;
            synchronized (atomicLong) {
                this.actionsInProgress.notifyAll();
            }
        }
    }

    private String buildDetailedErrorMsg(String string, int index) {
        int i;
        StringBuilder error = new StringBuilder(128);
        error.append(string).append("; called for ").append(index).append(", actionsInProgress ").append(this.actionsInProgress.get()).append("; replica gets: ");
        if (this.replicaGetIndices != null) {
            for (i = 0; i < this.replicaGetIndices.length; ++i) {
                error.append(this.replicaGetIndices[i]).append(", ");
            }
        } else {
            error.append(this.hasAnyReplicaGets ? "all" : "none");
        }
        error.append("; results ");
        if (this.results != null) {
            for (i = 0; i < this.results.length; ++i) {
                Object o = this.results[i];
                error.append(o == null ? "null" : o.toString()).append(", ");
            }
        }
        return error.toString();
    }

    @Override
    public void waitUntilDone() throws InterruptedIOException {
        try {
            this.waitUntilDone(Long.MAX_VALUE);
        }
        catch (InterruptedException iex) {
            throw new InterruptedIOException(iex.getMessage());
        }
        finally {
            if (this.callsInProgress != null) {
                for (CancellableRegionServerCallable clb : this.callsInProgress) {
                    clb.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilDone(long cutoff) throws InterruptedException {
        long currentInProgress;
        boolean hasWait = cutoff != Long.MAX_VALUE;
        long lastLog = EnvironmentEdgeManager.currentTime();
        while (0L != (currentInProgress = this.actionsInProgress.get())) {
            long now = EnvironmentEdgeManager.currentTime();
            if (hasWait && now * 1000L > cutoff) {
                return false;
            }
            if (!hasWait && now > lastLog + 10000L) {
                lastLog = now;
                LOG.info("#" + this.asyncProcess.id + ", waiting for " + currentInProgress + "  actions to finish on table: " + this.tableName);
            }
            AtomicLong atomicLong = this.actionsInProgress;
            synchronized (atomicLong) {
                if (this.actionsInProgress.get() == 0L) {
                    break;
                }
                if (!hasWait) {
                    this.actionsInProgress.wait(10L);
                } else {
                    long waitMicroSecond = Math.min(100000L, cutoff - now * 1000L);
                    TimeUnit.MICROSECONDS.timedWait(this.actionsInProgress, waitMicroSecond);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hasError() {
        return this.errors.hasErrors();
    }

    @Override
    public List<? extends Row> getFailedOperations() {
        return this.errors.actions;
    }

    @Override
    public RetriesExhaustedWithDetailsException getErrors() {
        return this.errors.makeException(this.asyncProcess.logBatchErrorDetails);
    }

    @Override
    public Object[] getResults() throws InterruptedIOException {
        this.waitUntilDone();
        return this.results;
    }

    private ConnectionImplementation.ServerErrorTracker createServerErrorTracker() {
        return new ConnectionImplementation.ServerErrorTracker(this.asyncProcess.serverTrackerTimeout, this.asyncProcess.numTries);
    }

    private MultiServerCallable createCallable(ServerName server, TableName tableName, MultiAction multi) {
        return new MultiServerCallable(this.asyncProcess.connection, tableName, server, multi, this.asyncProcess.rpcFactory.newController(), this.rpcTimeout, this.tracker, multi.getPriority());
    }

    private void updateResult(int index, Object result) {
        Object current = this.results[index];
        if (current != null && LOG.isDebugEnabled()) {
            LOG.debug("The result is assigned repeatedly! current:" + current + ", new:" + result);
        }
        this.results[index] = result;
    }

    @VisibleForTesting
    long getNumberOfActionsInProgress() {
        return this.actionsInProgress.get();
    }

    private static class ReplicaResultState {
        int callCount;
        BatchErrors replicaErrors = null;

        public ReplicaResultState(int callCount) {
            this.callCount = callCount;
        }

        public String toString() {
            return "[call count " + this.callCount + "; errors " + this.replicaErrors + "]";
        }
    }

    public static enum Retry {
        YES,
        NO_LOCATION_PROBLEM,
        NO_NOT_RETRIABLE,
        NO_RETRIES_EXHAUSTED,
        NO_OTHER_SUCCEEDED;

    }

    @VisibleForTesting
    final class SingleServerRequestRunnable
    implements Runnable {
        private final MultiAction multiAction;
        private final int numAttempt;
        private final ServerName server;
        private final Set<CancellableRegionServerCallable> callsInProgress;

        @VisibleForTesting
        SingleServerRequestRunnable(MultiAction multiAction, int numAttempt, ServerName server, Set<CancellableRegionServerCallable> callsInProgress) {
            this.multiAction = multiAction;
            this.numAttempt = numAttempt;
            this.server = server;
            this.callsInProgress = callsInProgress;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block19: {
                AbstractResponse res = null;
                CancellableRegionServerCallable callable = AsyncRequestFutureImpl.this.currentCallable;
                try {
                    if (callable == null) {
                        callable = AsyncRequestFutureImpl.this.createCallable(this.server, AsyncRequestFutureImpl.this.tableName, this.multiAction);
                    }
                    RpcRetryingCaller<AbstractResponse> caller = AsyncRequestFutureImpl.this.asyncProcess.createCaller(callable, AsyncRequestFutureImpl.this.rpcTimeout);
                    try {
                        if (this.callsInProgress != null) {
                            this.callsInProgress.add(callable);
                        }
                        if ((res = caller.callWithoutRetries(callable, AsyncRequestFutureImpl.this.operationTimeout)) == null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        AsyncRequestFutureImpl.this.receiveGlobalFailure(this.multiAction, this.server, this.numAttempt, e);
                        return;
                    }
                    catch (Throwable t) {
                        block18: {
                            LOG.error("id=" + ((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).asyncProcess.id + ", caught throwable. Unexpected. Retrying. Server=" + this.server + ", tableName=" + AsyncRequestFutureImpl.this.tableName, t);
                            AsyncRequestFutureImpl.this.receiveGlobalFailure(this.multiAction, this.server, this.numAttempt, t);
                            AsyncRequestFutureImpl.this.asyncProcess.decTaskCounters(this.multiAction.getRegions(), this.server);
                            if (this.callsInProgress == null || callable == null || res == null) break block18;
                            this.callsInProgress.remove(callable);
                        }
                        return;
                    }
                    if (res.type() == AbstractResponse.ResponseType.MULTI) {
                        AsyncRequestFutureImpl.this.receiveMultiAction(this.multiAction, this.server, (MultiResponse)res, this.numAttempt);
                    } else {
                        if (AsyncRequestFutureImpl.this.results != null) {
                            SingleResponse singleResponse = (SingleResponse)res;
                            AsyncRequestFutureImpl.this.updateResult(0, singleResponse.getEntry());
                        }
                        AsyncRequestFutureImpl.this.decActionCounter(1);
                    }
                    break block19;
                    {
                        catch (Throwable t) {
                            LOG.error("id=" + ((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).asyncProcess.id + " error for " + AsyncRequestFutureImpl.this.tableName + " processing " + this.server, t);
                            throw new RuntimeException(t);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    AsyncRequestFutureImpl.this.asyncProcess.decTaskCounters(this.multiAction.getRegions(), this.server);
                    if (this.callsInProgress != null && callable != null && res != null) {
                        this.callsInProgress.remove(callable);
                    }
                }
            }
        }
    }

    private final class ReplicaCallIssuingRunnable
    implements Runnable {
        private final long startTime;
        private final List<Action> initialActions;

        public ReplicaCallIssuingRunnable(List<Action> initialActions, long startTime) {
            this.initialActions = initialActions;
            this.startTime = startTime;
        }

        @Override
        public void run() {
            boolean done = false;
            if (((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).asyncProcess.primaryCallTimeoutMicroseconds > 0L) {
                try {
                    done = AsyncRequestFutureImpl.this.waitUntilDone(this.startTime * 1000L + ((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).asyncProcess.primaryCallTimeoutMicroseconds);
                }
                catch (InterruptedException ex) {
                    LOG.error("Replica thread interrupted - no replica calls {}", (Object)ex.getMessage());
                    return;
                }
            }
            if (done) {
                return;
            }
            HashMap<ServerName, MultiAction> actionsByServer = new HashMap<ServerName, MultiAction>();
            ArrayList<Action> unknownLocActions = new ArrayList<Action>();
            if (AsyncRequestFutureImpl.this.replicaGetIndices == null) {
                for (int i = 0; i < AsyncRequestFutureImpl.this.results.length; ++i) {
                    this.addReplicaActions(i, actionsByServer, unknownLocActions);
                }
            } else {
                for (int replicaGetIndice : AsyncRequestFutureImpl.this.replicaGetIndices) {
                    this.addReplicaActions(replicaGetIndice, actionsByServer, unknownLocActions);
                }
            }
            if (!actionsByServer.isEmpty()) {
                AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, unknownLocActions.isEmpty());
            }
            if (!unknownLocActions.isEmpty()) {
                actionsByServer = new HashMap();
                for (Action action : unknownLocActions) {
                    this.addReplicaActionsAgain(action, actionsByServer);
                }
                if (!actionsByServer.isEmpty()) {
                    AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addReplicaActions(int index, Map<ServerName, MultiAction> actionsByServer, List<Action> unknownReplicaActions) {
            if (AsyncRequestFutureImpl.this.results[index] != null) {
                return;
            }
            Action action = this.initialActions.get(index);
            RegionLocations loc = AsyncRequestFutureImpl.this.findAllLocationsOrFail(action, true);
            if (loc == null) {
                return;
            }
            HRegionLocation[] locs = loc.getRegionLocations();
            if (locs.length == 1) {
                LOG.warn("No replicas found for {}", (Object)action.getAction());
                return;
            }
            Object object = AsyncRequestFutureImpl.this.replicaResultLock;
            synchronized (object) {
                if (AsyncRequestFutureImpl.this.results[index] != null) {
                    return;
                }
                AsyncRequestFutureImpl.this.updateResult(index, new ReplicaResultState(locs.length));
            }
            for (int i = 1; i < locs.length; ++i) {
                Action replicaAction = new Action(action, i);
                if (locs[i] != null) {
                    AsyncRequestFutureImpl.this.asyncProcess;
                    AsyncProcess.addAction(locs[i].getServerName(), locs[i].getRegionInfo().getRegionName(), replicaAction, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
                    continue;
                }
                unknownReplicaActions.add(replicaAction);
            }
        }

        private void addReplicaActionsAgain(Action action, Map<ServerName, MultiAction> actionsByServer) {
            if (action.getReplicaId() == 0) {
                throw new AssertionError((Object)"Cannot have default replica here");
            }
            HRegionLocation loc = AsyncRequestFutureImpl.this.getReplicaLocationOrFail(action);
            if (loc == null) {
                return;
            }
            AsyncRequestFutureImpl.this.asyncProcess;
            AsyncProcess.addAction(loc.getServerName(), loc.getRegionInfo().getRegionName(), action, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
        }
    }
}

