/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MetricRegistriesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistries.class);
    private static final String defaultClass = "org.apache.hadoop.hbase.metrics.impl.MetricRegistriesImpl";

    private MetricRegistriesLoader() {
    }

    public static MetricRegistries load() {
        List<MetricRegistries> availableImplementations = MetricRegistriesLoader.getDefinedImplemantations();
        return MetricRegistriesLoader.load(availableImplementations);
    }

    @VisibleForTesting
    static MetricRegistries load(List<MetricRegistries> availableImplementations) {
        if (availableImplementations.size() == 1) {
            MetricRegistries impl = availableImplementations.get(0);
            LOG.info("Loaded MetricRegistries " + impl.getClass());
            return impl;
        }
        if (availableImplementations.isEmpty()) {
            try {
                return (MetricRegistries)ReflectionUtils.newInstance(Class.forName(defaultClass), new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (MetricRegistries factory : availableImplementations) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(factory.getClass());
        }
        LOG.warn("Found multiple MetricRegistries implementations: " + sb + ". Using first found implementation: " + availableImplementations.get(0));
        return availableImplementations.get(0);
    }

    private static List<MetricRegistries> getDefinedImplemantations() {
        ServiceLoader<MetricRegistries> loader = ServiceLoader.load(MetricRegistries.class);
        ArrayList<MetricRegistries> availableFactories = new ArrayList<MetricRegistries>();
        for (MetricRegistries impl : loader) {
            availableFactories.add(impl);
        }
        return availableFactories;
    }
}

