/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Comparator;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hbase.thirdparty.com.google.common.primitives.Longs;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BBKVComparator
implements Comparator {
    protected static final Logger LOG = LoggerFactory.getLogger(BBKVComparator.class);
    private final Comparator fallback;

    public BBKVComparator(Comparator fallback) {
        this.fallback = fallback;
    }

    public int compare(Object l, Object r) {
        if (l instanceof ByteBufferKeyValue && r instanceof ByteBufferKeyValue) {
            return BBKVComparator.compare((ByteBufferKeyValue)l, (ByteBufferKeyValue)r);
        }
        return this.fallback.compare((Cell)l, (Cell)r);
    }

    static final int compare(ByteBufferKeyValue left, ByteBufferKeyValue right) {
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int diff = ByteBufferUtils.compareTo(left.getRowByteBuffer(), left.getRowPosition(), (int)leftRowLength, right.getRowByteBuffer(), right.getRowPosition(), (int)rightRowLength);
        if (diff != 0) {
            return diff;
        }
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        byte leftType = left.getTypeByte(leftKeyLength);
        if (leftFamilyLength + leftQualifierLength == 0 && leftType == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        byte rightType = right.getTypeByte(rightKeyLength);
        if (rightFamilyLength + rightQualifierLength == 0 && rightType == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        int leftFamilyPosition = left.getFamilyPosition(leftFamilyLengthPosition);
        int rightFamilyPosition = right.getFamilyPosition(rightFamilyLengthPosition);
        diff = ByteBufferUtils.compareTo(left.getFamilyByteBuffer(), leftFamilyPosition, (int)leftFamilyLength, right.getFamilyByteBuffer(), rightFamilyPosition, (int)rightFamilyLength);
        if (diff != 0) {
            return diff;
        }
        diff = ByteBufferUtils.compareTo(left.getQualifierByteBuffer(), left.getQualifierPosition(leftFamilyPosition, leftFamilyLength), leftQualifierLength, right.getQualifierByteBuffer(), right.getQualifierPosition(rightFamilyPosition, rightFamilyLength), rightQualifierLength);
        if (diff != 0) {
            return diff;
        }
        diff = Long.compare(right.getTimestamp(rightKeyLength), left.getTimestamp(leftKeyLength));
        if (diff != 0) {
            return diff;
        }
        diff = (0xFF & rightType) - (0xFF & leftType);
        if (diff != 0) {
            return diff;
        }
        return Longs.compare(right.getSequenceId(), left.getSequenceId());
    }
}

