/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.net.InetAddresses;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ServerName
implements Comparable<ServerName>,
Serializable {
    private static final long serialVersionUID = 1367463982557264981L;
    private static final short VERSION = 0;
    static final byte[] VERSION_BYTES = Bytes.toBytes((short)0);
    public static final int NON_STARTCODE = -1;
    public static final String SERVERNAME_SEPARATOR = ",";
    public static final Pattern SERVERNAME_PATTERN = Pattern.compile("[^,]+,[\\d]+,[\\d]+$");
    public static final String UNKNOWN_SERVERNAME = "#unknown#";
    private final String servername;
    private final long startcode;
    private transient Address address;
    private byte[] bytes;
    public static final List<ServerName> EMPTY_SERVER_LIST = new ArrayList<ServerName>(0);

    protected ServerName(String hostname, int port, long startcode) {
        this(Address.fromParts(hostname, port), startcode);
    }

    private ServerName(Address address, long startcode) {
        this.address = address;
        this.startcode = startcode;
        this.servername = ServerName.getServerName(this.address.getHostname(), this.address.getPort(), startcode);
    }

    private ServerName(String serverName) {
        this(ServerName.parseHostname(serverName), ServerName.parsePort(serverName), ServerName.parseStartcode(serverName));
    }

    private ServerName(String hostAndPort, long startCode) {
        this(Address.fromString(hostAndPort), startCode);
    }

    @Deprecated
    static String getHostNameMinusDomain(String hostname) {
        if (InetAddresses.isInetAddress(hostname)) {
            return hostname;
        }
        String[] parts = hostname.split("\\.");
        if (parts == null || parts.length == 0) {
            return hostname;
        }
        return parts[0];
    }

    @Deprecated
    public static String parseHostname(String serverName) {
        if (serverName == null || serverName.length() <= 0) {
            throw new IllegalArgumentException("Passed hostname is null or empty");
        }
        if (!Character.isLetterOrDigit(serverName.charAt(0))) {
            throw new IllegalArgumentException("Bad passed hostname, serverName=" + serverName);
        }
        int index = serverName.indexOf(SERVERNAME_SEPARATOR);
        return serverName.substring(0, index);
    }

    @Deprecated
    public static int parsePort(String serverName) {
        String[] split = serverName.split(SERVERNAME_SEPARATOR);
        return Integer.parseInt(split[1]);
    }

    @Deprecated
    public static long parseStartcode(String serverName) {
        int index = serverName.lastIndexOf(SERVERNAME_SEPARATOR);
        return Long.parseLong(serverName.substring(index + 1));
    }

    public static ServerName valueOf(String hostname, int port, long startcode) {
        return new ServerName(hostname, port, startcode);
    }

    public static ServerName valueOf(String serverName) {
        return new ServerName(serverName);
    }

    public static ServerName valueOf(String hostAndPort, long startCode) {
        return new ServerName(hostAndPort, startCode);
    }

    public String toString() {
        return this.getServerName();
    }

    public String toShortString() {
        return Addressing.createHostAndPortStr(ServerName.getHostNameMinusDomain(this.address.getHostname()), this.address.getPort());
    }

    public synchronized byte[] getVersionedBytes() {
        if (this.bytes == null) {
            this.bytes = Bytes.add(VERSION_BYTES, Bytes.toBytes(this.getServerName()));
        }
        return this.bytes;
    }

    public String getServerName() {
        return this.servername;
    }

    public String getHostname() {
        return this.address.getHostname();
    }

    public String getHostnameLowerCase() {
        return this.address.getHostname().toLowerCase(Locale.ROOT);
    }

    public int getPort() {
        return this.address.getPort();
    }

    public long getStartcode() {
        return this.startcode;
    }

    @Deprecated
    static String getServerName(String hostName, int port, long startcode) {
        StringBuilder name = new StringBuilder(hostName.length() + 1 + 5 + 1 + 13);
        name.append(hostName.toLowerCase(Locale.ROOT));
        name.append(SERVERNAME_SEPARATOR);
        name.append(port);
        name.append(SERVERNAME_SEPARATOR);
        name.append(startcode);
        return name.toString();
    }

    @Deprecated
    public static String getServerName(String hostAndPort, long startcode) {
        int index = hostAndPort.indexOf(":");
        if (index <= 0) {
            throw new IllegalArgumentException("Expected <hostname> ':' <port>");
        }
        return ServerName.getServerName(hostAndPort.substring(0, index), Integer.parseInt(hostAndPort.substring(index + 1)), startcode);
    }

    @Deprecated
    public String getHostAndPort() {
        return this.address.toString();
    }

    public Address getAddress() {
        return this.address;
    }

    @Deprecated
    public static long getServerStartcodeFromServerName(String serverName) {
        int index = serverName.lastIndexOf(SERVERNAME_SEPARATOR);
        return Long.parseLong(serverName.substring(index + 1));
    }

    @Deprecated
    public static String getServerNameLessStartCode(String inServerName) {
        int index;
        if (inServerName != null && inServerName.length() > 0 && (index = inServerName.lastIndexOf(SERVERNAME_SEPARATOR)) > 0) {
            return inServerName.substring(0, index);
        }
        return inServerName;
    }

    @Override
    public int compareTo(ServerName other) {
        int compare;
        if (other == null) {
            return -1;
        }
        if (this.getHostname() == null) {
            if (other.getHostname() != null) {
                return 1;
            }
        } else {
            if (other.getHostname() == null) {
                return -1;
            }
            compare = this.getHostname().compareToIgnoreCase(other.getHostname());
            if (compare != 0) {
                return compare;
            }
        }
        if ((compare = this.getPort() - other.getPort()) != 0) {
            return compare;
        }
        return Long.compare(this.getStartcode(), other.getStartcode());
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerName)) {
            return false;
        }
        return this.compareTo((ServerName)o) == 0;
    }

    public static boolean isSameAddress(ServerName left, ServerName right) {
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return left.getHostname().compareToIgnoreCase(right.getHostname()) == 0 && left.getPort() == right.getPort();
    }

    public static ServerName parseVersionedServerName(byte[] versionedBytes) {
        short version = Bytes.toShort(versionedBytes);
        if (version == 0) {
            int length = versionedBytes.length - 2;
            return ServerName.valueOf(Bytes.toString(versionedBytes, 2, length));
        }
        return ServerName.valueOf(Bytes.toString(versionedBytes), -1L);
    }

    public static ServerName parseServerName(String str) {
        return SERVERNAME_PATTERN.matcher(str).matches() ? ServerName.valueOf(str) : ServerName.valueOf(str, -1L);
    }

    public static boolean isFullServerName(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return SERVERNAME_PATTERN.matcher(str).matches();
    }
}

