/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HRegionLocator
implements RegionLocator {
    private final TableName tableName;
    private final ClusterConnection connection;

    public HRegionLocator(TableName tableName, ClusterConnection connection) {
        this.connection = connection;
        this.tableName = tableName;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, reload);
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        TableName tableName = this.getName();
        List<Pair<RegionInfo, ServerName>> locations = MetaTableAccessor.getTableRegionsAndLocations(this.connection, tableName);
        ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>(locations.size());
        for (Pair<RegionInfo, ServerName> entry : locations) {
            regions.add(new HRegionLocation(entry.getFirst(), entry.getSecond()));
        }
        if (regions.size() > 0) {
            this.connection.cacheLocation(tableName, new RegionLocations(regions));
        }
        return regions;
    }

    @Override
    public byte[][] getStartKeys() throws IOException {
        return this.getStartEndKeys().getFirst();
    }

    @Override
    public byte[][] getEndKeys() throws IOException {
        return this.getStartEndKeys().getSecond();
    }

    @Override
    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getStartEndKeys(this.listRegionLocations());
    }

    @VisibleForTesting
    Pair<byte[][], byte[][]> getStartEndKeys(List<RegionLocations> regions) {
        byte[][] startKeyList = new byte[regions.size()][];
        byte[][] endKeyList = new byte[regions.size()][];
        for (int i = 0; i < regions.size(); ++i) {
            HRegionInfo region = regions.get(i).getRegionLocation().getRegionInfo();
            startKeyList[i] = region.getStartKey();
            endKeyList[i] = region.getEndKey();
        }
        return new Pair<byte[][], byte[][]>(startKeyList, endKeyList);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @VisibleForTesting
    List<RegionLocations> listRegionLocations() throws IOException {
        final ArrayList<RegionLocations> regions = new ArrayList<RegionLocations>();
        MetaTableAccessor.TableVisitorBase visitor = new MetaTableAccessor.TableVisitorBase(this.tableName){

            @Override
            public boolean visitInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                regions.add(locations);
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions(this.connection, visitor, this.tableName);
        return regions;
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }
}

