/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ConnectionFactory {
    public static final String HBASE_CLIENT_ASYNC_CONNECTION_IMPL = "hbase.client.async.connection.impl";

    protected ConnectionFactory() {
    }

    public static Connection createConnection() throws IOException {
        return ConnectionFactory.createConnection(HBaseConfiguration.create(), null, null);
    }

    public static Connection createConnection(Configuration conf) throws IOException {
        return ConnectionFactory.createConnection(conf, null, null);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        return ConnectionFactory.createConnection(conf, pool, null);
    }

    public static Connection createConnection(Configuration conf, User user) throws IOException {
        return ConnectionFactory.createConnection(conf, null, user);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        Class<?> clazz;
        if (user == null) {
            UserProvider provider = UserProvider.instantiate(conf);
            user = provider.getCurrent();
        }
        String className = conf.get("hbase.client.connection.impl", ConnectionImplementation.class.getName());
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class, ExecutorService.class, User.class);
            constructor.setAccessible(true);
            return (Connection)constructor.newInstance(conf, pool, user);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static CompletableFuture<AsyncConnection> createAsyncConnection() {
        return ConnectionFactory.createAsyncConnection(HBaseConfiguration.create());
    }

    public static CompletableFuture<AsyncConnection> createAsyncConnection(Configuration conf) {
        User user;
        try {
            user = UserProvider.instantiate(conf).getCurrent();
        }
        catch (IOException e) {
            CompletableFuture<AsyncConnection> future = new CompletableFuture<AsyncConnection>();
            future.completeExceptionally(e);
            return future;
        }
        return ConnectionFactory.createAsyncConnection(conf, user);
    }

    public static CompletableFuture<AsyncConnection> createAsyncConnection(Configuration conf, User user) {
        CompletableFuture<AsyncConnection> future = new CompletableFuture<AsyncConnection>();
        AsyncRegistry registry = AsyncRegistryFactory.getRegistry(conf);
        registry.getClusterId().whenComplete((clusterId, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (clusterId == null) {
                future.completeExceptionally(new IOException("clusterid came back null"));
                return;
            }
            Class<AsyncConnection> clazz = conf.getClass(HBASE_CLIENT_ASYNC_CONNECTION_IMPL, AsyncConnectionImpl.class, AsyncConnection.class);
            try {
                future.complete(ReflectionUtils.newInstance(clazz, conf, registry, clusterId, user));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

