/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface TableDescriptor {
    @InterfaceAudience.Private
    public static final Comparator<TableDescriptor> COMPARATOR = TableDescriptor.getComparator(ColumnFamilyDescriptor.COMPARATOR);
    @InterfaceAudience.Private
    public static final Comparator<TableDescriptor> COMPARATOR_IGNORE_REPLICATION = TableDescriptor.getComparator(ColumnFamilyDescriptor.COMPARATOR_IGNORE_REPLICATION);

    public static Comparator<TableDescriptor> getComparator(Comparator<ColumnFamilyDescriptor> cfComparator) {
        return (lhs, rhs) -> {
            int result = lhs.getTableName().compareTo(rhs.getTableName());
            if (result != 0) {
                return result;
            }
            List<ColumnFamilyDescriptor> lhsFamilies = Arrays.asList(lhs.getColumnFamilies());
            List<ColumnFamilyDescriptor> rhsFamilies = Arrays.asList(rhs.getColumnFamilies());
            result = Integer.compare(lhsFamilies.size(), rhsFamilies.size());
            if (result != 0) {
                return result;
            }
            Iterator it = lhsFamilies.iterator();
            Iterator it2 = rhsFamilies.iterator();
            while (it.hasNext()) {
                result = cfComparator.compare((ColumnFamilyDescriptor)it.next(), (ColumnFamilyDescriptor)it2.next());
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(lhs.getValues().hashCode(), rhs.getValues().hashCode());
        };
    }

    public int getColumnFamilyCount();

    public Collection<CoprocessorDescriptor> getCoprocessorDescriptors();

    @Deprecated
    default public Collection<String> getCoprocessors() {
        return this.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList());
    }

    public Durability getDurability();

    public ColumnFamilyDescriptor[] getColumnFamilies();

    public Set<byte[]> getColumnFamilyNames();

    public ColumnFamilyDescriptor getColumnFamily(byte[] var1);

    public String getFlushPolicyClassName();

    public long getMaxFileSize();

    public long getMemStoreFlushSize();

    public int getPriority();

    public int getRegionReplication();

    public String getRegionSplitPolicyClassName();

    public TableName getTableName();

    @Deprecated
    public String getOwnerString();

    public Bytes getValue(Bytes var1);

    public byte[] getValue(byte[] var1);

    public String getValue(String var1);

    public Map<Bytes, Bytes> getValues();

    public boolean hasCoprocessor(String var1);

    public boolean hasColumnFamily(byte[] var1);

    public boolean hasRegionMemStoreReplication();

    public boolean isCompactionEnabled();

    public boolean isMetaRegion();

    public boolean isMetaTable();

    public boolean isNormalizationEnabled();

    public boolean isReadOnly();

    default public boolean hasGlobalReplicationScope() {
        return Stream.of(this.getColumnFamilies()).anyMatch(cf -> cf.getScope() == 1);
    }

    default public boolean matchReplicationScope(boolean enabled) {
        boolean hasEnabled = false;
        boolean hasDisabled = false;
        for (ColumnFamilyDescriptor cf : this.getColumnFamilies()) {
            if (cf.getScope() != 1) {
                hasDisabled = true;
                continue;
            }
            hasEnabled = true;
        }
        if (hasEnabled && hasDisabled) {
            return false;
        }
        if (hasEnabled) {
            return enabled;
        }
        return !enabled;
    }
}

