/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReversedScannerCallable
extends ScannerCallable {
    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcFactory) {
        super(connection, tableName, scan, scanMetrics, rpcFactory);
    }

    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcFactory, int replicaId) {
        super(connection, tableName, scan, scanMetrics, rpcFactory, replicaId);
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (!this.instantiated || reload) {
            if (this.scan.includeStartRow() && !ConnectionUtils.isEmptyStartRow(this.getRow())) {
                RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(!reload, this.id, this.getConnection(), this.getTableName(), this.getRow());
                HRegionLocation hRegionLocation = this.location = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
                if (this.location == null || this.location.getServerName() == null) {
                    throw new IOException("Failed to find location, tableName=" + this.getTableName() + ", row=" + Bytes.toStringBinary(this.getRow()) + ", reload=" + reload);
                }
            } else {
                byte[] locateStartRow = ConnectionUtils.createCloseRowBefore(this.getRow());
                List<HRegionLocation> locatedRegions = this.locateRegionsInRange(locateStartRow, this.getRow(), reload);
                if (locatedRegions.isEmpty()) {
                    throw new DoNotRetryIOException("Does hbase:meta exist hole? Couldn't get regions for the range from " + Bytes.toStringBinary(locateStartRow) + " to " + Bytes.toStringBinary(this.getRow()));
                }
                this.location = locatedRegions.get(locatedRegions.size() - 1);
            }
            this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, this.isRegionServerRemote);
        }
    }

    private List<HRegionLocation> locateRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals(endKey, HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo(startKey, endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(startKey) + " > " + Bytes.toStringBinary(endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(!reload, this.id, this.getConnection(), this.getTableName(), currentKey);
            HRegionLocation hRegionLocation = regionLocation = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
            if (regionLocation == null || !regionLocation.getRegionInfo().containsRow(currentKey)) {
                throw new DoNotRetryIOException("Does hbase:meta exist hole? Locating row " + Bytes.toStringBinary(currentKey) + " returns incorrect region " + (regionLocation == null ? null : regionLocation.getRegionInfo()));
            }
            regionList.add(regionLocation);
        } while (!Bytes.equals(currentKey = regionLocation.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo(currentKey, endKey) < 0));
        return regionList;
    }

    @Override
    public ScannerCallable getScannerCallableForReplica(int id) {
        ReversedScannerCallable r = new ReversedScannerCallable(this.getConnection(), this.getTableName(), this.getScan(), this.scanMetrics, this.rpcControllerFactory, id);
        r.setCaching(this.getCaching());
        return r;
    }
}

