/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.shaded.net.minidev.json.JSONArray;
import org.apache.hadoop.hbase.shaded.net.minidev.json.JSONObject;
import org.apache.hadoop.hbase.shaded.net.minidev.json.parser.JSONParser;

public class JSONObjectUtils {
    public static JSONObject parse(String s) throws ParseException {
        Object o;
        try {
            o = new JSONParser(640).parse(s);
        }
        catch (org.apache.hadoop.hbase.shaded.net.minidev.json.parser.ParseException e) {
            throw new ParseException("Invalid JSON: " + e.getMessage(), 0);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static JSONObject parseJSONObject(String s) throws ParseException {
        return JSONObjectUtils.parse(s);
    }

    private static <T> T getGeneric(JSONObject o, String key, Class<T> clazz) throws ParseException {
        if (!o.containsKey((Object)key)) {
            throw new ParseException("Missing JSON object member with key \"" + key + "\"", 0);
        }
        if (o.get((Object)key) == null) {
            throw new ParseException("JSON object member with key \"" + key + "\" has null value", 0);
        }
        Object value = o.get((Object)key);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new ParseException("Unexpected type of JSON object member with key \"" + key + "\"", 0);
        }
        return (T)value;
    }

    public static boolean getBoolean(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, Boolean.class);
    }

    public static int getInt(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).intValue();
    }

    public static long getLong(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).longValue();
    }

    public static float getFloat(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).floatValue();
    }

    public static double getDouble(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, Number.class).doubleValue();
    }

    public static String getString(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, String.class);
    }

    public static URI getURI(JSONObject o, String key) throws ParseException {
        try {
            return new URI(JSONObjectUtils.getGeneric(o, key, String.class));
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public static JSONArray getJSONArray(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, JSONArray.class);
    }

    public static String[] getStringArray(JSONObject o, String key) throws ParseException {
        JSONArray jsonArray = JSONObjectUtils.getJSONArray(o, key);
        try {
            return (String[])jsonArray.toArray((Object[])new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ParseException("JSON object member with key \"" + key + "\" is not an array of strings", 0);
        }
    }

    public static List<String> getStringList(JSONObject o, String key) throws ParseException {
        String[] array = JSONObjectUtils.getStringArray(o, key);
        return Arrays.asList(array);
    }

    public static JSONObject getJSONObject(JSONObject o, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o, key, JSONObject.class);
    }

    private JSONObjectUtils() {
    }
}

