/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.Charsets;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.hadoop.record.compiler.CodeGenerator;
import org.apache.hadoop.record.compiler.JFile;
import org.apache.hadoop.record.compiler.JRecord;
import org.apache.hadoop.util.StringUtils;

class CGenerator
extends CodeGenerator {
    CGenerator() {
    }

    @Override
    void genCode(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, String destDir, ArrayList<String> options) throws IOException {
        name = new File(destDir, new File(name).getName()).getAbsolutePath();
        try (FileWriterWithEncoding cc = new FileWriterWithEncoding(name + ".c", Charsets.UTF_8);
             FileWriterWithEncoding hh = new FileWriterWithEncoding(name + ".h", Charsets.UTF_8);){
            ((Writer)hh).write("#ifndef __" + StringUtils.toUpperCase(name).replace('.', '_') + "__\n");
            ((Writer)hh).write("#define __" + StringUtils.toUpperCase(name).replace('.', '_') + "__\n");
            ((Writer)hh).write("#include \"recordio.h\"\n");
            Iterator<JFile> iter = ilist.iterator();
            while (iter.hasNext()) {
                ((Writer)hh).write("#include \"" + iter.next().getName() + ".h\"\n");
            }
            ((Writer)cc).write("#include \"" + name + ".h\"\n");
            ((Writer)hh).write("#endif //" + StringUtils.toUpperCase(name).replace('.', '_') + "__\n");
        }
    }
}

