/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.hadoop.hbase.Version;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)VersionInfo.class.getName());
    private static final int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return Version.version;
    }

    public static String getRevision() {
        return "8dc7de1c75ab615b8992b928150e8b476cb053e3";
    }

    public static String getDate() {
        return "Sun Sep 20 15:30:21 UTC 2020";
    }

    public static String getUser() {
        return "vjasani";
    }

    public static String getUrl() {
        return "git://fb6e52cd778c/home/vjasani/hbase-rm/output/hbase";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "0f276c1c4db750330be5a0597258c4ceab710813110e0926be2f7b164a76c61caea7524f0ef2ce3939bc5c035641e0995b1e33b911e066a5a982605312d0540f";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info(line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        String[] v1Comps = VersionInfo.getVersionComponents(v1);
        String[] v2Comps = VersionInfo.getVersionComponents(v2);
        int length = Math.max(v1Comps.length, v2Comps.length);
        for (int i = 0; i < length; ++i) {
            Integer vb;
            Integer va = i < v1Comps.length ? Integer.parseInt(v1Comps[i]) : 0;
            int compare = va.compareTo(vb = Integer.valueOf(i < v2Comps.length ? Integer.parseInt(v2Comps[i]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static String[] getVersionComponents(String version) {
        assert (version != null);
        String[] strComps = version.split("[\\.-]");
        assert (strComps.length > 0);
        String[] comps = new String[strComps.length];
        for (int i = 0; i < strComps.length; ++i) {
            comps[i] = StringUtils.isNumeric(strComps[i]) ? strComps[i] : (StringUtils.isEmpty(strComps[i]) ? String.valueOf(100000) : ("SNAPSHOT".equals(strComps[i]) ? "-1" : ("beta".equals(strComps[i]) ? "-2" : ("alpha".equals(strComps[i]) ? "-3" : "-4"))));
        }
        return comps;
    }

    public static int getMajorVersion(String version) {
        return Integer.parseInt(version.split("\\.")[0]);
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

