/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hbase.thirdparty.com.google.gson.GsonBuilder;
import org.apache.hbase.thirdparty.com.google.gson.LongSerializationPolicy;
import org.apache.hbase.thirdparty.com.google.gson.TypeAdapter;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonReader;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonWriter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class GsonUtil {
    private GsonUtil() {
    }

    public static GsonBuilder createGson() {
        return new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).registerTypeAdapter((Type)((Object)LongAdder.class), new TypeAdapter<LongAdder>(){

            @Override
            public void write(JsonWriter out, LongAdder value) throws IOException {
                out.value(value.longValue());
            }

            @Override
            public LongAdder read(JsonReader in) throws IOException {
                LongAdder value = new LongAdder();
                value.add(in.nextLong());
                return value;
            }
        });
    }
}

