/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.GssSaslAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class GssSaslClientAuthenticationProvider
extends GssSaslAuthenticationProvider
implements SaslClientAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GssSaslClientAuthenticationProvider.class);

    String getServerPrincipal(Configuration conf, SecurityInfo securityInfo, InetAddress server) throws IOException {
        String serverKey = securityInfo.getServerPrincipal();
        if (serverKey == null) {
            throw new IllegalArgumentException("Can't obtain server Kerberos config key from SecurityInfo");
        }
        return SecurityUtil.getServerPrincipal(conf.get(serverKey), server.getCanonicalHostName().toLowerCase());
    }

    @Override
    public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
        String serverPrincipal = this.getServerPrincipal(conf, securityInfo, serverAddr);
        LOG.debug("Setting up Kerberos RPC to server={}", (Object)serverPrincipal);
        String[] names = SaslUtil.splitKerberosName(serverPrincipal);
        if (names.length != 3) {
            throw new IOException("Kerberos principal '" + serverPrincipal + "' does not have the expected format");
        }
        return Sasl.createSaslClient(new String[]{this.getSaslAuthMethod().getSaslMechanism()}, null, names[0], names[1], saslProps, null);
    }

    @Override
    public RPCProtos.UserInformation getUserInfo(User user) {
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        userInfoPB.setEffectiveUser(user.getUGI().getUserName());
        return userInfoPB.build();
    }

    @Override
    public boolean canRetry() {
        return true;
    }

    @Override
    public void relogin() throws IOException {
        if (UserGroupInformation.isLoginKeytabBased()) {
            UserGroupInformation.getLoginUser().reloginFromKeytab();
        } else {
            UserGroupInformation.getLoginUser().reloginFromTicketCache();
        }
    }

    @Override
    public UserGroupInformation getRealUser(User user) {
        UserGroupInformation ugi = user.getUGI();
        if (ugi != null && ugi.getRealUser() != null) {
            return ugi.getRealUser();
        }
        return ugi;
    }
}

