/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.AesCtrCryptoCodec;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JceAesCtrCryptoCodec
extends AesCtrCryptoCodec {
    private static final Logger LOG = LoggerFactory.getLogger((String)JceAesCtrCryptoCodec.class.getName());
    private Configuration conf;
    private String provider;
    private SecureRandom random;

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.provider = conf.get("hadoop.security.crypto.jce.provider");
        String secureRandomAlg = conf.get("hadoop.security.java.secure.random.algorithm", "SHA1PRNG");
        try {
            this.random = this.provider != null ? SecureRandom.getInstance(secureRandomAlg, this.provider) : SecureRandom.getInstance(secureRandomAlg);
        }
        catch (GeneralSecurityException e) {
            LOG.warn(e.getMessage());
            this.random = new SecureRandom();
        }
    }

    @Override
    public Encryptor createEncryptor() throws GeneralSecurityException {
        return new JceAesCtrCipher(1, this.provider);
    }

    @Override
    public Decryptor createDecryptor() throws GeneralSecurityException {
        return new JceAesCtrCipher(2, this.provider);
    }

    @Override
    public void generateSecureRandom(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    private static class JceAesCtrCipher
    implements Encryptor,
    Decryptor {
        private final Cipher cipher;
        private final int mode;
        private boolean contextReset = false;

        public JceAesCtrCipher(int mode, String provider) throws GeneralSecurityException {
            this.mode = mode;
            this.cipher = provider == null || provider.isEmpty() ? Cipher.getInstance(AesCtrCryptoCodec.SUITE.getName()) : Cipher.getInstance(AesCtrCryptoCodec.SUITE.getName(), provider);
        }

        @Override
        public void init(byte[] key, byte[] iv) throws IOException {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(iv);
            this.contextReset = false;
            try {
                this.cipher.init(this.mode, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public void encrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        @Override
        public void decrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        private void process(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            try {
                int inputSize = inBuffer.remaining();
                int n = this.cipher.update(inBuffer, outBuffer);
                if (n < inputSize) {
                    this.contextReset = true;
                    this.cipher.doFinal(inBuffer, outBuffer);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean isContextReset() {
            return this.contextReset;
        }
    }
}

